/*
 * Decompiled with CFR 0.152.
 */
package er.woinstaller.archiver;

import er.woinstaller.archiver.XarEntry;
import er.woinstaller.archiver.XarException;
import er.woinstaller.io.BoundedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XarFile {
    private static final long XAR_HEADER_MAGIC = 2019652129L;
    private static final int XAR_HEADER_SIZE = 28;
    private static final String[] XAR_CKSUM = new String[]{"NONE", "SHA1", "MD5"};
    private static final int BYTE_MASK = 255;
    private final byte[] byte2 = new byte[2];
    private final byte[] byte4 = new byte[4];
    private final byte[] byte8 = new byte[8];
    private final Map<String, XarEntry> entries = new HashMap<String, XarEntry>();
    private File file;
    private XarHeader header;
    private XarToc toc;
    private InputStream inputStream;
    private InputStream lastInputStream;
    private long currentOffset = 0L;

    public XarFile(String string) throws IOException {
        this(new File(string));
    }

    public XarFile(File file) throws IOException {
        if (!file.exists() || file.length() < 28L) {
            throw new IOException("error reading header");
        }
        this.file = file;
        this.setInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    public XarFile(InputStream inputStream) throws IOException {
        this.setInputStream(inputStream);
    }

    private void setInputStream(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.header = new XarHeader();
        if (this.header.magic != 2019652129L) {
            throw new XarException("invalid magic header");
        }
        this.getToc();
        try {
            this.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entries.putAll(this.getToc().getEntries());
    }

    private XarToc getToc() {
        if (this.toc == null) {
            try {
                this.toc = new XarToc();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.toc;
    }

    public void run() throws IOException, NoSuchAlgorithmException {
    }

    public XarEntry getEntry(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name");
        }
        return this.entries.get(string);
    }

    public Map<String, XarEntry> getEntries() {
        return this.getToc().getEntries();
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(this.getEntry(string));
    }

    public InputStream getInputStream(XarEntry xarEntry) throws IOException {
        if (xarEntry == null) {
            throw new IllegalArgumentException("entry");
        }
        XarFile xarFile = this;
        synchronized (xarFile) {
            try {
                String string = xarEntry.getCompression();
                long l = 0L;
                if (this.lastInputStream != null) {
                    while (this.lastInputStream.read() != -1) {
                    }
                }
                if (xarEntry.getOffset() <= this.currentOffset) {
                    if (this.file == null) {
                        throw new XarException("Cannot seek backwards through stream");
                    }
                    this.lastInputStream.close();
                    this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
                    long l2 = (long)this.header.size + this.header.tocLengthCompressed.longValue();
                    XarFile.skipFully(this.inputStream, l2);
                    this.currentOffset = 0L;
                }
                l = xarEntry.getOffset() - this.currentOffset;
                this.currentOffset = xarEntry.getOffset() + xarEntry.getLength();
                InputStream inputStream = new BoundedInputStream(this.inputStream, l, xarEntry.getLength());
                if (string != null) {
                    if ("bzip2".equals(string)) {
                        XarFile.skipFully(inputStream, 2L);
                        inputStream = new CBZip2InputStream(inputStream);
                    } else if ("gzip".equals(string)) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                }
                this.lastInputStream = new XarInputStream(xarEntry, inputStream);
                return this.lastInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                throw new XarException("something unexpected happened");
            }
        }
    }

    private static void skipFully(InputStream inputStream, long l) throws IOException {
        for (long i = l; i > 0L; i -= inputStream.skip(i)) {
        }
    }

    private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; i += inputStream.read(byArray, i, byArray.length - i)) {
        }
    }

    private String getCksumName() {
        if (this.header.checksumAlgorithm < 0L || this.header.checksumAlgorithm > (long)(XAR_CKSUM.length - 1)) {
            return "unknown";
        }
        return XAR_CKSUM[(int)this.header.checksumAlgorithm];
    }

    private int readUint16() throws IOException {
        XarFile.readFully(this.inputStream, this.byte2);
        return (this.byte2[0] & 0xFF) << 8 | this.byte2[1] & 0xFF;
    }

    private long readUint32() throws IOException {
        XarFile.readFully(this.inputStream, this.byte4);
        long l = 0L;
        for (int i = 0; i < this.byte4.length; ++i) {
            l |= (long)((this.byte4[i] & 0xFF) << (this.byte4.length - (i + 1)) * 8);
        }
        return l;
    }

    private byte[] readByte8() throws IOException {
        XarFile.readFully(this.inputStream, this.byte8);
        return (byte[])this.byte8.clone();
    }

    private BigInteger readUint64() throws IOException {
        return new BigInteger(this.readByte8());
    }

    public class XarInputStream
    extends InputStream {
        private final InputStream _delegate;
        private final XarEntry _entry;
        private final MessageDigest _digest;

        public XarInputStream(XarEntry xarEntry, InputStream inputStream) {
            this._entry = xarEntry;
            this._delegate = inputStream;
            if (this._entry.hasChecksum()) {
                this._digest = this._entry.getMessageDigest(XarFile.this.getCksumName());
                this._digest.reset();
            } else {
                this._digest = null;
            }
        }

        @Override
        public int read() throws IOException {
            int n = this._delegate.read();
            if (n == -1) {
                if (!this.validChecksum()) {
                    throw new XarException("invalid checksum");
                }
                return n;
            }
            if (this._digest != null) {
                this._digest.update((byte)(n & 0xFF));
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this._delegate.read(byArray, n, n2);
            if (n3 == -1) {
                if (!this.validChecksum()) {
                    throw new XarException("invalid checksum");
                }
                return n3;
            }
            if (this._digest != null) {
                this._digest.update(byArray, n, n3);
            }
            return n3;
        }

        private boolean validChecksum() {
            if (this._digest != null) {
                String string = this.toChecksum(this._digest.digest());
                if (this._entry.hasChecksum() && !string.equals(this._entry.getExtractedChecksum())) {
                    return false;
                }
            }
            return true;
        }

        private String toChecksum(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                String string = Integer.toHexString(byArray[i] & 0xFF);
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    private class XarToc {
        private static final int BUFFER_SIZE = 255;
        private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        private DocumentBuilder builder;
        private Document doc;
        private String data;

        protected XarToc() throws IOException {
            try {
                this.data = this.readToc();
                this.builder = this.factory.newDocumentBuilder();
                this.doc = this.builder.parse(new InputSource(new StringReader(this.data)));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readToc() throws IOException {
            try (InflaterInputStream inflaterInputStream = new InflaterInputStream(new BoundedInputStream(XarFile.this.inputStream, 0L, ((XarFile)XarFile.this).header.tocLengthCompressed.longValue()));){
                int n;
                byte[] byArray = new byte[255];
                BigInteger bigInteger = new BigInteger(((XarFile)XarFile.this).header.tocLengthUncompressed.toByteArray());
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = ((InputStream)inflaterInputStream).read(byArray, 0, bigInteger.intValue() > 255 ? 255 : bigInteger.intValue())) > 0) {
                    stringBuffer.append(new String(byArray, 0, n));
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(n));
                }
                String string = stringBuffer.toString();
                return string;
            }
        }

        public String toString() {
            return this.data;
        }

        public Map<String, XarEntry> getEntries() {
            return XarEntry.getEntries(this.doc);
        }
    }

    private class XarHeader {
        private static final int SHORT_MASK = 65535;
        public long magic;
        public int size;
        public int version;
        public BigInteger tocLengthCompressed;
        public BigInteger tocLengthUncompressed;
        public long checksumAlgorithm;

        protected XarHeader() throws IOException {
            this.magic = XarFile.this.readUint32();
            this.size = XarFile.this.readUint16();
            this.version = XarFile.this.readUint16();
            this.tocLengthCompressed = XarFile.this.readUint64();
            this.tocLengthUncompressed = XarFile.this.readUint64();
            this.checksumAlgorithm = XarFile.this.readUint32();
        }

        public void dumpHeader() {
            System.out.println("\nmagic:\t\t\t 0x" + Long.toHexString(this.magic >> 16 & 0xFFFFL) + Long.toHexString(this.magic & 0xFFFFL) + " " + (this.magic == 2019652129L ? "(OK)" : "(BAD)"));
            System.out.println("size:\t\t\t " + this.size);
            System.out.println("version:\t\t " + this.version);
            System.out.println("Compressed TOC length:\t " + this.tocLengthCompressed);
            System.out.println("Uncompressed TOC length: " + this.tocLengthUncompressed);
            System.out.println("Checksum algorithm:\t " + this.checksumAlgorithm + " (" + XarFile.this.getCksumName() + ")");
        }
    }
}

