/*
 * Decompiled with CFR 0.152.
 */
package er.woinstaller.io;

import er.woinstaller.ui.IWOInstallerProgressMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class FileUtilities {
    public static void writeUrlToFile(URL uRL, File file, IWOInstallerProgressMonitor iWOInstallerProgressMonitor) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        int n = uRLConnection.getContentLength();
        FileUtilities.writeInputStreamToFile(uRLConnection.getInputStream(), file, n, iWOInstallerProgressMonitor);
    }

    public static void writeInputStreamToFile(InputStream inputStream, File file, int n, IWOInstallerProgressMonitor iWOInstallerProgressMonitor) throws IOException {
        BufferedOutputStream bufferedOutputStream;
        try {
            if (file == null) {
                throw new IllegalArgumentException("Attempting to write to a null file!");
            }
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                throw new IllegalArgumentException("Failed to create directory " + file2.getAbsolutePath());
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            inputStream.close();
            throw runtimeException;
        }
        FileUtilities.writeInputStreamToOutputStream(inputStream, bufferedOutputStream, n, iWOInstallerProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, int n, IWOInstallerProgressMonitor iWOInstallerProgressMonitor) throws IOException {
        try {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                byte[] byArray = new byte[51200];
                int n2 = -1;
                while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                    outputStream.write(byArray, 0, n2);
                    iWOInstallerProgressMonitor.worked(n2);
                    if (!iWOInstallerProgressMonitor.isCanceled()) continue;
                    throw new IOException("Operation canceled");
                }
            }
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }
}

