/*
 * Decompiled with CFR 0.152.
 */
package er.woinstaller.io;

import er.woinstaller.io.BlockEntry;
import er.woinstaller.io.BoundedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiBlockInputStream
extends InputStream {
    private final InputStream _inputSource;
    private final List<BlockEntry> _blockList;
    private InputStream _delegate;
    private int _blockPosition = 0;
    private BlockEntry _currentBlock = null;

    public MultiBlockInputStream(InputStream inputStream, List<BlockEntry> list) {
        this._inputSource = inputStream;
        ArrayList<BlockEntry> arrayList = new ArrayList<BlockEntry>();
        arrayList.addAll(list);
        this._blockList = arrayList;
    }

    @Override
    public int read() throws IOException {
        if (this._delegate == null) {
            this._delegate = this.getNextDelegate();
        }
        if (this._delegate == null) {
            return -1;
        }
        int n = this._delegate.read();
        if (n == -1) {
            this._delegate = this.getNextDelegate();
            if (this._delegate != null) {
                return this._delegate.read();
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._delegate == null) {
            this._delegate = this.getNextDelegate();
        }
        if (this._delegate == null) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n2) {
            n3 = this._delegate.read(byArray, n, n2);
            if (n3 >= n2) continue;
            int n4 = this._delegate.read(byArray, n + n3, n2 - n3);
            if (n4 != -1) {
                n3 += n4;
                continue;
            }
            this._delegate = this.getNextDelegate();
            if (this._delegate != null) continue;
            return n3;
        }
        return n3;
    }

    private InputStream getNextDelegate() throws IOException {
        if (this._delegate != null) {
            this._delegate = null;
            ++this._blockPosition;
        }
        if (this._blockList.size() > this._blockPosition) {
            BlockEntry blockEntry = this._blockList.get(this._blockPosition);
            long l = blockEntry.offset;
            if (this._currentBlock != null && this._currentBlock != blockEntry) {
                l -= this._currentBlock.offset + this._currentBlock.length;
            }
            this._currentBlock = blockEntry;
            this._delegate = new BoundedInputStream(this._inputSource, l, blockEntry.length);
        }
        return this._delegate;
    }
}

