/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wooeditor.plisteditor;

import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.objectstyle.wolips.wooeditor.plisteditor.IPlistColorConstants;
import org.objectstyle.wolips.wooeditor.plisteditor.PlistDoubleClickStrategy;
import org.objectstyle.wolips.wooeditor.plisteditor.PlistScanner;
import org.objectstyle.wolips.wooeditor.plisteditor.PlistTokenScanner;

public class PlistConfiguration
extends SourceViewerConfiguration {
    private PlistDoubleClickStrategy doubleClickStrategy;
    private PlistTokenScanner tokenScanner;
    private PlistScanner scanner;
    private IColorManager colorManager;

    public PlistConfiguration(IColorManager colorManager2) {
        this.colorManager = colorManager2;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__property", "__value"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new PlistDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected PlistScanner getPlistScanner() {
        if (this.scanner == null) {
            this.scanner = new PlistScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IPlistColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected PlistTokenScanner getPlistTokenScanner() {
        if (this.tokenScanner == null) {
            this.tokenScanner = new PlistTokenScanner(this.colorManager);
            this.tokenScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IPlistColorConstants.VALUE))));
        }
        return this.tokenScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getPlistTokenScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__property");
        reconciler.setRepairer((IPresentationRepairer)dr, "__property");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPlistScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }
}

