/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.antlauncher.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.objectstyle.wolips.ant.antlaunchers.IAntlauncher;

public class DefaultAntlauncher
implements IAntlauncher {
    private static final String MAIN_TYPE_NAME = "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner";
    private static final String REMOTE_ANT_PROCESS_FACTORY_ID = "org.eclipse.ant.ui.remoteAntProcessFactory";
    private static final String ID_ANT_LAUNCH_CONFIGURATION_TYPE = "org.eclipse.ant.AntLaunchConfigurationType";
    private static final String ATTR_ANT_TARGETS = "org.eclipse.ui.externaltools.ATTR_ANT_TARGETS";
    private static final String ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchAntInExternalVM(IFile buildFile, IProgressMonitor monitor, boolean captureOutput, String targets) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = null;
        try {
            workingCopy = DefaultAntlauncher.createDefaultLaunchConfiguration(buildFile, captureOutput, targets);
            ILaunch launch = workingCopy.launch("run", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!captureOutput) {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                manager.removeLaunch(launch);
            }
        }
        finally {
            workingCopy = null;
        }
    }

    private static ILaunchConfigurationWorkingCopy createDefaultLaunchConfiguration(IFile file, boolean captureOutput, String targets) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID_ANT_LAUNCH_CONFIGURATION_TYPE);
        StringBuffer buffer = new StringBuffer(file.getProject().getName());
        buffer.append(' ');
        buffer.append(file.getName());
        buffer.append(" (WOLips)");
        String name = buffer.toString().trim();
        name = manager.generateUniqueLaunchConfigurationNameFrom(name);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        workingCopy.setAttribute(ATTR_LOCATION, VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", file.getFullPath().toString()));
        workingCopy.setAttribute("org.eclipse.jdt.launching.WORKING_DIRECTORY", file.getProject().getLocation().toOSString());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, MAIN_TYPE_NAME);
        workingCopy.setAttribute("process_factory_id", REMOTE_ANT_PROCESS_FACTORY_ID);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-Xms256m -Xmx512m");
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        if (captureOutput) {
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", true);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", true);
        } else {
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", false);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", false);
        }
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, file.getProject().getName());
        workingCopy.setAttribute(ATTR_ANT_TARGETS, targets);
        workingCopy.setAttribute("org.objectstyle.wolips.launching.antlauncher.internal.BuildFailedConsoleLineTrackerEnabled", true);
        workingCopy.setAttribute("org.eclipse.jdt.launching.JRE_CONTAINER", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5");
        workingCopy.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
        return workingCopy;
    }
}

