/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLProcessingInstruction;
import jp.aonir.fuzzyxml.internal.FuzzyXMLFormatComposite;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.RenderDelegate;
import jp.aonir.fuzzyxml.internal.WOHTMLRenderDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.TemplateRefactoring;

public class FormatRefactoring
implements IRunnableWithProgress {
    private WodParserCache _cache;

    public FormatRefactoring(WodParserCache cache) {
        this._cache = cache;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this._cache.clearCache();
            FuzzyXMLDocument htmlModel = (FuzzyXMLDocument)this._cache.getHtmlEntry().getModel();
            FuzzyXMLElement documentElement = htmlModel.getDocumentElement();
            IDocument htmlDocument = this._cache.getHtmlEntry().getDocument();
            IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
            RenderContext renderContext = new RenderContext(true);
            renderContext.setShowNewlines(true);
            renderContext.setIndentSize(prefs.getInt("IndentSize"));
            renderContext.setIndentTabs(prefs.getBoolean("IndentTabs"));
            renderContext.setTrim(true);
            renderContext.setLowercaseAttributes(prefs.getBoolean("LowercaseAttributes"));
            renderContext.setLowercaseTags(prefs.getBoolean("LowercaseTags"));
            renderContext.setSpacesAroundEquals(prefs.getBoolean("SpacesAroundEquals"));
            renderContext.setSpaceInEmptyTags(true);
            renderContext.setAddMissingQuotes(true);
            renderContext.setDelegate((RenderDelegate)new WOHTMLRenderDelegate(prefs.getBoolean("StickyWOTags")));
            StringBuffer htmlBuffer = new StringBuffer();
            FuzzyXMLDocType docType = htmlModel.getDocumentType();
            for (FuzzyXMLNode node : documentElement.getChildren()) {
                if (docType != null && !(node instanceof FuzzyXMLProcessingInstruction) && !FuzzyXMLFormatComposite.isHidden((FuzzyXMLNode)node)) {
                    docType.toXMLString(renderContext, htmlBuffer);
                    docType = null;
                }
                node.toXMLString(renderContext, htmlBuffer);
            }
            htmlDocument.set(htmlBuffer.toString().trim());
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Failed to reformat.");
        }
    }

    public static void run(WodParserCache cache, IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
        TemplateRefactoring.processHtmlAndWod(new FormatRefactoring(cache), cache, progressMonitor);
    }
}

