/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.WodFileDocumentProvider;

public class TemplateRefactoring {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processHtmlAndWod(IRunnableWithProgress runnable, WodParserCache cache, IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
        block11: {
            IFile htmlFile;
            IDocument htmlDocument = cache.getHtmlEntry().getDocument();
            FileEditorInput htmlInput = null;
            TextFileDocumentProvider htmlProvider = null;
            if (htmlDocument == null && (htmlFile = cache.getHtmlEntry().getFile()) != null) {
                htmlInput = new FileEditorInput(cache.getHtmlEntry().getFile());
                htmlProvider = new TextFileDocumentProvider();
                htmlProvider.connect((Object)htmlInput);
                htmlDocument = htmlProvider.getDocument((Object)htmlInput);
                cache.getHtmlEntry().setDocument(htmlDocument);
            }
            try {
                IFile wodFile;
                IDocument wodDocument = cache.getWodEntry().getDocument();
                WodFileDocumentProvider wodProvider = null;
                FileEditorInput wodInput = null;
                if (wodDocument == null && (wodFile = cache.getWodEntry().getFile()) != null) {
                    wodInput = new FileEditorInput(cache.getWodEntry().getFile());
                    wodProvider = new WodFileDocumentProvider();
                    wodProvider.connect(wodInput);
                    wodDocument = wodProvider.getDocument(wodInput);
                    cache.getWodEntry().setDocument(wodDocument);
                }
                try {
                    runnable.run(progressMonitor);
                }
                finally {
                    if (wodProvider != null) {
                        wodProvider.saveDocument(progressMonitor, wodInput, wodDocument, true);
                        wodProvider.disconnect(wodInput);
                        cache.getWodEntry().setDocument(null);
                    }
                }
                if (htmlProvider == null) break block11;
            }
            catch (Throwable throwable) {
                if (htmlProvider == null) throw throwable;
                htmlProvider.saveDocument(progressMonitor, htmlInput, htmlDocument, true);
                htmlProvider.disconnect((Object)htmlInput);
                cache.getHtmlEntry().setDocument(null);
                throw throwable;
            }
            htmlProvider.saveDocument(progressMonitor, (Object)htmlInput, htmlDocument, true);
            htmlProvider.disconnect((Object)htmlInput);
            cache.getHtmlEntry().setDocument(null);
        }
        try {
            cache.clearCache();
            return;
        }
        catch (LocateException e) {
            e.printStackTrace();
        }
    }
}

