/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.RenderContext;

public class FuzzyXMLDocTypeImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLDocType {
    private String _name;
    private String _publicId;
    private String _systemId;
    private String _internalSubset;

    public FuzzyXMLDocTypeImpl(FuzzyXMLNode parent, String name, String publicId, String systemId, String internalSubset, int offset, int length) {
        super(parent, offset, length);
        this._name = name;
        this._publicId = publicId;
        this._systemId = systemId;
        this._internalSubset = internalSubset;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getPublicId() {
        return this._publicId;
    }

    @Override
    public String getSystemId() {
        return this._systemId;
    }

    @Override
    public String getInternalSubset() {
        return this._internalSubset;
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        this.toDebugString(sb, 0);
        return sb.toString();
    }

    @Override
    public void toDebugString(StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append("  ");
        }
        buffer.append("doctype: " + this._name + ", " + this._publicId + ", " + this._systemId + ", " + this._internalSubset + "\n");
    }

    @Override
    public void toXMLString(RenderContext renderContext, StringBuffer xmlBuffer) {
        xmlBuffer.append("<!DOCTYPE ").append(this._name);
        if (this._publicId != null && !this._publicId.equals("")) {
            xmlBuffer.append(" PUBLIC ");
            xmlBuffer.append("\"").append(this._publicId).append("\"");
            if (this._systemId != null && !this._systemId.equals("")) {
                xmlBuffer.append(" \"").append(this._systemId).append("\"");
            }
        } else if (this._systemId != null && !this._systemId.equals("")) {
            xmlBuffer.append(" SYSTEM ");
            xmlBuffer.append(" \"").append(this._systemId).append("\"");
        }
        if (this._internalSubset != null && !this._internalSubset.equals("")) {
            xmlBuffer.append("[").append(this._internalSubset).append("]");
        }
        xmlBuffer.append(">");
        if (renderContext.isShowNewlines()) {
            xmlBuffer.append("\n");
        }
    }

    public String toString() {
        return "DOCTYPE: " + this._name;
    }
}

