/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.xpath;

import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class FuzzyXMLAttrIterator
implements NodeIterator {
    private NodePointer _parent;
    private List<FuzzyXMLAttribute> _attributes;
    private int _position;

    public FuzzyXMLAttrIterator(NodePointer parent, QName name) {
        block5: {
            this._position = 0;
            this._parent = parent;
            if (!(parent.getNode() instanceof FuzzyXMLElement)) break block5;
            FuzzyXMLElement element = (FuzzyXMLElement)parent.getNode();
            String prefix = name.getPrefix();
            String lname = name.getName();
            if (prefix != null && !prefix.equals("")) {
                lname = prefix + ":" + lname;
            }
            if (!lname.equals("*")) {
                this._attributes = new ArrayList<FuzzyXMLAttribute>();
                FuzzyXMLAttribute[] allAttributes = element.getAttributes();
                for (int i = 0; i < allAttributes.length; ++i) {
                    if (!allAttributes[i].getName().equals(lname)) continue;
                    this._attributes.add(allAttributes[i]);
                    break;
                }
            } else {
                this._attributes = new ArrayList<FuzzyXMLAttribute>();
                FuzzyXMLAttribute[] allAttributes = element.getAttributes();
                for (int i = 0; i < allAttributes.length; ++i) {
                    this._attributes.add(allAttributes[i]);
                }
            }
        }
    }

    public int getPosition() {
        return this._position;
    }

    public boolean setPosition(int position) {
        if (this._attributes == null) {
            return false;
        }
        this._position = position;
        return position >= 1 && position <= this._attributes.size();
    }

    public NodePointer getNodePointer() {
        int index;
        if (this._position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this._position = 0;
        }
        if ((index = this._position - 1) < 0) {
            index = 0;
        }
        return new FuzzyXMLNodePointer(this._parent, this._attributes.get(index));
    }
}

