/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.templateeditor.InlineWodTagInfo;
import org.objectstyle.wolips.wodclipse.core.Activator;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeValueDefinition;
import tk.eclipse.plugin.htmleditor.assist.CSSAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.CustomAttribute;
import tk.eclipse.plugin.htmleditor.assist.CustomElement;
import tk.eclipse.plugin.htmleditor.assist.HTMLDeprecatedCompletionProposal;
import tk.eclipse.plugin.htmleditor.assist.TagDefinition;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.assist.TextInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.template.HTMLTemplateAssistProcessor;

public class HTMLAssistProcessor
extends HTMLTemplateAssistProcessor {
    private boolean _xhtmlMode = false;
    private char[] _chars = new char[0];
    private Image _tagImage;
    private Image _attrImage;
    private Image _valueImage;
    private boolean _assistCloseTag = true;
    private List<CustomAttribute> _customAttrs = CustomAttribute.loadFromPreference(false);
    private List<CustomElement> _customElems = CustomElement.loadFromPreference(false);
    private Set<String> _customElemNames = new HashSet<String>();
    protected CSSAssistProcessor _cssAssist = new CSSAssistProcessor();
    protected IFileAssistProcessor[] _fileAssistProcessors;
    private int _offset;
    private FuzzyXMLDocument _doc;
    private ITextViewer _textViewer;

    public HTMLAssistProcessor() {
        this._tagImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
        this._attrImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_attribute");
        this._valueImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_value");
        this._fileAssistProcessors = HTMLPlugin.getDefault().getFileAssistProcessors();
        for (int i = 0; i < this._customElems.size(); ++i) {
            this._customElemNames.add(this._customElems.get(i).getDisplayName());
        }
    }

    public boolean enableTemplate() {
        return true;
    }

    public void setXHTMLMode(boolean xhtmlMode) {
        this._xhtmlMode = xhtmlMode;
    }

    public void setAutoAssistChars(char[] chars) {
        if (chars != null) {
            this._chars = chars;
        }
    }

    public void setAssistCloseTag(boolean assistCloseTag) {
        this._assistCloseTag = assistCloseTag;
    }

    protected AssistInfo[] getAttributeValues(String tagName, String value, TagInfo tagInfo, AttributeInfo attrInfo) {
        if (attrInfo.getAttributeType() == 4) {
            return this._cssAssist.getAssistInfo(tagName, value);
        }
        if (attrInfo.getAttributeType() == 5) {
            ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
            for (int i = 0; i < this._fileAssistProcessors.length; ++i) {
                AssistInfo[] assists = this._fileAssistProcessors[i].getAssistInfo(value);
                for (int j = 0; j < assists.length; ++j) {
                    list.add(assists[j]);
                }
            }
            return list.toArray(new AssistInfo[list.size()]);
        }
        if (attrInfo.getAttributeType() == 7) {
            ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
            String[] ids = this.getIDs();
            for (int i = 0; i < ids.length; ++i) {
                list.add(new AssistInfo(ids[i]));
            }
            return list.toArray(new AssistInfo[list.size()]);
        }
        if (attrInfo.getAttributeType() == 8) {
            ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
            String[] ids = this.getIDs();
            String prefix = value;
            if (prefix.length() != 0 && !prefix.endsWith(" ")) {
                prefix = prefix + " ";
            }
            for (int i = 0; i < ids.length; ++i) {
                list.add(new AssistInfo(prefix + ids[i], ids[i]));
            }
            return list.toArray(new AssistInfo[list.size()]);
        }
        String[] values = AttributeValueDefinition.getAttributeValues(attrInfo.getAttributeType());
        AssistInfo[] infos = new AssistInfo[values.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new AssistInfo(values[i]);
        }
        return infos;
    }

    protected String[] getIDs() {
        FuzzyXMLDocument doc = this.getDocument();
        ArrayList<String> list = new ArrayList<String>();
        if (doc != null) {
            FuzzyXMLElement element = doc.getDocumentElement();
            this.extractID(element, list);
        }
        return list.toArray(new String[list.size()]);
    }

    private void extractID(FuzzyXMLElement element, List<String> list) {
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            AttributeInfo attrInfo;
            TagInfo tagInfo = this.getTagInfo(element.getName());
            if (tagInfo == null || (attrInfo = tagInfo.getAttributeInfo(attrs[i].getName())) == null || attrInfo.getAttributeType() != 6) continue;
            list.add(attrs[i].getValue());
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FuzzyXMLElement)) continue;
            this.extractID((FuzzyXMLElement)nodes[i], list);
        }
    }

    protected List<TagInfo> getTagList() {
        return TagDefinition.getTagInfoAsList();
    }

    protected TagInfo getTagInfo(String name) {
        List<TagInfo> tagList = TagDefinition.getTagInfoAsList();
        for (int i = 0; i < tagList.size(); ++i) {
            TagInfo info = tagList.get(i);
            if (!info.getTagName().equals(name)) continue;
            return info;
        }
        return null;
    }

    protected FuzzyXMLElement getOffsetElement() {
        return this._doc.getElementByOffset(this._offset);
    }

    protected FuzzyXMLDocument getDocument() {
        return this._doc;
    }

    protected ITextViewer getTextViewer() {
        return this._textViewer;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        TagInfo info;
        this._textViewer = viewer;
        IDocument document = viewer.getDocument();
        String text = document.get().substring(0, documentOffset);
        String[] dim = this.getLastWord(text);
        String word = dim[0].toLowerCase();
        String prev = dim[1].toLowerCase();
        String last = dim[2];
        String attr = dim[3];
        boolean inTag = false;
        boolean spacesAroundEquals = Activator.getDefault().getPreferenceStore().getBoolean("SpacesAroundEquals");
        String equals = spacesAroundEquals ? " = " : "=";
        try {
            char ch;
            for (int i = documentOffset; i < document.getLength() && (ch = document.getChar(i)) != '<'; ++i) {
                if (ch != '>') continue;
                inTag = true;
                break;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        String next = document.get().substring(documentOffset);
        this._offset = documentOffset;
        this._doc = new FuzzyXMLParser(false).parse(document.get());
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        List<TagInfo> tagList = this.getTagList();
        if (word.startsWith("\"") && (word.length() == 1 || !word.endsWith("\"")) || word.startsWith("'") && (word.length() == 1 || !word.endsWith("'"))) {
            String value = dim[0].substring(1);
            TagInfo tagInfo = this.getTagInfo(last.toLowerCase());
            if (tagInfo != null) {
                AttributeInfo attrInfo = tagInfo.getAttributeInfo(attr);
                if (attrInfo == null) {
                    attrInfo = new AttributeInfo(attr, true);
                }
                if (attrInfo != null) {
                    AssistInfo[] keywords = this.getAttributeValues(last, dim[0].substring(1), tagInfo, attrInfo);
                    for (int i = 0; i < keywords.length; ++i) {
                        if (keywords[i].getOffset() <= 0 && !keywords[i].getReplaceString().toLowerCase().startsWith(value.toLowerCase())) continue;
                        list.add(keywords[i].toCompletionProposal(documentOffset, value, this._valueImage));
                    }
                }
            }
        } else if (word.startsWith("<") && !word.startsWith("</")) {
            int i;
            List<TagInfo> dynamicTagInfo;
            if (this.supportTagRelation()) {
                TagInfo parent = this.getTagInfo(last);
                tagList = new ArrayList<TagInfo>();
                if (parent != null) {
                    String[] childNames = parent.getChildTagNames();
                    for (int i2 = 0; i2 < childNames.length; ++i2) {
                        tagList.add(this.getTagInfo(childNames[i2]));
                    }
                }
            }
            if ((dynamicTagInfo = this.getDynamicTagInfo(word.substring(1))) != null) {
                tagList.addAll(dynamicTagInfo);
            }
            for (i = 0; i < tagList.size(); ++i) {
                boolean forceAttributePosition;
                AttributeInfo[] requireAttrs;
                TagInfo tagInfo = tagList.get(i);
                if (tagInfo instanceof TextInfo) {
                    TextInfo textInfo = (TextInfo)tagInfo;
                    if (textInfo.getText().toLowerCase().indexOf(word) != 0) continue;
                    list.add((ICompletionProposal)new CompletionProposal(textInfo.getText(), documentOffset - word.length(), word.length(), textInfo.getPosition(), this._tagImage, textInfo.getDisplayString(), null, tagInfo.getDescription()));
                    continue;
                }
                String tagName = tagInfo.getTagName();
                String tagNameMatch = "<" + tagName.toLowerCase();
                if (!tagNameMatch.startsWith(word) || tagNameMatch.equals(word) && next.startsWith(">")) continue;
                String assistKeyword = tagName;
                int position = 0;
                if (inTag) {
                    requireAttrs = new AttributeInfo[]{};
                    position = tagName.length() + 1;
                } else {
                    requireAttrs = tagInfo.getRequiredAttributeInfo();
                    for (int j = 0; j < requireAttrs.length; ++j) {
                        assistKeyword = assistKeyword + " " + requireAttrs[j].getAttributeName();
                        if (!requireAttrs[j].hasValue()) continue;
                        assistKeyword = assistKeyword + equals + "\"\"";
                        if (j != 0) continue;
                        position = tagName.length() + requireAttrs[j].getAttributeName().length() + (spacesAroundEquals ? 5 : 3);
                    }
                }
                boolean bl = forceAttributePosition = requireAttrs.length == 0 && tagInfo.requiresAttributes();
                if (!inTag) {
                    if (tagInfo.hasBody()) {
                        assistKeyword = assistKeyword + ">";
                        if (this._assistCloseTag) {
                            if (position == 0) {
                                position = assistKeyword.length();
                            }
                            assistKeyword = assistKeyword + "</" + tagName + ">";
                        }
                    } else {
                        assistKeyword = tagInfo.isEmptyTag() && !this._xhtmlMode ? assistKeyword + ">" : assistKeyword + "/>";
                    }
                }
                if (position == 0) {
                    position = assistKeyword.length();
                }
                if (forceAttributePosition && position > 0) {
                    if (tagInfo.hasBody()) {
                        --position;
                    } else if (tagInfo.isEmptyTag()) {
                        position = this._xhtmlMode ? (position -= 2) : --position;
                    }
                }
                try {
                    if (tagInfo instanceof InlineWodTagInfo && BindingReflectionUtils.memberIsDeprecated((IMember)((InlineWodTagInfo)tagInfo).getElementType())) {
                        list.add(new HTMLDeprecatedCompletionProposal(assistKeyword, documentOffset - word.length() + 1, word.length() - 1, position, this._tagImage, tagName, null, tagInfo.getDescription()));
                        continue;
                    }
                    list.add((ICompletionProposal)new CompletionProposal(assistKeyword, documentOffset - word.length() + 1, word.length() - 1, position, this._tagImage, tagName, null, tagInfo.getDescription()));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (i = 0; i < this._customElems.size(); ++i) {
                CustomElement element = this._customElems.get(i);
                if (element.getAssistString().toLowerCase().indexOf(word) != 0) continue;
                int position = element.getAssistString().indexOf(34);
                if (position == -1) {
                    position = element.getAssistString().indexOf("><");
                }
                if (position == -1) {
                    position = element.getAssistString().length();
                }
                list.add((ICompletionProposal)new CompletionProposal(element.getAssistString(), documentOffset - word.length(), word.length(), position + 1, this._tagImage, element.getDisplayName(), null, null));
            }
        } else if (!prev.equals("")) {
            String tagName = prev;
            TagInfo tagInfo = this.getTagInfo(tagName);
            if (tagInfo != null) {
                AttributeInfo[] attrList = tagInfo.getAttributeInfo();
                for (int j = 0; j < attrList.length; ++j) {
                    if (attrList[j].getAttributeName().toLowerCase().indexOf(word) != 0) continue;
                    String assistKeyword = null;
                    int position = 0;
                    if (attrList[j].hasValue()) {
                        assistKeyword = attrList[j].getAttributeName() + equals + "\"\"";
                        position = equals.length() + 1;
                    } else {
                        assistKeyword = attrList[j].getAttributeName();
                        position = 0;
                    }
                    list.add((ICompletionProposal)new CompletionProposal(assistKeyword, documentOffset - word.length(), word.length(), attrList[j].getAttributeName().length() + position, this._attrImage, attrList[j].getAttributeName(), null, attrList[j].getDescription()));
                }
            }
            for (int i = 0; i < this._customAttrs.size(); ++i) {
                CustomAttribute attrInfo = this._customAttrs.get(i);
                if (!attrInfo.getTargetTag().equals("*") && !attrInfo.getTargetTag().equals(tagName) || tagName.indexOf(":") >= 0 && !this._customElemNames.contains(tagName)) continue;
                list.add((ICompletionProposal)new CompletionProposal(attrInfo.getAttributeName() + equals + "\"\"", documentOffset - word.length(), word.length(), attrInfo.getAttributeName().length() + 2, this._attrImage, attrInfo.getAttributeName(), null, null));
            }
        } else if (!last.equals("") && ((info = this.getTagInfo(last)) == null || this._xhtmlMode || info.hasBody() || !info.isEmptyTag())) {
            String assistKeyword = "</" + last + ">";
            int length = 0;
            if (assistKeyword.toLowerCase().startsWith(word)) {
                length = word.length();
            }
            list.add((ICompletionProposal)new CompletionProposal(assistKeyword, documentOffset - length, length, assistKeyword.length(), this._tagImage, assistKeyword, null, null));
        }
        HTMLUtil.sortCompilationProposal(list);
        if (this.enableTemplate()) {
            ICompletionProposal[] templates = super.computeCompletionProposals(viewer, documentOffset);
            for (int i = 0; i < templates.length; ++i) {
                list.add(templates[i]);
            }
        }
        ICompletionProposal[] prop = list.toArray(new ICompletionProposal[list.size()]);
        return prop;
    }

    protected List<TagInfo> getDynamicTagInfo(String tagName) {
        return null;
    }

    protected boolean supportTagRelation() {
        return false;
    }

    protected String[] getLastWord(String text) {
        StringBuffer sb = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        String word = "";
        String prevTag = "";
        String lastTag = "";
        String attr = "";
        String temp1 = "";
        String temp2 = "";
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '<' && text.length() > i + 1 && text.charAt(i + 1) == '%') {
                if ((i = text.indexOf("%>", i + 2)) != -1) continue;
                i = text.length();
                continue;
            }
            if (c == '<' && text.length() > i + 1 && text.charAt(i + 1) == '?') {
                if ((i = text.indexOf("?>", i + 2)) != -1) continue;
                i = text.length();
                continue;
            }
            if (this.isDelimiter(c)) {
                temp1 = sb.toString();
                if (temp1.length() > 1 && (temp1.startsWith("\"") && !temp1.endsWith("\"") && c != '\"' || temp1.startsWith("'") && !temp1.endsWith("'") && c != '\'')) {
                    sb.append(c);
                    continue;
                }
                if (!temp1.equals("") && (temp2 = temp1).endsWith("=") && !prevTag.equals("") && !temp2.equals("=")) {
                    attr = temp2.substring(0, temp2.length() - 1);
                }
                if (temp1.startsWith("<") && !temp1.startsWith("</") && !temp1.startsWith("<!")) {
                    prevTag = temp1.substring(1);
                    if (!temp1.endsWith("/")) {
                        stack.push(prevTag);
                    }
                } else if (temp1.startsWith("</") && stack.size() != 0) {
                    stack.pop();
                } else if (temp1.endsWith("/") && stack.size() != 0) {
                    stack.pop();
                }
                sb.setLength(0);
                if (c == '<') {
                    sb.append(c);
                    continue;
                }
                if (c == '\"' || c == '\'') {
                    if (temp1.startsWith("\"") || temp1.startsWith("'")) {
                        sb.append(temp1);
                    }
                    sb.append(c);
                    continue;
                }
                if (c != '>') continue;
                prevTag = "";
                attr = "";
                continue;
            }
            if (c == '=' && !prevTag.equals("")) {
                attr = temp2.trim();
            }
            if ((temp1 = sb.toString()).length() > 1 && temp1.startsWith("\"") && temp1.endsWith("\"") || temp1.startsWith("'") && temp1.endsWith("'")) {
                sb.setLength(0);
            }
            sb.append(c);
        }
        if (stack.size() != 0) {
            lastTag = (String)stack.pop();
        }
        if (attr.endsWith("=")) {
            attr = attr.substring(0, attr.length() - 1);
        }
        word = sb.toString();
        return new String[]{word, prevTag, lastTag, attr};
    }

    protected boolean isDelimiter(char c) {
        return c == ' ' || c == '(' || c == ')' || c == ',' || c == ';' || c == '\n' || c == '\r' || c == '\t' || c == '+' || c == '>' || c == '<' || c == '*' || c == '^' || c == '\"' || c == '\'';
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        ContextInformation[] info = new ContextInformation[]{};
        return info;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this._chars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this._chars;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public String getErrorMessage() {
        return "Error";
    }

    public void update(HTMLSourceEditor editor, String source) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            int i;
            IFileEditorInput input = (IFileEditorInput)editorInput;
            this._cssAssist.reload(input.getFile(), source);
            this._customAttrs = CustomAttribute.loadFromPreference(false);
            this._customElems = CustomElement.loadFromPreference(false);
            this._customElemNames.clear();
            for (i = 0; i < this._customElems.size(); ++i) {
                this._customElemNames.add(this._customElems.get(i).getDisplayName());
            }
            for (i = 0; i < this._fileAssistProcessors.length; ++i) {
                this._fileAssistProcessors[i].reload(input.getFile());
            }
        }
    }
}

