/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateArgumentFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateArgumentNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateStoredProcedureNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOArgument;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOLastModified;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelParserDataStructureFactory;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedureEntityReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedureFetchSpecReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;

public class EOStoredProcedure
extends UserInfoableEOModelObject<EOModel>
implements ISortableEOModelObject {
    public static final String NAME = "name";
    public static final String EXTERNAL_NAME = "externalName";
    public static final String ARGUMENT = "argument";
    public static final String ARGUMENTS = "arguments";
    private EOModel myModel;
    private String myName;
    private String myExternalName;
    private List<EOArgument> myArguments;
    private EOModelMap myStoredProcedureMap = new EOModelMap();
    private boolean _storedProcedureDirty = true;
    private EOLastModified _lastModified;

    public EOStoredProcedure() {
        this.myArguments = new LinkedList<EOArgument>();
    }

    public EOStoredProcedure(String _name) {
        this();
        this.myName = _name;
    }

    public void setStoredProcedureDirty(boolean storedProcedureDirty) {
        this._storedProcedureDirty = storedProcedureDirty;
    }

    public boolean isStoredProcedureDirty() {
        return this._storedProcedureDirty;
    }

    public void pasted() {
        for (EOArgument argument : this.myArguments) {
            argument.pasted();
        }
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        HashSet<EOModelReferenceFailure> referenceFailures = new HashSet<EOModelReferenceFailure>();
        for (EOArgument argument : this.myArguments) {
            referenceFailures.addAll(argument.getReferenceFailures());
        }
        if (this.myModel != null) {
            for (EOEntity entity : this.myModel.getEntities()) {
                if (entity.getDeleteProcedure() == this) {
                    referenceFailures.add(new EOStoredProcedureEntityReferenceFailure(entity, this, "deleteProcedure"));
                }
                if (entity.getInsertProcedure() == this) {
                    referenceFailures.add(new EOStoredProcedureEntityReferenceFailure(entity, this, "insertProcedure"));
                }
                if (entity.getNextPrimaryKeyProcedure() == this) {
                    referenceFailures.add(new EOStoredProcedureEntityReferenceFailure(entity, this, "nextPrimaryKeyProcedure"));
                }
                if (entity.getFetchWithPrimaryKeyProcedure() == this) {
                    referenceFailures.add(new EOStoredProcedureEntityReferenceFailure(entity, this, "fetchWithPrimaryKeyProcedure"));
                }
                if (entity.getFetchAllProcedure() == this) {
                    referenceFailures.add(new EOStoredProcedureEntityReferenceFailure(entity, this, "fetchAllProcedure"));
                }
                for (EOFetchSpecification fetchSpec : entity.getFetchSpecs()) {
                    if (fetchSpec.getStoredProcedure() != this) continue;
                    referenceFailures.add(new EOStoredProcedureFetchSpecReferenceFailure(fetchSpec, this));
                }
            }
        }
        return referenceFailures;
    }

    public void _setModel(EOModel _model) {
        this.myModel = _model;
    }

    public EOModel getModel() {
        return this.myModel;
    }

    protected void _argumentChanged(EOArgument _argument, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange(ARGUMENT, null, _argument);
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myModel != null) {
            this.setStoredProcedureDirty(true);
            this.myModel._storedProcedureChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    @Override
    public void setName(String _name) throws DuplicateStoredProcedureNameException {
        this.setName(_name, true);
    }

    public void setName(String _name, boolean _fireEvents) throws DuplicateStoredProcedureNameException {
        if (this.myModel != null) {
            this.myModel._checkForDuplicateStoredProcedureName(this, _name, null);
            this.myModel._storedProcedureNameChanged(this.myName, _name);
        }
        String oldName = this.myName;
        this.myName = _name;
        if (_fireEvents) {
            this.firePropertyChange(NAME, oldName, this.myName);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String getExternalName() {
        return this.myExternalName;
    }

    public void setExternalName(String _externalName) {
        String oldExternalName = this.myExternalName;
        this.myExternalName = _externalName;
        this.firePropertyChange(EXTERNAL_NAME, oldExternalName, this.myExternalName);
    }

    public EOArgument getArgumentNamed(String _name) {
        EOArgument matchingArgument = null;
        Iterator<EOArgument> argumentsIter = this.myArguments.iterator();
        while (matchingArgument == null && argumentsIter.hasNext()) {
            EOArgument argument = argumentsIter.next();
            if (!ComparisonUtils.equals((Object)argument.getName(), (Object)_name)) continue;
            matchingArgument = argument;
        }
        return matchingArgument;
    }

    public String findUnusedArgumentName(String _newName) {
        return this._findUnusedName(_newName, "getArgumentNamed");
    }

    public void _checkForDuplicateArgumentName(EOArgument _argument, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateNameException {
        EOArgument existingArgument = this.getArgumentNamed(_newName);
        if (existingArgument != null && existingArgument != _argument) {
            if (_failures == null) {
                throw new DuplicateArgumentNameException(_newName, this);
            }
            String unusedName = this.findUnusedArgumentName(_newName);
            existingArgument.setName(unusedName, true);
            _failures.add(new DuplicateArgumentFailure(this, _newName, unusedName));
        }
    }

    public EOArgument addBlankArgument(String _name) throws DuplicateNameException {
        EOArgument argument = new EOArgument(this.findUnusedArgumentName(_name));
        argument.setAllowsNull(Boolean.TRUE, false);
        this.addArgument(argument);
        return argument;
    }

    public void addArgument(EOArgument _argument) throws DuplicateNameException {
        this.addArgument(_argument, null, true);
    }

    public void addArgument(EOArgument _argument, Set<EOModelVerificationFailure> _failures, boolean _fireEvents) throws DuplicateNameException {
        _argument._setStoredProcedure(this);
        this._checkForDuplicateArgumentName(_argument, _argument.getName(), _failures);
        _argument.pasted();
        List<EOArgument> oldArguments = null;
        if (_fireEvents) {
            oldArguments = this.myArguments;
            LinkedList<EOArgument> newArguments = new LinkedList<EOArgument>();
            newArguments.addAll(this.myArguments);
            newArguments.add(_argument);
            this.myArguments = newArguments;
            this.firePropertyChange(ARGUMENTS, oldArguments, this.myArguments);
        } else {
            this.myArguments.add(_argument);
        }
    }

    public void removeArgument(EOArgument _argument) {
        List<EOArgument> oldArguments = this.myArguments;
        LinkedList<EOArgument> newArguments = new LinkedList<EOArgument>();
        newArguments.addAll(this.myArguments);
        newArguments.remove(_argument);
        this.myArguments = newArguments;
        this.firePropertyChange(ARGUMENTS, oldArguments, newArguments);
        _argument._setStoredProcedure(null);
    }

    public List<EOArgument> getArguments() {
        return this.myArguments;
    }

    public List<EOArgument> getSortedArguments() {
        return this.myArguments;
    }

    public void loadFromMap(EOModelMap _map, Set<EOModelVerificationFailure> _failures) throws EOModelException {
        this.myStoredProcedureMap = _map;
        this.myName = _map.getString(NAME, true);
        this.myExternalName = _map.getString(EXTERNAL_NAME, true);
        List argumentsList = _map.getList(ARGUMENTS, false);
        if (argumentsList != null) {
            for (Map originalArgumentMap : argumentsList) {
                EOModelMap argumentMap = new EOModelMap(originalArgumentMap);
                EOArgument argument = new EOArgument();
                argument.loadFromMap(argumentMap, _failures);
                this.addArgument(argument, _failures, false);
            }
        }
        this.loadUserInfo(_map);
    }

    public EOModelMap toMap() {
        EOModelMap fetchSpecMap = this.myStoredProcedureMap.cloneModelMap();
        fetchSpecMap.setString(NAME, this.myName, true);
        fetchSpecMap.setString(EXTERNAL_NAME, this.myExternalName, true);
        LinkedList<EOModelMap> arguments = new LinkedList<EOModelMap>();
        for (EOArgument argument : this.myArguments) {
            EOModelMap argumentMap = argument.toMap();
            arguments.add(argumentMap);
        }
        fetchSpecMap.setList(ARGUMENTS, arguments, true);
        this.writeUserInfo(fetchSpecMap);
        return fetchSpecMap;
    }

    public void checkLastModified(Set<EOLastModified> lastModified) {
        if (this._lastModified != null && this._lastModified.hasBeenModified()) {
            lastModified.add(this._lastModified);
        }
    }

    public void loadFromURL(URL storedProcedureURL, Set<EOModelVerificationFailure> failures) throws EOModelException {
        try {
            this._lastModified = new EOLastModified(storedProcedureURL);
            EOModelMap entityMap = new EOModelMap((Map)WOLPropertyListSerialization.propertyListFromURL((URL)storedProcedureURL, (ParserDataStructureFactory)new EOModelParserDataStructureFactory()));
            this.loadFromMap(entityMap, failures);
            this.setStoredProcedureDirty(false);
        }
        catch (Throwable e) {
            throw new EOModelException("Failed to load stored procedure from '" + storedProcedureURL + "'.", e);
        }
    }

    public void saveToFile(File storedProcedureFile) throws PropertyListParserException, IOException {
        EOModelMap storedProcedureMap = this.toMap();
        WOLPropertyListSerialization.propertyListToFile((String)"Entity Modeler v1.0.1", (File)storedProcedureFile, (Object)storedProcedureMap);
        this.setStoredProcedureDirty(false);
        this._lastModified = new EOLastModified(storedProcedureFile);
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        for (EOArgument argument : this.myArguments) {
            argument.resolve(_failures);
        }
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            _failures.add(new EOModelVerificationFailure(this.myModel, this, "The stored procedure " + this.getName() + " has an empty name.", false));
        } else {
            if (name.indexOf(32) != -1) {
                _failures.add(new EOModelVerificationFailure(this.myModel, this, "The stored procedure " + this.getName() + "'s name has a space in it.", false));
            }
            if (!StringUtils.isUppercaseFirstLetter((String)this.myName)) {
                _failures.add(new EOModelVerificationFailure(this.myModel, this, "The stored procedure " + this.getName() + "'s name is not capitalized, but should be.", true));
            }
        }
        String externalName = this.getExternalName();
        if (externalName == null || externalName.trim().length() == 0) {
            _failures.add(new EOModelVerificationFailure(this.myModel, this, "The stored procedure " + this.getName() + " has an empty table name.", false));
        } else if (externalName.indexOf(32) != -1) {
            _failures.add(new EOModelVerificationFailure(this.myModel, this, "The stored procedure " + this.getName() + "'s table name '" + externalName + "' has a space in it.", false));
        }
        for (EOArgument argument : this.myArguments) {
            argument.verify(_failures);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return (this.myModel == null ? "?" : this.myModel.getFullyQualifiedName()) + "/proc: " + this.getName();
    }

    @Override
    public EOModelObject<EOModel> _cloneModelObject() {
        try {
            EOStoredProcedure storedProcedure = new EOStoredProcedure(this.myName);
            storedProcedure.myName = this.myName;
            storedProcedure.myExternalName = this.myExternalName;
            for (EOArgument argument : this.getArguments()) {
                if (this.getArgumentNamed(argument.getName()) != null) continue;
                EOArgument clonedArgument = argument._cloneModelObject();
                clonedArgument.setName(this.findUnusedArgumentName(clonedArgument.getName()));
                storedProcedure.addArgument(clonedArgument);
            }
            this._cloneUserInfoInto(storedProcedure);
            return storedProcedure;
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException("A duplicate name was found during a clone, which should never happen.", e);
        }
    }

    @Override
    public Class<EOModel> _getModelParentType() {
        return EOModel.class;
    }

    @Override
    public EOModel _getModelParent() {
        return this.getModel();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getModel().removeStoredProcedure(this);
    }

    @Override
    public void _addToModelParent(EOModel modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            this.setName(modelParent.findUnusedStoredProcedureName(this.getName()));
        }
        modelParent.addStoredProcedure(this);
    }

    public String toString() {
        return "[EOStoredProcedure: name = " + this.myName + "; arguments = " + this.myArguments + "]";
    }
}

