/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model.qualifier;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOAggregateQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifier;

public class EOAndQualifier
extends EOAggregateQualifier {
    private List<EOQualifier> _qualifiers = new LinkedList<EOQualifier>();

    public EOAndQualifier() {
    }

    public EOAndQualifier(Collection<EOQualifier> qualifiers) {
        for (EOQualifier qualifier : qualifiers) {
            if (qualifier instanceof EOAndQualifier) {
                this._qualifiers.addAll(((EOAndQualifier)qualifier).getQualifiers());
                continue;
            }
            this._qualifiers.add(qualifier);
        }
    }

    public EOAndQualifier(EOQualifier ... qualifiers) {
        for (EOQualifier qualifier : qualifiers) {
            if (qualifier instanceof EOAndQualifier) {
                this._qualifiers.addAll(((EOAndQualifier)qualifier).getQualifiers());
                continue;
            }
            this._qualifiers.add(qualifier);
        }
    }

    @Override
    public void addQualifier(EOQualifier qualifier) {
        this._qualifiers.add(qualifier);
    }

    @Override
    public List<EOQualifier> getQualifiers() {
        return this._qualifiers;
    }

    @Override
    public String toString(int depth) {
        StringBuffer sb = new StringBuffer();
        if (depth > 0) {
            sb.append("(");
        }
        for (int i = 0; i < this._qualifiers.size(); ++i) {
            EOQualifier qualifier = this._qualifiers.get(i);
            if (i > 0) {
                sb.append(" and ");
            }
            if (qualifier != null) {
                sb.append(qualifier.toString(depth + 1));
                continue;
            }
            sb.append("true");
        }
        if (depth > 0) {
            sb.append(")");
        }
        return sb.toString();
    }
}

