/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.factories;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.eomodeler.core.model.AbstractManifestEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.ManifestSearchFolder;
import org.objectstyle.wolips.eomodeler.factories.SimpleManifestUtilities;

public class BundleEOModelGroupFactory
extends AbstractManifestEOModelGroupFactory {
    public static Properties propertiesFromFile(File propertiesFile) throws IOException {
        Properties properties = null;
        if (propertiesFile.exists()) {
            properties = new Properties();
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(propertiesFile));){
                properties.load(is);
            }
        }
        return properties;
    }

    protected int fillInSearchFolders(File bundleFolder, String searchFolderPath, final List<ManifestSearchFolder> manifestSearchFolders) throws IOException {
        int count = SimpleManifestUtilities.fillInSearchFolders(bundleFolder, searchFolderPath, new SimpleManifestUtilities.SearchFolderDelegate(){

            @Override
            public void fileMatched(File file) throws IOException {
                manifestSearchFolders.add(new ManifestSearchFolder(file.getAbsoluteFile()));
            }
        });
        return count;
    }

    protected void fillInSearchFolders(File bundleFolder, List<ManifestSearchFolder> manifestSearchFolders, List<File> frameworkSearchFolders, Set<String> loadedBundles) throws IOException {
        String dependenciesStr;
        System.out.println("BundleEOModelGroupFactory.fillInSearchFolders: Searching " + bundleFolder + " ...");
        if (new File(bundleFolder, "pom.xml").exists()) {
            this.fillInSearchFolders(bundleFolder, "src" + File.separator + "main" + File.separator + "resources" + File.separator + "*.eomodeld", manifestSearchFolders);
            this.fillInSearchFolders(bundleFolder, "src" + File.separator + "test" + File.separator + "resources" + File.separator + "*.eomodeld", manifestSearchFolders);
        } else if (new File(bundleFolder, "Resources").exists()) {
            this.fillInSearchFolders(bundleFolder, "Resources" + File.separator + "*.eomodeld", manifestSearchFolders);
        } else if (new File(bundleFolder, "Contents" + File.separator + "Resources").exists()) {
            this.fillInSearchFolders(bundleFolder, "Contents" + File.separator + "Resources" + File.separator + "*.eomodeld", manifestSearchFolders);
        }
        Properties buildProperties = BundleEOModelGroupFactory.propertiesFromFile(new File(bundleFolder, "build.properties"));
        if (buildProperties != null && (dependenciesStr = buildProperties.getProperty("dependencies")) != null && dependenciesStr.trim().length() > 0) {
            for (String dependency : dependenciesStr.trim().split(",")) {
                if (loadedBundles.contains(dependency)) continue;
                System.out.println("BundleEOModelGroupFactory.fillInSearchFolders: " + bundleFolder + " depends on " + dependency + ":");
                boolean resolvedDependency = false;
                for (File frameworkSearchFolder : frameworkSearchFolders) {
                    File dependencyBundleFolder = new File(frameworkSearchFolder, dependency);
                    if (dependencyBundleFolder.exists()) {
                        this.fillInSearchFolders(dependencyBundleFolder, manifestSearchFolders, frameworkSearchFolders, loadedBundles);
                        resolvedDependency = true;
                        break;
                    }
                    dependencyBundleFolder = new File(frameworkSearchFolder, dependency + ".framework");
                    if (dependencyBundleFolder.exists()) {
                        this.fillInSearchFolders(dependencyBundleFolder, manifestSearchFolders, frameworkSearchFolders, loadedBundles);
                        resolvedDependency = true;
                        break;
                    }
                    dependencyBundleFolder = new File(frameworkSearchFolder, dependency + ".woa");
                    if (!dependencyBundleFolder.exists()) continue;
                    this.fillInSearchFolders(dependencyBundleFolder, manifestSearchFolders, frameworkSearchFolders, loadedBundles);
                    resolvedDependency = true;
                    break;
                }
                if (!resolvedDependency) {
                    System.out.println("BundleEOModelGroupFactory.fillInSearchFolders: Couldn't resolve the dependency '" + dependency + "'.");
                }
                loadedBundles.add(dependency);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ManifestSearchFolder> getSearchFolders(File selectedModelFolder) throws IOException, EOModelException {
        Properties woProperties;
        LinkedList<ManifestSearchFolder> manifestSearchFolders = new LinkedList<ManifestSearchFolder>();
        LinkedList<File> frameworkSearchFolders = new LinkedList<File>();
        File buildPropertiesFile = null;
        for (File buildPropertiesFolder = selectedModelFolder; buildPropertiesFile == null && buildPropertiesFolder != null; buildPropertiesFolder = buildPropertiesFolder.getParentFile()) {
            File possibleBuildPropertiesFile = new File(buildPropertiesFolder, "build.properties");
            if (!possibleBuildPropertiesFile.exists()) continue;
            buildPropertiesFile = possibleBuildPropertiesFile;
        }
        String woPropertiesPath = System.getenv("EntityModelerNSGlobalPropertiesPath");
        if (woPropertiesPath == null) {
            woPropertiesPath = System.getProperty("user.home") + File.separator + "WebObjects.properties";
        }
        if ((woProperties = BundleEOModelGroupFactory.propertiesFromFile(new File(woPropertiesPath))) != null) {
            try {
                List nsProjectSearchPaths = (List)WOLPropertyListSerialization.propertyListFromString((String)woProperties.getProperty("NSProjectSearchPath"));
                if (nsProjectSearchPaths != null) {
                    for (String nsProjectSearchPath : nsProjectSearchPaths) {
                        File nsProjectSearchFolder = new File(nsProjectSearchPath);
                        if (!nsProjectSearchFolder.exists()) continue;
                        frameworkSearchFolders.add(nsProjectSearchFolder);
                    }
                }
            }
            catch (Throwable t) {
                throw new EOModelException("Failed to parse NSProjectSearchPath.", t);
            }
        }
        File frameworkPathsManifestFile = null;
        for (File frameworkPathsManifestFolder = selectedModelFolder; frameworkPathsManifestFile == null && frameworkPathsManifestFolder != null; frameworkPathsManifestFolder = frameworkPathsManifestFolder.getParentFile()) {
            File possibleFrameworkPathsManifestFile = new File(frameworkPathsManifestFolder, ".EntityModeler.frameworkpath");
            if (!possibleFrameworkPathsManifestFile.exists()) continue;
            frameworkPathsManifestFile = possibleFrameworkPathsManifestFile;
        }
        if (frameworkPathsManifestFile != null) {
            try (BufferedReader frameworkPathsManifestReader = new BufferedReader(new FileReader(frameworkPathsManifestFile));){
                String frameworkPath;
                while ((frameworkPath = frameworkPathsManifestReader.readLine()) != null) {
                    File frameworkFolder = new File(frameworkPath);
                    if (!frameworkFolder.isAbsolute()) {
                        frameworkFolder = new File(frameworkPathsManifestFile.getCanonicalFile().getParentFile(), frameworkPath);
                    }
                    if (!frameworkFolder.exists()) continue;
                    frameworkSearchFolders.add(frameworkFolder);
                }
            }
        }
        if (buildPropertiesFile != null && frameworkSearchFolders.size() > 0) {
            System.out.println("BundleEOModelGroupFactory.getSearchFolders: " + selectedModelFolder);
            HashSet<String> loadedBundles = new HashSet<String>();
            this.fillInSearchFolders(buildPropertiesFile.getParentFile(), manifestSearchFolders, frameworkSearchFolders, loadedBundles);
        }
        return manifestSearchFolders;
    }
}

