/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.tobeintregrated;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class ASTMethodExplorer
extends ASTVisitor {
    Hashtable<String, List<String>> usedMethods;
    Hashtable<String, List<String>> declaredMethods;
    Hashtable<String, List<String>> publicClassVariables;
    Hashtable<String, String> classDependencies;
    ICompilationUnit iCompUnit;

    public ASTMethodExplorer(Hashtable<String, List<String>> myUsedMethods, Hashtable<String, List<String>> myDeclaredMethods, Hashtable<String, List<String>> myClassVariables, Hashtable<String, String> myClassDependencies, ICompilationUnit iComp) {
        super(true);
        this.usedMethods = myUsedMethods;
        this.declaredMethods = myDeclaredMethods;
        this.publicClassVariables = myClassVariables;
        this.classDependencies = myClassDependencies;
        this.iCompUnit = iComp;
    }

    public boolean visit(ClassInstanceCreation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        if (binding != null) {
            List<Object> nodesID;
            String handleID = this.iCompUnit.getHandleIdentifier();
            ITypeBinding[] params = binding.getParameterTypes();
            String paramString = "(";
            for (int i = 0; i < params.length; ++i) {
                paramString = paramString + params[i].getName();
                if (i >= params.length - 1) continue;
                paramString = paramString + ",";
            }
            paramString = paramString + ")";
            String key = binding.getDeclaringClass().getName() + "." + binding.getName() + paramString;
            if (this.usedMethods.containsKey(key)) {
                nodesID = this.usedMethods.get(key);
                nodesID.add(handleID);
            } else {
                nodesID = new ArrayList<String>();
                nodesID.add(handleID);
            }
            this.usedMethods.put(key, nodesID);
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            List<Object> nodesID;
            String handleID = this.iCompUnit.getHandleIdentifier();
            ITypeBinding[] params = binding.getParameterTypes();
            String paramString = "(";
            for (int i = 0; i < params.length; ++i) {
                paramString = paramString + params[i].getName();
                if (i >= params.length - 1) continue;
                paramString = paramString + ",";
            }
            paramString = paramString + ")";
            String key = binding.getDeclaringClass().getName() + "." + binding.getName() + paramString;
            if (this.usedMethods.containsKey(key)) {
                nodesID = this.usedMethods.get(key);
                nodesID.add(handleID);
            } else {
                nodesID = new ArrayList<String>();
                nodesID.add(handleID);
            }
            this.usedMethods.put(key, nodesID);
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        IMethodBinding binding = node.resolveBinding();
        if (binding != null) {
            ITypeBinding[] params = binding.getParameterTypes();
            String paramString = "(";
            for (int i = 0; i < params.length; ++i) {
                paramString = paramString + params[i].getName();
                if (i >= params.length - 1) continue;
                paramString = paramString + ",";
            }
            paramString = paramString + ")";
            String key = binding.getDeclaringClass().getName() + "." + binding.getName() + paramString;
            ITypeBinding declaredClassBinding = binding.getDeclaringClass();
            ITypeBinding superClassBinding = declaredClassBinding.getSuperclass();
            boolean skip = this.checkSuperClass(binding, superClassBinding);
            ITypeBinding[] interfaceBindings = declaredClassBinding.getInterfaces();
            boolean bl = skip = skip || this.checkInterfaces(binding, interfaceBindings);
            if (superClassBinding != null) {
                this.classDependencies.put(declaredClassBinding.getName(), superClassBinding.getName());
                boolean isWOComponent = superClassBinding.getName().equals("WOComponent");
                skip = skip || isWOComponent && binding.getName().equals("title");
            }
            boolean isDirectAction = declaredClassBinding.getName().equals("DirectAction");
            skip = skip || isDirectAction && (binding.getName().endsWith("Action") || binding.getName().equals("performActionNamed"));
            IPackageBinding packageBinding = declaredClassBinding.getPackage();
            String[] comps = packageBinding.getNameComponents();
            if (comps.length > 0) {
                String comp = comps[comps.length - 1];
                boolean bl2 = skip = skip || (comp.equals("app") || comp.equals("logic")) && binding.isConstructor();
            }
            if (!this.usedMethods.containsKey(key)) {
                ArrayList<String> value = new ArrayList<String>();
                value.add(this.iCompUnit.getHandleIdentifier());
                value.add(binding.getName());
                value.add(binding.getReturnType().getName());
                value.add(skip + "");
                this.declaredMethods.put(key, value);
            }
        }
        return true;
    }

    private boolean checkSuperClass(IMethodBinding binding, ITypeBinding superClassBinding) {
        boolean hit = false;
        if (superClassBinding != null) {
            IMethodBinding[] superMethods = superClassBinding.getDeclaredMethods();
            for (int i = 0; i < superMethods.length; ++i) {
                if (!binding.overrides(superMethods[i])) continue;
                hit = true;
            }
            if (!hit) {
                hit = this.checkSuperClass(binding, superClassBinding.getSuperclass());
            }
        }
        return hit;
    }

    private boolean checkInterfaces(IMethodBinding binding, ITypeBinding[] interfaceBindings) {
        boolean hit = false;
        for (int i = 0; i < interfaceBindings.length; ++i) {
            IMethodBinding[] interfaceMethods = interfaceBindings[i].getDeclaredMethods();
            for (int j = 0; j < interfaceMethods.length; ++j) {
                if (!binding.overrides(interfaceMethods[j])) continue;
                hit = true;
            }
            if (hit) continue;
            hit = this.checkInterfaces(binding, interfaceBindings[i].getInterfaces());
        }
        return hit;
    }

    public boolean visit(VariableDeclarationFragment node) {
        IVariableBinding binding = node.resolveBinding();
        if (node.getParent().getNodeType() == 23) {
            boolean isPublic;
            String call = node.getParent().toString();
            boolean bl = isPublic = call.startsWith("public") && !call.startsWith("public static final") && !call.startsWith("public final static");
            if (binding != null && isPublic) {
                String key = binding.getDeclaringClass().getName() + "." + binding.getName();
                ArrayList<String> value = new ArrayList<String>();
                value.add(this.iCompUnit.getHandleIdentifier());
                value.add(binding.getType().getName());
                this.publicClassVariables.put(key, value);
            }
        }
        return true;
    }
}

