/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.util.List;
import java.util.Map;
import org.objectstyle.wolips.bindings.api.AbstractNamedValidation;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.Validation;
import org.objectstyle.wolips.bindings.api.Wo;
import org.w3c.dom.Element;

public class Ungettable
extends AbstractNamedValidation {
    protected static final String UNGETTABLE = "ungettable";

    protected Ungettable(Element element, ApiModel apiModel) {
        super(element, apiModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToWoWithBinding(Wo wo, Binding binding) {
        ApiModel apiModel = wo.apiModel;
        synchronized (apiModel) {
            Element newValidationElement = wo.element.getOwnerDocument().createElement("validation");
            wo.element.appendChild(newValidationElement);
            newValidationElement.setAttribute("message", "'" + binding.getName() + "' must be bound to a gettable value");
            Element newUngettableElement = wo.element.getOwnerDocument().createElement(UNGETTABLE);
            newValidationElement.appendChild(newUngettableElement);
            newUngettableElement.setAttribute("name", binding.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromWoWithBinding(Wo wo, Binding binding) {
        ApiModel apiModel = wo.apiModel;
        synchronized (apiModel) {
            List<Validation> validations = wo.getValidations();
            for (int i = validations.size() - 1; i >= 0; --i) {
                Validation validation = validations.get(i);
                List<Ungettable> ungettables = validation.getUngettables();
                if (ungettables.size() != 1 || !ungettables.get(0).isAffectedByBindingNamed(binding.getName())) continue;
                validation.removeChild(ungettables.get(0));
            }
        }
    }

    @Override
    public boolean evaluate(Map<String, String> bindings) {
        String bindingName = this.getName();
        String bindingValue = bindings.get(bindingName);
        boolean evaluation = bindingValue != null && bindingValue.startsWith("\"") && !bindingValue.startsWith("\"~");
        return evaluation;
    }
}

