/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.wod.TagShortcut;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.preferences.TableViewerSupport;

public class TagShortcutPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer _viewer;
    private List<TagShortcut> _model = new ArrayList<TagShortcut>();
    private List<TagShortcut> _oldModel = new ArrayList<TagShortcut>();

    public TagShortcutPreferencePage() {
        this.setTitle("Tag Shortcuts");
        this.setDescription("Tag shortcuts are for use with inline bindings. You must have these shortcuts declared at runtime as well. The definitions here are for html validation.\n\nIf you are using WOTagProcessor, you can define shortcuts that map additional keys like 'edit'=>'ERXWOTemplate','templateName=edit'.");
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        TableViewerSupport support = new TableViewerSupport(this._model, parent){

            protected void initTableViewer(TableViewer viewer) {
                Table table = viewer.getTable();
                TableColumn col1 = new TableColumn(table, 16384);
                col1.setText("Shortcut");
                col1.setWidth(100);
                TableColumn col2 = new TableColumn(table, 16384);
                col2.setText("Actual Tag");
                col2.setWidth(150);
                TableColumn col3 = new TableColumn(table, 16384);
                col3.setText("Attributes");
                col3.setWidth(200);
            }

            protected Object doAdd() {
                TagShortcutDialog dialog = new TagShortcutDialog(TagShortcutPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    return dialog.getTagShortcut();
                }
                return null;
            }

            protected void doEdit(Object obj) {
                TagShortcut _tagShortcut = (TagShortcut)obj;
                TagShortcutDialog dialog = new TagShortcutDialog(TagShortcutPreferencePage.this.getShell(), _tagShortcut);
                if (dialog.open() == 0) {
                    TagShortcut newElement = dialog.getTagShortcut();
                    _tagShortcut.setShortcut(newElement.getShortcut());
                    _tagShortcut.setActual(newElement.getActual());
                    _tagShortcut.setAttributesAsString(newElement.getAttributesAsString());
                }
            }

            protected ITableLabelProvider createLabelProvider() {
                return new ITableLabelProvider(){

                    public Image getColumnImage(Object tagShortcut, int columnIndex) {
                        return null;
                    }

                    public String getColumnText(Object tagShortcut, int columnIndex) {
                        switch (columnIndex) {
                            case 0: {
                                return ((TagShortcut)tagShortcut).getShortcut();
                            }
                            case 1: {
                                return ((TagShortcut)tagShortcut).getActual();
                            }
                            case 2: {
                                return ((TagShortcut)tagShortcut).getAttributesAsString();
                            }
                        }
                        return tagShortcut.toString();
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                    }

                    public boolean isLabelProperty(Object tagShortcut, String property) {
                        return false;
                    }

                    public void removeListener(ILabelProviderListener listener) {
                    }
                };
            }
        };
        this._viewer = support.getTableViewer();
        this._model.addAll(TagShortcut.fromPreferenceString(this.getPreferenceStore().getString("TagShortcuts")));
        this.syncModels();
        this._viewer.refresh();
        return support.getControl();
    }

    protected void performDefaults() {
        this._model.clear();
        this._model.addAll(TagShortcut.fromPreferenceString(this.getPreferenceStore().getDefaultString("TagShortcuts")));
        this._viewer.refresh();
        this.processChange();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("TagShortcuts", TagShortcut.toPreferenceString(this._model));
        this.processChange();
        CorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void syncModels() {
        try {
            this._oldModel.clear();
            for (int i = 0; i < this._model.size(); ++i) {
                this._oldModel.add(this._model.get(i).clone());
            }
        }
        catch (Exception ex) {
            CorePlugin.getDefault().log((Throwable)ex);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void processChange() {
        if (TagShortcut.hasChange(this._oldModel, this._model)) {
            this.syncModels();
        }
    }

    private class TagShortcutDialog
    extends Dialog {
        private Text _shortcutTag;
        private Text _actualTag;
        private Text _attributes;
        private TagShortcut _tagShortcut;

        public TagShortcutDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public TagShortcutDialog(Shell parentShell, TagShortcut tagShortcut) {
            super(parentShell);
            this._tagShortcut = tagShortcut;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Tag Shortcut");
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText("Shortcut");
            this._shortcutTag = new Text(composite, 2048);
            if (this._tagShortcut != null) {
                this._shortcutTag.setText(this._tagShortcut.getShortcut());
            }
            this._shortcutTag.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText("Actual Tag");
            this._actualTag = new Text(composite, 2048);
            if (this._tagShortcut != null) {
                this._actualTag.setText(this._tagShortcut.getActual());
            }
            this._actualTag.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText("Attributes");
            this._attributes = new Text(composite, 2048);
            if (this._tagShortcut != null) {
                this._attributes.setText(this._tagShortcut.getAttributesAsString());
            }
            this._attributes.setLayoutData((Object)new GridData(768));
            return composite;
        }

        protected void okPressed() {
            if (this._shortcutTag.getText().length() == 0) {
                MessageDialog.openError((Shell)this.getParentShell(), (String)"Shortcut Required", (String)"You must set a shortcut tag name.");
                return;
            }
            if (this._actualTag.getText().length() == 0) {
                MessageDialog.openError((Shell)this.getParentShell(), (String)"Actual Tag Required", (String)"You must set the actual tag name.");
                return;
            }
            String shortcut = this._shortcutTag.getText();
            String actual = this._actualTag.getText();
            String attributes = this._attributes.getText();
            this._tagShortcut = new TagShortcut(shortcut, actual, attributes);
            super.okPressed();
        }

        public TagShortcut getTagShortcut() {
            return this._tagShortcut;
        }
    }
}

