/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.objectstyle.wolips.bindings.wod.TypeCache;

public class BindingValueKey
implements Comparable<BindingValueKey> {
    private String _bindingName;
    private IMember _bindingMember;
    private IType _bindingDeclaringType;
    private IType _nextType;
    private TypeCache _cache;
    private BindingValueKey _parent;
    protected IJavaProject _javaProject;

    public BindingValueKey(String bindingName, IType bindingDeclaringType, IMember bindingMember, IJavaProject javaProject, TypeCache cache) {
        this._bindingName = bindingName;
        this._bindingMember = bindingMember;
        this._bindingDeclaringType = bindingDeclaringType;
        this._javaProject = javaProject;
        this._cache = cache;
    }

    public boolean equals(Object o) {
        return o instanceof BindingValueKey && this.compareTo((BindingValueKey)o) == 0;
    }

    public int hashCode() {
        return this._bindingName == null ? 0 : this._bindingName.hashCode();
    }

    @Override
    public int compareTo(BindingValueKey o) {
        return o == null ? -1 : (this._bindingName == null ? (o._bindingName == null ? 0 : 1) : this._bindingName.compareTo(o._bindingName));
    }

    public IType getDeclaringType() {
        return this._bindingMember == null ? null : this._bindingMember.getDeclaringType();
    }

    public String getBindingName() {
        return this._bindingName;
    }

    public IMember getBindingMember() {
        return this._bindingMember;
    }

    public String getMemberTypeName(IMember member) throws JavaModelException {
        String result = null;
        if (member != null) {
            result = member instanceof IMethod ? ((IMethod)member).getReturnType() : ((IField)member).getTypeSignature();
        }
        return result;
    }

    public String getNextTypeName() {
        try {
            String nextTypeName = this._nextType != null ? Signature.createTypeSignature((String)this._nextType.getFullyQualifiedName(), (boolean)true) : this.getMemberTypeName(this._bindingMember);
            return nextTypeName;
        }
        catch (JavaModelException e) {
            throw new RuntimeException("Failed to get the next type name for " + this._bindingMember + ".", e);
        }
    }

    public IType getNextType() throws JavaModelException {
        if (this._nextType == null) {
            this._nextType = this.resolveNextType(null);
        }
        return this._nextType;
    }

    public IType getNextType(BindingValueKey parentBinding) throws JavaModelException {
        if (this._nextType == null) {
            this._nextType = this.resolveNextType(parentBinding);
        }
        return this._nextType;
    }

    public boolean isLeaf() throws JavaModelException {
        boolean isLeaf = false;
        IType nextType = this.getNextType();
        if (nextType != null) {
            String name = nextType.getFullyQualifiedName();
            if ("java.lang.String".equals(name) || "java.lang.Object".equals(name)) {
                isLeaf = true;
            }
        } else {
            isLeaf = true;
        }
        return isLeaf;
    }

    protected IType resolveNextType(BindingValueKey parentBinding) throws JavaModelException {
        String nextTypeName = this.getNextTypeName();
        if (nextTypeName == null || nextTypeName.length() == 0) {
            return null;
        }
        String typeSignatureName = Signature.getSignatureSimpleName((String)Signature.getElementType((String)nextTypeName));
        this._parent = parentBinding != null ? parentBinding : this;
        BindingValueKey binding = this;
        IType declaringType = this.getDeclaringType();
        String lastTypeName = null;
        block0: while (BindingValueKey.isGenericType(nextTypeName, declaringType) && !nextTypeName.equals(lastTypeName)) {
            lastTypeName = nextTypeName;
            typeSignatureName = Signature.getSignatureSimpleName((String)Signature.getElementType((String)nextTypeName));
            String[] declaringTypeParameters = declaringType.getTypeParameterSignatures();
            String[] declaringTypeArgs = binding._parent._bindingDeclaringType.getTypeParameterSignatures();
            String[] memberTypeArgs = Signature.getTypeArguments((String)this.getMemberTypeName(binding._parent._bindingMember));
            String[] superTypeArgs = Signature.getTypeArguments((String)binding._parent._bindingDeclaringType.getSuperclassTypeSignature());
            for (int i = 0; i < declaringTypeParameters.length; ++i) {
                String param = declaringTypeParameters[i];
                String currentParameterType = Signature.getTypeVariable((String)param);
                if (!typeSignatureName.equals(currentParameterType)) continue;
                if (i < declaringTypeArgs.length) {
                    nextTypeName = Signature.createTypeSignature((String)Signature.getTypeVariable((String)declaringTypeArgs[i]), (boolean)false);
                    binding = binding._parent;
                    declaringType = binding._bindingDeclaringType;
                    continue block0;
                }
                if (superTypeArgs.length > 0) {
                    String superTypeName = Signature.getTypeErasure((String)binding._parent._bindingDeclaringType.getSuperclassName());
                    IType superType = this._cache.getTypeForNameInType(Signature.createTypeSignature((String)superTypeName, (boolean)false), binding._parent._bindingDeclaringType);
                    String[] superTypeParameters = superType.getTypeParameterSignatures();
                    boolean found = false;
                    for (int j = 0; j < superTypeParameters.length; ++j) {
                        if (!typeSignatureName.equals(Signature.getTypeVariable((String)superTypeParameters[j]))) continue;
                        nextTypeName = superTypeArgs[j];
                        binding = binding._parent;
                        declaringType = binding._bindingDeclaringType;
                        found = true;
                        break;
                    }
                    if (found) continue block0;
                }
                if (i >= memberTypeArgs.length) continue;
                nextTypeName = memberTypeArgs[i];
                declaringType = binding._parent.getDeclaringType();
                continue block0;
            }
        }
        String nextTypeNameErasure = Signature.getTypeErasure((String)nextTypeName);
        IType nextType = this._cache.getTypeForNameInType(nextTypeNameErasure, declaringType);
        return nextType;
    }

    private static boolean isGenericType(String typeName, IType declaringType) throws JavaModelException {
        String[] typeParameters = declaringType.getTypeParameterSignatures();
        String typeVariable = Signature.getSignatureSimpleName((String)typeName);
        for (int i = 0; i < typeParameters.length; ++i) {
            String currentParameterType = Signature.getTypeVariable((String)typeParameters[i]);
            if (!typeVariable.equals(currentParameterType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[BindingKey: bindingName = " + this._bindingName + "; bindingMember = " + this._bindingMember + "; parent = " + (this._parent != null && this._parent != this ? this._parent.toString() : "null") + "]";
    }
}

