/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.objectstyle.woenvironment.frameworks.Dependency;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.variables.ProjectVariables;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class EclipseDependency
extends Dependency {
    private IProject _project;
    private IRuntimeClasspathEntry _classpathEntry;
    private ProjectVariables _variables;

    public EclipseDependency(IProject project, IRuntimeClasspathEntry classpathEntry) {
        this._project = project;
        this._variables = VariablesPlugin.getDefault().getProjectVariables(project);
        this._classpathEntry = classpathEntry;
    }

    public String getRawPath() {
        return this._classpathEntry.getPath().toString();
    }

    public IRuntimeClasspathEntry getClasspathEntry() {
        return this._classpathEntry;
    }

    public boolean isProject() {
        return 1 == this._classpathEntry.getType();
    }

    public boolean isWOProject() {
        return this.getWOJavaArchive() != null;
    }

    public String getProjectFrameworkName() {
        IProject project = (IProject)this._classpathEntry.getResource();
        ProjectAdapter projectAdaptor = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        String frameworkName = null;
        if (projectAdaptor != null) {
            frameworkName = projectAdaptor.getBuildProperties().getName() + ".framework";
        }
        if (frameworkName == null) {
            frameworkName = project.getName() + ".framework";
        }
        return frameworkName;
    }

    public String getLocation() {
        return this._classpathEntry.getLocation();
    }

    public String getSystemRoot() {
        IPath systemRoot = this._variables.getSystemRoot();
        if (systemRoot == null) {
            throw new IllegalArgumentException("You do not have a 'wo.system.root' property set in your wolips.properties file.");
        }
        return systemRoot.toString();
    }

    public IPath getWOJavaArchive() {
        try {
            IPath woJavaArchivePath = null;
            if (this.isProject()) {
                IProject project = (IProject)this._classpathEntry.getResource();
                ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
                woJavaArchivePath = projectAdapter != null ? projectAdapter.getWOJavaArchive() : null;
            }
            return woJavaArchivePath;
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed to retrieve WO project metadata.", e);
        }
    }

    public String toString() {
        return "[EclipseDependency: project = " + this._project + "]";
    }
}

