/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui.refactoring.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.ui.actions.RenameAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.objectstyle.wolips.refactoring.RenameWOComponentWizard;

public class RenameWOComponentAction
extends SelectionListenerAction {
    private final IWorkbenchSite _site;
    private final IAction _delegateAction;

    public RenameWOComponentAction(IWorkbenchSite site) {
        super(null);
        this._site = site;
        this._delegateAction = new RenameAction(this._site);
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (!RenameWOComponentAction.isWOComponentResource(selection)) {
            this._delegateAction.run();
            return;
        }
        IResource resource = RenameWOComponentAction.getResource(selection);
        if (!RefactoringAvailabilityTester.isRenameAvailable((IResource)resource)) {
            return;
        }
        RenameWOComponentWizard wizard = new RenameWOComponentWizard(resource);
        new RefactoringStarter().activate((RefactoringWizard)wizard, this._site.getShell(), wizard.getWindowTitle(), 2);
    }

    private static boolean isWOComponentResource(IStructuredSelection selection) {
        IResource resource = RenameWOComponentAction.getResource(selection);
        if (resource instanceof IFolder && "wo".equals(resource.getLocation().getFileExtension())) {
            return true;
        }
        return resource instanceof IFile && "api".equals(resource.getLocation().getFileExtension());
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }
}

