/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui.tags;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.JdtPlugin;

public abstract class WOTagLibResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public final void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            JdtPlugin.getDefault().getPluginLogger().log((Throwable)e);
        }
    }

    public final boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        return this.examineResource(resource, delta.getKind());
    }

    private final boolean examineResource(IResource resource, int kindOfChange) {
        if (!resource.isAccessible() && kindOfChange != 2) {
            return false;
        }
        if (resource.isDerived()) {
            return false;
        }
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                ProjectAdapter project = (ProjectAdapter)resource.getAdapter(ProjectAdapter.class);
                if (project == null) {
                    return false;
                }
                return project.isApplication() || project.isFramework();
            }
            case 2: {
                return false;
            }
            case 1: {
                if (!resource.getName().equals(".wotaglib")) break;
                this.update(resource.getProject());
            }
        }
        return false;
    }

    public abstract void update(IProject var1);
}

