/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.htmlpreview.editor;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.RenderDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.objectstyle.wolips.components.editor.ComponentEditorInteraction;
import org.objectstyle.wolips.components.editor.IEmbeddedEditor;
import org.objectstyle.wolips.components.editor.IEmbeddedEditorSelected;
import org.objectstyle.wolips.components.editor.IHtmlDocumentProvider;
import org.objectstyle.wolips.htmlpreview.HtmlPreviewPlugin;
import org.objectstyle.wolips.htmlpreview.editor.PreviewRenderDelegate;
import org.objectstyle.wolips.templateeditor.TemplateEditor;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

public class HtmlPreviewEditor
implements IEmbeddedEditor,
IEmbeddedEditorSelected,
IEditorPart {
    private ComponentEditorInteraction _editorInteraction;
    private IEditorSite _site;
    private IEditorInput _input;
    private Browser _browser;

    private void updatePreviewContent() {
        boolean rendered;
        if (this._editorInteraction == null) {
            return;
        }
        IHtmlDocumentProvider documentProvider = this._editorInteraction.getHtmlDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument editDocument = documentProvider.getHtmlEditDocument();
        String documentContents = editDocument.get();
        try {
            WodParserCache cache = ((TemplateEditor)this._editorInteraction.getHtmlDocumentProvider()).getSourceEditor().getParserCache();
            FuzzyXMLDocument htmlDocument = (FuzzyXMLDocument)cache.getHtmlEntry().getModel();
            RenderContext renderContext = new RenderContext(true);
            renderContext.setDelegate((RenderDelegate)new PreviewRenderDelegate(cache));
            FuzzyXMLElement documentElement = htmlDocument.getDocumentElement();
            documentContents = documentElement.toXMLString(renderContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._browser != null && !(rendered = this._browser.setText(documentContents))) {
            HtmlPreviewPlugin.getDefault().log("Can't create preview of component HTML.");
        }
    }

    public void initEditorInteraction(ComponentEditorInteraction editorInteraction) {
        this._editorInteraction = editorInteraction;
    }

    public IEditorInput getEditorInput() {
        return this._input;
    }

    public IEditorSite getEditorSite() {
        return this._site;
    }

    public void init(IEditorSite initSite, IEditorInput initInput) throws PartInitException {
        this._site = initSite;
        this._input = initInput;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        try {
            this._browser = new Browser(parent, 8);
        }
        catch (Exception e) {
            HtmlPreviewPlugin.getDefault().log("Failed to create Browser component.", e);
        }
    }

    public IWorkbenchPartSite getSite() {
        return this._site;
    }

    public String getTitle() {
        return null;
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void dispose() {
        if (this._browser != null) {
            this._browser.dispose();
        }
    }

    public void setFocus() {
        if (this._browser != null) {
            this._browser.setFocus();
        }
    }

    public void editorSelected() {
        this.updatePreviewContent();
    }

    public ComponentEditorInteraction getEditorInteraction() {
        return this._editorInteraction;
    }
}

