/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Arrays;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.AddOperation;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.actions.PasteOrderComparator;
import org.objectstyle.wolips.eomodeler.actions.SimpleCompositeOperation;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class PasteAction
extends EMAction {
    public void run() {
        try {
            Control focusControl = Display.getCurrent().getFocusControl();
            if (focusControl instanceof Text) {
                ((Text)focusControl).paste();
                return;
            }
            if (focusControl instanceof StyledText) {
                ((StyledText)focusControl).paste();
                return;
            }
            EOModelObject selectedObject = (EOModelObject)this.getSelectedObject();
            ISelection pastedSelection = LocalSelectionTransfer.getTransfer().getSelection();
            if (pastedSelection != null) {
                Object[] clipboardObjects = ((IStructuredSelection)pastedSelection).toArray();
                Arrays.sort(clipboardObjects, new PasteOrderComparator());
                SimpleCompositeOperation pasteOperation = new SimpleCompositeOperation(EOModelUtils.getOperationLabel("Paste", Arrays.asList(clipboardObjects)));
                for (Object clipboardObject : clipboardObjects) {
                    EOModelObject eoModelObject;
                    Class modelParentClass;
                    EOModelObject pasteIntoObject;
                    if (!(clipboardObject instanceof EOModelObject) || (pasteIntoObject = EOModelUtils.getRelated(modelParentClass = (eoModelObject = (EOModelObject)clipboardObject)._getModelParentType(), selectedObject)) == null) continue;
                    EOModelObject clonedPasteObject = eoModelObject._cloneModelObject();
                    pasteOperation.add((IUndoableOperation)new AddOperation(pasteIntoObject, clonedPasteObject));
                }
                pasteOperation.addContext(EOModelUtils.getUndoContext(selectedObject));
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.execute((IUndoableOperation)pasteOperation, null, null);
            }
        }
        catch (Throwable t) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)t);
        }
    }

    @Override
    public void runWithEvent(Event event) {
        this.run();
    }

    @Override
    public void run(IAction action) {
        this.run();
    }
}

