/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityListContentProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOModelLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOModelListContentProvider;

public class EntityPicker
extends Composite {
    private ComboViewer _modelComboViewer;
    private ComboViewer _entityComboViewer;

    public EntityPicker(Composite parent, int style, boolean includePrototypes) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        Combo modelCombo = new Combo((Composite)this, 0x800808);
        this._modelComboViewer = new ComboViewer(modelCombo);
        this._modelComboViewer.setLabelProvider((IBaseLabelProvider)new EOModelLabelProvider());
        this._modelComboViewer.setContentProvider((IContentProvider)new EOModelListContentProvider());
        this._modelComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                EOModel selectedModel = (EOModel)selection.getFirstElement();
                EntityPicker.this._entityComboViewer.setInput((Object)selectedModel);
                if (EntityPicker.this._entityComboViewer.getCombo().getItemCount() > 0) {
                    EntityPicker.this._entityComboViewer.setSelection((ISelection)new StructuredSelection(EntityPicker.this._entityComboViewer.getElementAt(0)));
                }
            }
        });
        Combo entityCombo = new Combo((Composite)this, 0x800808);
        this._entityComboViewer = new ComboViewer(entityCombo);
        this._entityComboViewer.setLabelProvider((IBaseLabelProvider)new EOEntityLabelProvider());
        this._entityComboViewer.setContentProvider((IContentProvider)new EOEntityListContentProvider(false, true, includePrototypes));
        GridData entityComboLayoutData = new GridData(768);
        entityCombo.setLayoutData((Object)entityComboLayoutData);
    }

    public void setModelGroup(EOModelGroup modelGroup) {
        this._modelComboViewer.setInput((Object)modelGroup);
    }

    public void setModel(EOModel model) {
        if (model != null) {
            this._modelComboViewer.setSelection((ISelection)new StructuredSelection((Object)model), true);
            this._entityComboViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    public void setEntity(EOEntity entity) {
        if (entity != null) {
            this._modelComboViewer.setSelection((ISelection)new StructuredSelection((Object)entity.getModel()), true);
            this._entityComboViewer.setSelection((ISelection)new StructuredSelection((Object)entity), true);
        } else {
            this._entityComboViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    public EOEntity getEntity() {
        return (EOEntity)((IStructuredSelection)this._entityComboViewer.getSelection()).getFirstElement();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._entityComboViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._entityComboViewer.removeSelectionChangedListener(listener);
    }
}

