/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.objectstyle.wolips.builder.internal.BuildHelper;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;

public class BuildVisitor
extends BuildHelper {
    IPath outputPath = null;
    boolean _checkJavaOutputPath = false;
    int count = 0;
    private Map _destinations = new HashMap();

    @Override
    public void reinitForNextBuild(IProject project) {
        super.reinitForNextBuild(project);
        try {
            IJavaProject jp = this.getJavaProject();
            this.outputPath = jp.getOutputLocation();
            this._checkJavaOutputPath = !this.outputPath.equals((Object)jp.getPath());
        }
        catch (CoreException up) {
            this.outputPath = new Path("/dummy");
        }
        this.count = 0;
        this._destinations.clear();
    }

    public void resetCount() {
        this.count = 0;
    }

    public boolean _checkResource(IResource res, IResourceDelta delta, IPath copyToPath) throws CoreException {
        boolean result;
        boolean deleted;
        if (null == copyToPath) {
            BuildVisitor.unmarkResource(res, "org.objectstyle.wolips.projectbuild.duplicate");
            return false;
        }
        IResource src = (IResource)this._destinations.get(copyToPath);
        boolean bl = deleted = null != delta && delta.getKind() == 2;
        if (null == src) {
            if (!deleted) {
                this._destinations.put(copyToPath, res);
            }
            result = true;
        } else if (src.equals((Object)res)) {
            if (deleted) {
                this._destinations.remove(copyToPath);
            }
            result = true;
        } else if (!deleted) {
            IPath shortened = copyToPath.removeFirstSegments(2);
            String message = "duplicate resource for destination .../" + shortened.toString();
            BuildVisitor.markResource(res, "org.objectstyle.wolips.projectbuild.duplicate", 2, message, src.getFullPath().toString());
            result = false;
        } else {
            result = true;
        }
        if (result && !deleted) {
            BuildVisitor.unmarkResource(res, "org.objectstyle.wolips.projectbuild.duplicate");
        }
        return result;
    }

    public boolean _checkDirs() throws CoreException {
        IPath buildPath = this.getBuildPath();
        IPath resPath = this.getResourceOutputPath();
        IPath javaPath = this.getJavaOutputPath();
        IPath webresPath = this.getWebResourceOutputPath();
        boolean result = BuildVisitor.checkDerivedDir(buildPath, null);
        result = BuildVisitor.checkDerivedDir(resPath, null) && result;
        result = BuildVisitor.checkDerivedDir(javaPath, null) && result;
        result = BuildVisitor.checkDerivedDir(webresPath, null) && result;
        return result;
    }

    @Override
    public boolean handleResource(IResource res, IResourceDelta delta) throws CoreException {
        boolean handleResourceChildren = true;
        ++this.count;
        IPath fullPath = res.getFullPath();
        boolean ignore = false;
        if (this.getBuildPath().isPrefixOf(fullPath)) {
            ignore = true;
        }
        if (!ignore && this._checkJavaOutputPath && this.outputPath.isPrefixOf(fullPath)) {
            ignore = true;
        }
        boolean handled = false;
        if (!ignore) {
            IPath dest;
            IProjectPatternsets patternsets = (IProjectPatternsets)this.getProject().getAdapter(IProjectPatternsets.class);
            if (patternsets.matchesResourcesPattern(res)) {
                dest = this.asResourcePath(res.getFullPath(), res);
                if (this._checkResource(res, delta, dest)) {
                    handled = this._handleResource(res, delta, dest);
                    if (res instanceof IFolder) {
                        handleResourceChildren = false;
                    }
                } else {
                    handled = true;
                }
            } else if (res.toString().indexOf("/Resources/") != -1) {
                // empty if block
            }
            if (patternsets.matchesWOAppResourcesPattern(res)) {
                dest = this.asWebResourcePath(res.getFullPath(), res);
                if (this._checkResource(res, delta, dest)) {
                    handled = this._handleResource(res, delta, dest);
                    if (res instanceof IFolder) {
                        handleResourceChildren = false;
                    }
                } else {
                    handled = true;
                }
            }
        }
        if (!handled) {
            this._getLogger().debug((Object)("//not a (ws)resource: " + res));
            BuildVisitor.unmarkResource(res, "org.objectstyle.wolips.projectbuild.duplicate");
        }
        return handleResourceChildren;
    }

    public boolean _handleResource(IResource res, IResourceDelta delta, IPath copyToPath) {
        if (null == copyToPath) {
            return false;
        }
        boolean handled = false;
        if (null != delta && delta.getKind() == 2) {
            this.addTask(new BuildHelper.DeleteTask(copyToPath, "build"));
            handled = true;
        } else if (!res.isTeamPrivateMember() && !res.getName().equals(".svn")) {
            this.addTask(new BuildHelper.CopyTask(res, copyToPath, "build"));
            handled = true;
        }
        return handled;
    }

    public int getCount() {
        return this.count;
    }
}

