/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.objectstyle.woenvironment.env.WOEnvironment;
import org.objectstyle.woenvironment.env.WOVariables;
import org.objectstyle.woenvironment.frameworks.ExternalFolderRoot;
import org.objectstyle.woenvironment.frameworks.FrameworkModel;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;

public class ExternalFrameworkModel
extends FrameworkModel<IFramework> {
    private WOEnvironment environment;

    public ExternalFrameworkModel(Hashtable<String, Object> existingProperties) {
        this.environment = new WOEnvironment(existingProperties);
    }

    private File fixMissingSeparatorAfterDevice(String string) {
        File file = string == null ? null : new File(string);
        return file;
    }

    public ExternalFolderRoot getRootForFolder(File frameworksFolder) throws IOException {
        File canonicalFolder = frameworksFolder.getCanonicalFile();
        for (Root root : this.getRoots()) {
            File baseFolder;
            if (!(root instanceof ExternalFolderRoot) || (baseFolder = ((ExternalFolderRoot)root).getFrameworksFolder()) == null || !baseFolder.getCanonicalFile().equals(canonicalFolder)) continue;
            return (ExternalFolderRoot)root;
        }
        return null;
    }

    @Override
    protected synchronized List<Root<IFramework>> createRoots() {
        LinkedList<Root<IFramework>> roots = new LinkedList<Root<IFramework>>();
        WOVariables variables = this.environment.getWOVariables();
        String projectLocalFrameworksFolder = variables.getProperty("projectFrameworkFolder");
        if (projectLocalFrameworksFolder != null) {
            File projectLocalRoot = new File(projectLocalFrameworksFolder);
            roots.add(new ExternalFolderRoot("ProjectLocal", "Project Local Frameworks", projectLocalRoot, projectLocalRoot));
        } else {
            roots.add(new ExternalFolderRoot("ProjectLocal", "Project Local Frameworks", null, null));
        }
        File externalBuildRootPath = this.fixMissingSeparatorAfterDevice(variables.externalBuildRoot());
        File externalBuildFrameworkPath = this.fixMissingSeparatorAfterDevice(variables.externalBuildFrameworkPath());
        roots.add(new ExternalFolderRoot("External", "External Build Root", externalBuildRootPath, externalBuildFrameworkPath));
        File userRoot = this.fixMissingSeparatorAfterDevice(variables.userRoot());
        File userFrameworksPath = this.fixMissingSeparatorAfterDevice(variables.userFrameworkPath());
        roots.add(new ExternalFolderRoot("User", "User Frameworks", userRoot, userFrameworksPath));
        File localRoot = this.fixMissingSeparatorAfterDevice(variables.localRoot());
        File localFrameworksPath = this.fixMissingSeparatorAfterDevice(variables.localFrameworkPath());
        roots.add(new ExternalFolderRoot("Local", "Local Frameworks", localRoot, localFrameworksPath));
        File systemRoot = this.fixMissingSeparatorAfterDevice(variables.systemRoot());
        File systemFrameworksPath = this.fixMissingSeparatorAfterDevice(variables.systemFrameworkPath());
        roots.add(new ExternalFolderRoot("System", "System Frameworks", systemRoot, systemFrameworksPath));
        File networkRoot = this.fixMissingSeparatorAfterDevice(variables.networkRoot());
        File networkFrameworksPath = this.fixMissingSeparatorAfterDevice(variables.networkFrameworkPath());
        roots.add(new ExternalFolderRoot("Network", "Network Frameworks", networkRoot, networkFrameworksPath));
        return roots;
    }
}

