/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.objectstyle.woenvironment.pbx.PBXBuildFile;
import org.objectstyle.woenvironment.pbx.PBXBuildPhase;
import org.objectstyle.woenvironment.pbx.PBXProject;
import org.objectstyle.woenvironment.pbx.PBXProjectCoder;
import org.objectstyle.woenvironment.pbx.PBXResourcesBuildPhase;
import org.objectstyle.woenvironment.pbx.PBXSourcesBuildPhase;
import org.objectstyle.woenvironment.pbx.PBXTarget;
import org.objectstyle.woenvironment.util.Parser;
import org.objectstyle.woproject.ant.WOApplication;
import org.objectstyle.woproject.ant.WOFileSet;
import org.objectstyle.woproject.ant.WOFramework;
import org.objectstyle.woproject.ant.WOTask;

public class WOPBXBuild
extends Task {
    protected String pbxproj;
    protected WOTask task;
    protected Vector<FileSet> classes = new Vector();
    protected String name = "";
    protected String destDir = "";

    public void setPbxproj(String pbxproj) {
        this.pbxproj = pbxproj;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getPbxproj() {
        return this.pbxproj;
    }

    public void addClasses(FileSet set) {
        this.classes.add(set);
    }

    public void execute() throws BuildException {
        Map dico = null;
        try {
            dico = (Map)new Parser(new File(new Path(this.getProject(), this.getPbxproj()).toString())).propertyList();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        if (dico == null) {
            return;
        }
        Map objects = (Map)dico.get("objects");
        String rootObject = (String)dico.get("rootObject");
        PBXProjectCoder coder = new PBXProjectCoder(objects, rootObject);
        String sourcesFiles = this.setUp(coder, rootObject);
        coder = null;
        objects = null;
        dico = null;
        Javac javac = new Javac();
        this.task.getSubtaskFactory().initChildTask((Task)javac);
        javac.setClasspathRef(new Reference(this.getProject(), "classpath"));
        javac.setDestdir(new File(this.getProject().getBaseDir(), "build"));
        javac.setSrcdir(new Path(this.getProject(), "."));
        javac.setIncludes(sourcesFiles);
        javac.setOptimize(true);
        javac.execute();
        Enumeration<FileSet> e = this.classes.elements();
        while (e.hasMoreElements()) {
            this.task.addClasses((WOFileSet)e.nextElement());
        }
        this.task.execute();
    }

    private String setUp(PBXProjectCoder coder, String rootObject) {
        File tempFile;
        WOFileSet set;
        PBXProject pbxProject = (PBXProject)coder.objectForRef(rootObject);
        PBXTarget mainTaget = (PBXTarget)pbxProject.getTargets().get(0);
        PBXTarget appTarget = (PBXTarget)pbxProject.getTargets().get(1);
        PBXTarget webTarget = (PBXTarget)pbxProject.getTargets().get(2);
        PBXBuildPhase javaPhase = null;
        PBXBuildPhase resourcesPhase = null;
        PBXBuildPhase webResourcesPhase = null;
        for (Object o : appTarget.getBuildPhases()) {
            if (o.getClass() == PBXSourcesBuildPhase.class) {
                javaPhase = (PBXSourcesBuildPhase)o;
            }
            if (o.getClass() != PBXResourcesBuildPhase.class) continue;
            resourcesPhase = (PBXResourcesBuildPhase)o;
        }
        for (Object o : webTarget.getBuildPhases()) {
            if (o.getClass() != PBXResourcesBuildPhase.class) continue;
            webResourcesPhase = (PBXResourcesBuildPhase)o;
        }
        Collection javaFiles = javaPhase.getFiles();
        Collection resourcesFiles = resourcesPhase.getFiles();
        Collection webResourcesFiles = webResourcesPhase.getFiles();
        String isa = mainTaget.getProductReference().getIsa();
        if (isa.equals("PBXApplicationReference")) {
            this.task = new WOApplication();
        } else if (isa.equals("PBXFrameworkReference")) {
            this.task = new WOFramework();
        }
        this.task.setOwningTarget(this.getOwningTarget());
        this.task.setProject(this.getProject());
        this.task.setTaskName(this.getTaskName());
        this.task.setLocation(this.getLocation());
        this.task.setName(this.name);
        this.task.setDestDir(this.destDir);
        String sourcesFiles = "";
        Iterator i = javaFiles.iterator();
        while (i.hasNext()) {
            String file = ((PBXBuildFile)i.next()).getPath();
            sourcesFiles = sourcesFiles + file + ",";
        }
        i = resourcesFiles.iterator();
        while (i.hasNext()) {
            set = new WOFileSet();
            tempFile = new File(this.getProject().getBaseDir(), ((PBXBuildFile)i.next()).getPath());
            set.setProject(this.getProject());
            if (tempFile.isDirectory()) {
                set.setDir(tempFile.getParentFile());
                set.setIncludes(tempFile.getName() + "/*");
            } else {
                set.setFile(tempFile);
            }
            this.task.addResources(set);
        }
        i = webResourcesFiles.iterator();
        while (i.hasNext()) {
            set = new WOFileSet();
            tempFile = new File(this.getProject().getBaseDir(), ((PBXBuildFile)i.next()).getPath());
            set.setProject(this.getProject());
            if (tempFile.isDirectory()) {
                set.setDir(tempFile.getParentFile());
                set.setIncludes(tempFile.getName() + "/*");
            } else {
                set.setFile(tempFile);
            }
            this.task.addWsresources(set);
        }
        return sourcesFiles;
    }
}

