/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.IEOEntityRelative;
import org.objectstyle.wolips.eomodeler.core.model.IUserInfoable;
import org.objectstyle.wolips.eomodeler.core.utils.BooleanUtils;
import org.objectstyle.wolips.eomodeler.core.utils.NotificationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEOAttributePath
implements IUserInfoable,
IEOEntityRelative {
    private EORelationshipPath myParentRelationshipPath;
    private IEOAttribute myChildAttribute;

    public AbstractEOAttributePath(EORelationshipPath _parentRelationshipPath, IEOAttribute _childAttribute) {
        this.myParentRelationshipPath = _parentRelationshipPath;
        this.myChildAttribute = _childAttribute;
    }

    public List<AbstractEOAttributePath> getPathElements() {
        LinkedList<AbstractEOAttributePath> pathElements = new LinkedList<AbstractEOAttributePath>();
        AbstractEOAttributePath pathElement = this;
        while (pathElement != null) {
            pathElements.add(0, pathElement);
            pathElement = pathElement.getParentRelationshipPath();
        }
        return pathElements;
    }

    public EORelationshipPath getParentRelationshipPath() {
        return this.myParentRelationshipPath;
    }

    public IEOAttribute getChildIEOAttribute() {
        return this.myChildAttribute;
    }

    public abstract String getChildClassName();

    @Override
    public NotificationMap<Object, Object> getUserInfo() {
        return this.myChildAttribute.getUserInfo();
    }

    @Override
    public void setUserInfo(Map<Object, Object> _userInfo) {
        this.myChildAttribute.setUserInfo(_userInfo);
    }

    @Override
    public void setUserInfo(Map<Object, Object> _userInfo, boolean _fireEvents) {
        this.myChildAttribute.setUserInfo(_userInfo, _fireEvents);
    }

    @Override
    public EOEntity getEntity() {
        return this.myChildAttribute.getEntity();
    }

    public EOEntity getRootEntity() {
        EOEntity entity = this.myParentRelationshipPath != null ? this.myParentRelationshipPath.getRootEntity() : this.getEntity();
        return entity;
    }

    public Boolean isToMany() {
        Boolean toMany = null;
        AbstractEOAttributePath attributePath = this;
        while (!BooleanUtils.isTrue(toMany) && attributePath != null) {
            IEOAttribute childAttribute = attributePath.getChildIEOAttribute();
            if (childAttribute == null) {
                toMany = Boolean.FALSE;
                attributePath = null;
                continue;
            }
            toMany = childAttribute.isToMany();
            attributePath = attributePath.getParentRelationshipPath();
        }
        return toMany;
    }

    public String toKeyPath() {
        StringBuffer sb = new StringBuffer();
        this.toKeyPath(sb);
        return sb.toString();
    }

    public boolean isValid() {
        return this.myChildAttribute != null;
    }

    protected void toKeyPath(StringBuffer _keyPathBuffer) {
        if (this.myParentRelationshipPath != null) {
            this.myParentRelationshipPath.toKeyPath(_keyPathBuffer);
            _keyPathBuffer.append(".");
        }
        if (this.myChildAttribute != null) {
            String name = this.myChildAttribute.getName();
            _keyPathBuffer.append(name);
        } else {
            _keyPathBuffer.append("<invalid>");
        }
    }

    public boolean isRelatedTo(EORelationship relationship) {
        return ComparisonUtils.equals((Object)relationship, (Object)this.myChildAttribute) || this.myParentRelationshipPath != null && this.myParentRelationshipPath.isRelatedTo(relationship);
    }

    @Override
    public void userInfoChanged(String path, Object oldValue, Object newValue) {
        this.myChildAttribute.userInfoChanged(path, oldValue, newValue);
    }
}

