/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListMap;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListSet;
import org.objectstyle.wolips.eomodeler.core.utils.BooleanUtils;

public class EOModelMap
implements Map,
Cloneable {
    public static final int YESNO = 1;
    public static final int YN = 2;
    public static final int YNOptionalDefaultNo = 3;
    public static final int YNOptionalDefaultYes = 4;
    private Map myBackingMap;

    public EOModelMap() {
        this(new PropertyListMap());
    }

    public EOModelMap(Map _backingMap) {
        this.myBackingMap = _backingMap == null ? new PropertyListMap() : _backingMap;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.cloneModelMap();
    }

    public EOModelMap cloneModelMap() {
        PropertyListMap sortedMap = new PropertyListMap();
        sortedMap.putAll(this.myBackingMap);
        return new EOModelMap(sortedMap);
    }

    public static Object[] asArray(Object o) {
        Collection c;
        if (o instanceof Collection && (c = (Collection)o).size() > 0) {
            return c.toArray();
        }
        return null;
    }

    public Map getBackingMap() {
        return this.myBackingMap;
    }

    public void setBoolean(String _key, Boolean _value, int _booleanStyle) {
        if (_value == null) {
            this.myBackingMap.remove(_key);
        } else if (_booleanStyle == 1) {
            this.myBackingMap.put(_key, _value != false ? "YES" : "NO");
        } else if (_booleanStyle == 3) {
            if (_value.booleanValue()) {
                this.myBackingMap.put(_key, "Y");
            } else if (!"N".equals(this.myBackingMap.get(_key))) {
                this.myBackingMap.remove(_key);
            }
        } else if (_booleanStyle == 4) {
            if (!_value.booleanValue()) {
                this.myBackingMap.put(_key, "N");
            } else if (!"Y".equals(this.myBackingMap.get(_key))) {
                this.myBackingMap.remove(_key);
            }
        } else {
            this.myBackingMap.put(_key, _value != false ? "Y" : "N");
        }
    }

    public boolean getBoolean(String _key, boolean defaultValue) {
        Boolean bool = this.getBoolean(_key);
        if (bool == null) {
            bool = defaultValue;
        }
        return bool;
    }

    public Boolean getBoolean(String _key) {
        Boolean boolValue;
        Object value = this.get(_key);
        if (value == null) {
            boolValue = null;
        } else if (value instanceof Boolean) {
            boolValue = (Boolean)value;
        } else if (value instanceof String) {
            String strValue = this.getString(_key, true);
            boolValue = strValue != null ? Boolean.valueOf(BooleanUtils.isTrue(strValue)) : null;
        } else {
            throw new IllegalArgumentException("Unknown boolean value '" + value + "' for '" + _key + "'");
        }
        return boolValue;
    }

    public void setMap(String _key, Map _map, boolean _skipIfEmpty) {
        Map map = _map;
        if (_skipIfEmpty && map != null && map.isEmpty()) {
            map = null;
        }
        if (map != null) {
            this.myBackingMap.put(_key, map);
        } else {
            this.myBackingMap.remove(_key);
        }
    }

    public Map getMap(String _key) {
        return (Map)this.myBackingMap.get(_key);
    }

    public Map getMap(String _key, boolean _clone) {
        PropertyListMap map = (PropertyListMap)this.myBackingMap.get(_key);
        if (_clone && map != null) {
            PropertyListMap sortedMap = new PropertyListMap();
            sortedMap.putAll(map);
            map = sortedMap;
        }
        return map;
    }

    public void setList(String _key, List _list, boolean _skipIfEmpty) {
        this.setCollection(_key, _list, _skipIfEmpty);
    }

    public void setSet(String _key, Set _list, boolean _skipIfEmpty) {
        this.setCollection(_key, _list, _skipIfEmpty);
    }

    public void setCollection(String _key, Collection _list, boolean _skipIfEmpty) {
        Collection list = _list;
        if (_skipIfEmpty && list != null && list.isEmpty()) {
            list = null;
        }
        if (list == null) {
            this.myBackingMap.remove(_key);
        } else {
            this.myBackingMap.put(_key, list);
        }
    }

    public Set getSet(String _key) {
        return (Set)this.myBackingMap.get(_key);
    }

    public Set getSet(String _key, boolean _clone) {
        PropertyListSet set = (PropertyListSet)this.myBackingMap.get(_key);
        if (_clone && set != null) {
            PropertyListSet sortedSet = new PropertyListSet();
            sortedSet.addAll(set);
            set = sortedSet;
        }
        return set;
    }

    public List getList(String _key) {
        return (List)this.myBackingMap.get(_key);
    }

    public List getList(String _key, boolean _clone) {
        LinkedList list = (LinkedList)this.myBackingMap.get(_key);
        if (_clone && list != null) {
            list = new LinkedList(list);
        }
        return list;
    }

    public void setString(String _key, String _value, boolean _emptyIsNull) {
        if (!(_value == null || _emptyIsNull && _value.trim().length() <= 0)) {
            this.myBackingMap.put(_key, _value);
        } else {
            this.myBackingMap.remove(_key);
        }
    }

    public String getString(String _key, boolean _emptyIsNull) {
        Object objValue = this.myBackingMap.get(_key);
        String strValue = objValue instanceof String ? (String)objValue : (objValue instanceof Number ? objValue.toString() : (objValue instanceof Boolean ? objValue.toString() : (String)objValue));
        if (_emptyIsNull && strValue != null && strValue.trim().length() == 0) {
            strValue = null;
        }
        return strValue;
    }

    public void setInteger(String _key, Integer _value) {
        if (_value == null) {
            this.myBackingMap.remove(_key);
        } else {
            this.myBackingMap.put(_key, _value);
        }
    }

    public Integer getInteger(String _key) {
        Integer integerValue;
        Object value = this.get(_key);
        if (value == null) {
            integerValue = null;
        } else if (value instanceof Integer) {
            integerValue = (Integer)value;
        } else if (value instanceof String) {
            String strValue = this.getString(_key, true);
            integerValue = Integer.valueOf(strValue);
        } else {
            throw new IllegalArgumentException("Unknown integer value '" + value + "' for '" + _key + "'");
        }
        return integerValue;
    }

    public void clear() {
        this.myBackingMap.clear();
    }

    public boolean containsKey(Object _key) {
        return this.myBackingMap.containsKey(_key);
    }

    public boolean containsValue(Object _value) {
        return this.myBackingMap.containsValue(_value);
    }

    public Set entrySet() {
        return this.myBackingMap.entrySet();
    }

    public boolean equals(Object _o) {
        return this.myBackingMap.equals(_o);
    }

    public Object get(Object _key) {
        return this.myBackingMap.get(_key);
    }

    public int hashCode() {
        return this.myBackingMap.hashCode();
    }

    public boolean isEmpty() {
        return this.myBackingMap.isEmpty();
    }

    public Set keySet() {
        return this.myBackingMap.keySet();
    }

    public Object put(Object arg0, Object arg1) {
        return this.myBackingMap.put(arg0, arg1);
    }

    public void putAll(Map arg0) {
        this.myBackingMap.putAll(arg0);
    }

    public Object remove(Object _key) {
        return this.myBackingMap.remove(_key);
    }

    public int size() {
        return this.myBackingMap.size();
    }

    public Collection values() {
        return this.myBackingMap.values();
    }

    public String toString() {
        return "[EOModelMap: backingMap = " + this.myBackingMap + "]";
    }
}

