/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectstyle.woenvironment.frameworks.Framework;
import org.objectstyle.woenvironment.frameworks.FrameworkLibrary;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.WOLXMLPropertyListSerialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFolderFramework
extends Framework {
    private File _frameworkFolder;
    private List<FrameworkLibrary> _libraries;
    private File _javaFolder;
    private File _javaClientFolder;
    private Map<String, Object> _infoPlist;
    private long _infoPListLastModified;

    public AbstractFolderFramework(Root<?> root, File frameworkFolder) {
        super(root, AbstractFolderFramework.frameworkNameForFolder(frameworkFolder));
        this._frameworkFolder = frameworkFolder;
        this.reloadLibraries();
    }

    public File getFrameworkFolder() {
        return this._frameworkFolder;
    }

    @Override
    public synchronized Map<String, Object> getInfoPlist() {
        Map propertyList = this._infoPlist;
        File infoPlist = new File(this._frameworkFolder, "Resources/Info.plist");
        if (infoPlist.exists()) {
            long infoPlistLastModified = infoPlist.lastModified();
            if (propertyList == null || infoPlistLastModified != this._infoPListLastModified) {
                try {
                    propertyList = (Map)WOLXMLPropertyListSerialization.propertyListWithContentsOfFile(infoPlist, (ParserDataStructureFactory)new SimpleParserDataStructureFactory());
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to parse an XML plist from '" + infoPlist + "'.", t);
                }
                this._infoPlist = propertyList;
                this._infoPListLastModified = infoPlistLastModified;
                this._libraries = null;
            }
        }
        return propertyList;
    }

    protected File addJars(File defaultJarFolder, Map<String, Object> infoPlist, String jarRootKey, String jarListKey, List<File> jarFiles) {
        boolean guessJars = true;
        File jarFolder = defaultJarFolder;
        if (infoPlist != null) {
            Object javaPathsObj;
            String javaRoot = (String)infoPlist.get(jarRootKey);
            if (javaRoot != null) {
                jarFolder = new File(this._frameworkFolder, javaRoot);
            }
            if ((javaPathsObj = infoPlist.get(jarListKey)) != null) {
                LinkedList<String> javaPaths;
                if (javaPathsObj instanceof List) {
                    javaPaths = (LinkedList<String>)javaPathsObj;
                } else {
                    javaPaths = new LinkedList<String>();
                    javaPaths.add((String)javaPathsObj);
                }
                if (javaPaths != null) {
                    for (String javaPath : javaPaths) {
                        File jarFile = new File(jarFolder, javaPath);
                        String jarFileName = jarFile.getName();
                        if (!jarFile.exists() || !jarFileName.toLowerCase().endsWith(".jar") || this.isSourceJar(jarFileName)) continue;
                        jarFiles.add(jarFile);
                    }
                    guessJars = false;
                }
            }
        }
        if (guessJars && jarFolder.exists()) {
            this.guessJars(jarFolder, jarFiles);
        }
        return jarFolder;
    }

    protected void guessJars(File folder, List<File> jarFiles) {
        File[] guessedJarFiles = folder.listFiles();
        if (guessedJarFiles != null && guessedJarFiles.length > 0) {
            for (File guessedJarFile : guessedJarFiles) {
                if (guessedJarFile.isDirectory()) {
                    this.guessJars(guessedJarFile, jarFiles);
                    continue;
                }
                String guessedJarFileName = guessedJarFile.getName();
                if (!guessedJarFileName.toLowerCase().endsWith(".jar") && !guessedJarFileName.toLowerCase().endsWith(".zip") || this.isSourceJar(guessedJarFileName)) continue;
                jarFiles.add(guessedJarFile);
            }
        }
    }

    public synchronized void reloadLibraries() {
        LinkedList<File> jarFiles = new LinkedList<File>();
        Map<String, Object> infoPlist = this.getInfoPlist();
        this._javaFolder = this.addJars(new File(this._frameworkFolder, "Resources/Java"), infoPlist, "NSJavaRoot", "NSJavaPath", jarFiles);
        this._javaClientFolder = this.addJars(new File(this._frameworkFolder, "WebServerResources/Java"), infoPlist, "NSJavaClientRoot", "NSJavaPathClient", jarFiles);
        this._libraries = new LinkedList<FrameworkLibrary>();
        for (File jarFile : jarFiles) {
            String jarFileName = jarFile.getName();
            String sourceJar = this.getSourceJarNameForJarNamed(jarFileName);
            File sourceJarFile = new File(jarFile.getParentFile(), sourceJar);
            if (!sourceJarFile.exists()) {
                sourceJarFile = jarFile;
            }
            FrameworkLibrary library = new FrameworkLibrary(jarFile, sourceJarFile, null, null, null);
            this._libraries.add(library);
        }
    }

    protected String getSourceJarNameForJarNamed(String jarName) {
        String sourceJarName = jarName.equalsIgnoreCase(this.getName() + ".jar") ? "src.jar" : jarName.replaceFirst("\\.jar", "-src.jar");
        return sourceJarName;
    }

    protected boolean isSourceJar(String jarName) {
        boolean isSourceJar = false;
        if (jarName.equals("src.jar") || jarName.endsWith("-src.jar")) {
            isSourceJar = true;
        }
        return isSourceJar;
    }

    @Override
    public synchronized List<FrameworkLibrary> getFrameworkLibraries() {
        if (this._libraries == null) {
            this.reloadLibraries();
        }
        return this._libraries;
    }

    @Override
    public IFramework resolveFramework() {
        return this;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public String toString() {
        return "[Framework: name = " + this.getName() + "; folder = " + this.getFrameworkFolder() + "]";
    }

    public static String frameworkNameForFolder(File frameworkFolder) {
        String name = frameworkFolder.getName();
        name = name.substring(0, name.lastIndexOf(".framework"));
        return name;
    }
}

