/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectstyle.woenvironment.frameworks.Framework;
import org.objectstyle.woenvironment.frameworks.FrameworkLibrary;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.WOLXMLPropertyListSerialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJarFramework
extends Framework {
    private File jarFile;
    private boolean isValid;
    private Map<String, Object> infoPList;

    public AbstractJarFramework(Root<?> root, File jarFile) {
        super(root, null);
        this.jarFile = jarFile;
        Map<String, Object> infoPList = this.getInfoPlist();
        if (infoPList != null) {
            this.setName((String)infoPList.get("NSExecutable"));
            this.isValid = true;
        } else {
            this.setName("Unknown: " + this.jarFile);
            this.isValid = false;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    @Override
    public synchronized Map<String, Object> getInfoPlist() {
        block8: {
            if (this.infoPList == null) {
                try {
                    JarFile jarFileObj = new JarFile(this.jarFile);
                    JarEntry infoPListEntry = jarFileObj.getJarEntry("Resources/Info.plist");
                    if (infoPListEntry == null) break block8;
                    InputStream infoPListStream = jarFileObj.getInputStream(infoPListEntry);
                    try {
                        this.infoPList = (Map)WOLXMLPropertyListSerialization.propertyListWithContentsOfInputStream(infoPListStream, new SimpleParserDataStructureFactory());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to parse an XML plist from '" + this.jarFile.getAbsolutePath() + "'.", t);
                    }
                    finally {
                        infoPListStream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load a framework from the jar '" + this.jarFile.getAbsolutePath() + "'.", e);
                }
            }
        }
        return this.infoPList;
    }

    @Override
    public List<FrameworkLibrary> getFrameworkLibraries() {
        LinkedList<FrameworkLibrary> libraries = new LinkedList<FrameworkLibrary>();
        libraries.add(new FrameworkLibrary(this.jarFile, null, null, null, null));
        return libraries;
    }

    @Override
    public IFramework resolveFramework() {
        return this;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public String toString() {
        return "[Framework: name = " + this.getName() + "; jar file = " + this.getJarFile() + "]";
    }
}

