/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.objectstyle.woenvironment.env.WOBuildPropertiesNotFoundException;
import org.objectstyle.woenvironment.env.WOEnvironment;
import org.objectstyle.woproject.ant.AppFormat;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.OtherClasspathSet;
import org.objectstyle.woproject.ant.WOTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WOApplication
extends WOTask {
    protected List<FrameworkSet> frameworkSets = new ArrayList<FrameworkSet>();
    protected List<OtherClasspathSet> otherClasspathSets = new ArrayList<OtherClasspathSet>();
    private WOEnvironment woEnvironment;
    protected String chmod = "750";
    protected String jvmOptions = "";
    protected String jvm = "java";
    protected String jdb = "jdb";
    protected String jdbOptions = "";
    protected boolean webXML = false;
    protected String webXML_WOROOT = null;
    protected String webXML_LOCALROOT = null;
    protected String webXML_WOAINSTALLROOT = null;
    protected String webXML_WOAppMode = null;
    protected String webXML_WOtaglib = null;
    protected String webXML_CustomContent = null;
    protected String startupScriptName = null;
    protected String frameworksBaseURL = null;
    protected boolean trueWar = false;

    @Override
    public void release() {
        super.release();
        this.frameworkSets = null;
        this.otherClasspathSets = null;
        this.woEnvironment = null;
    }

    public void setTrueWar(boolean trueWar) {
        this.trueWar = trueWar;
    }

    public boolean isTrueWar() {
        return this.trueWar;
    }

    @Override
    public String getPrincipalClass() {
        String aPrincipalClass = super.getPrincipalClass();
        if (aPrincipalClass == null || aPrincipalClass.length() == 0) {
            aPrincipalClass = "Application";
        }
        return aPrincipalClass;
    }

    public void execute() throws BuildException {
        AppFormat appFormat;
        super.execute();
        this.validateAttributes();
        this.log("Installing " + this.name + " in " + this.destDir);
        this.createDirectories();
        if (this.hasClasses()) {
            this.jarClasses();
        }
        if (this.hasSources()) {
            this.jarSources();
        }
        if (this.hasLib()) {
            this.copyLibs();
        }
        if (this.hasResources()) {
            this.copyResources();
        }
        if (this.hasWs()) {
            this.copyWsresources();
        }
        if (this.hasEmbeddedFrameworks()) {
            this.copyEmbeddedFrameworks();
        }
        if (this.hasEmbeddedOtherClasspaths()) {
            this.copyEmbeddedOtherClasspaths();
        }
        if ((appFormat = new AppFormat(this)).processTemplates()) {
            this.chmodScripts();
        }
        appFormat.release();
        this.frameworkSets = new ArrayList<FrameworkSet>();
        this.otherClasspathSets = new ArrayList<OtherClasspathSet>();
        this.woEnvironment = null;
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chmodScripts() throws BuildException {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") < 0) {
            File dir = null;
            FileSet fs = null;
            Chmod aChmod = null;
            try {
                dir = this.taskDir();
                super.log("chmod scripts in " + dir, 3);
                fs = new FileSet();
                fs.setDir(dir);
                fs.createInclude().setName("**/" + this.name);
                if (this.startupScriptName != null) {
                    fs.createInclude().setName("**/" + this.startupScriptName);
                }
                fs.createInclude().setName("**/*.sh");
                aChmod = this.getSubtaskFactory().getChmod();
                aChmod.setPerm(this.getChmod());
                aChmod.addFileset(fs);
                aChmod.execute();
            }
            finally {
                dir = null;
                fs = null;
                aChmod = null;
            }
        } else {
            super.log("'" + System.getProperty("os.name") + "' is some kind of windows, skipping chmod.");
        }
    }

    protected void copyEmbeddedFrameworks() throws BuildException {
        if (this.trueWar) {
            Jar jar = new Jar();
            jar.setOwningTarget(this.getOwningTarget());
            jar.setProject(this.getProject());
            jar.setTaskName(this.getTaskName());
            for (FrameworkSet frameworkSet : this.getFrameworkSets()) {
                String[] directories;
                File root = frameworkSet.getDir(this.getProject());
                DirectoryScanner directoryScanner = frameworkSet.getDirectoryScanner(this.getProject());
                for (String directory : directories = directoryScanner.getIncludedDirectories()) {
                    File[] frameworkJars;
                    if (!directory.endsWith(".framework")) {
                        throw new BuildException("'name' attribute must end with '.framework'");
                    }
                    File javaFolder = new File(directory + "/Resources/Java");
                    if (javaFolder.exists() && (frameworkJars = javaFolder.listFiles()) != null) {
                        for (File frameworkJar : frameworkJars) {
                            ZipFileSet jarFileSet = new ZipFileSet();
                            FilenameSelector jarFileSelector = new FilenameSelector();
                            jarFileSelector.setName(frameworkJar.getAbsolutePath());
                            jarFileSet.addFilename(jarFileSelector);
                            jar.addZipfileset(jarFileSet);
                        }
                    }
                    System.out.println("WOApplication.copyEmbeddedFrameworks:   directory = " + directory);
                }
            }
        } else {
            Copy cp = new Copy();
            cp.setOwningTarget(this.getOwningTarget());
            cp.setProject(this.getProject());
            cp.setTaskName(this.getTaskName());
            cp.setLocation(this.getLocation());
            cp.setTodir(this.embeddedFrameworksDir());
            boolean hasEmbeddedFrameworkSets = false;
            for (FrameworkSet frameworkSet : this.getFrameworkSets()) {
                String[] directories;
                if (!frameworkSet.getEmbed()) continue;
                File root = frameworkSet.getDir(this.getProject());
                DirectoryScanner directoryScanner = frameworkSet.getDirectoryScanner(this.getProject());
                for (String directory : directories = directoryScanner.getIncludedDirectories()) {
                    if (!directory.endsWith(".framework")) {
                        throw new BuildException("The includeded directory '" + directory + "' must end with '.framework'");
                    }
                    FileSet newFileSet = new FileSet();
                    newFileSet.setDir(root);
                    PatternSet.NameEntry include = newFileSet.createInclude();
                    include.setName(directory + "/**");
                    cp.addFileset(newFileSet);
                    hasEmbeddedFrameworkSets = true;
                }
            }
            if (hasEmbeddedFrameworkSets) {
                cp.execute();
            }
        }
    }

    protected void copyEmbeddedOtherClasspaths() throws BuildException {
        Copy cp = new Copy();
        cp.setOwningTarget(this.getOwningTarget());
        cp.setProject(this.getProject());
        cp.setTaskName(this.getTaskName());
        cp.setLocation(this.getLocation());
        cp.setTodir(this.contentsDir());
        boolean hasSet = false;
        for (OtherClasspathSet cs : this.getOtherClasspath()) {
            if (!cs.getEmbed()) continue;
            File root = cs.getDir(this.getProject());
            DirectoryScanner ds = cs.getDirectoryScanner(this.getProject());
            for (String includeName : ds.getIncludedDirectories()) {
                FileSet newCs = new FileSet();
                newCs.setDir(root);
                PatternSet.NameEntry include = newCs.createInclude();
                if (!includeName.endsWith("/")) {
                    includeName = includeName + "/";
                }
                include.setName(includeName);
                cp.addFileset(newCs);
                hasSet = true;
            }
        }
        if (hasSet) {
            cp.execute();
        }
    }

    @Override
    protected File taskDir() {
        return this.getProject().resolveFile(this.destDir + File.separator + this.name + ".woa");
    }

    protected File contentsDir() {
        return new File(this.taskDir(), "Contents");
    }

    protected String relativeEmbeddedFrameworksDir() {
        return "Frameworks";
    }

    protected File embeddedFrameworksDir() {
        return new File(this.contentsDir(), this.relativeEmbeddedFrameworksDir());
    }

    @Override
    protected File resourcesDir() {
        return new File(this.contentsDir(), "Resources");
    }

    @Override
    protected File wsresourcesDir() {
        return new File(this.contentsDir(), "WebServerResources");
    }

    @Override
    protected File wsresourcesDestDir() {
        File woLocation = new File(this.webServerDir(), "WebObjects");
        File appLocation = new File(woLocation, this.name + ".woa");
        File contentLocation = new File(appLocation, "Contents");
        return new File(contentLocation, "WebServerResources");
    }

    public String getWebXML_LOCALROOT() {
        return this.webXML_LOCALROOT;
    }

    public String getWebXML_WOAINSTALLROOT() {
        return this.webXML_WOAINSTALLROOT;
    }

    public String getWebXML_WOAppMode() {
        return this.webXML_WOAppMode;
    }

    public String getWebXML_WOROOT() {
        this.log(" WOApplication.getWebXML_WOROOT() webXML_WOROOT: " + this.webXML_WOROOT, 3);
        return this.webXML_WOROOT;
    }

    public String getWebXML_WOtaglib() {
        return this.webXML_WOtaglib;
    }

    public boolean getWebXML() {
        return this.webXML;
    }

    public void setWebXML_LOCALROOT(String string) {
        this.webXML_LOCALROOT = string;
    }

    public void setWebXML_WOAINSTALLROOT(String string) {
        this.webXML_WOAINSTALLROOT = string;
    }

    public void setWebXML_WOAppMode(String string) {
        this.webXML_WOAppMode = string;
    }

    public void setWebXML_WOROOT(String string) {
        this.webXML_WOROOT = string;
    }

    public void setWebXML_WOtaglib(String string) {
        this.webXML_WOtaglib = string;
    }

    public void setWebXML(boolean value) {
        this.webXML = value;
    }

    @Override
    protected boolean hasLib() {
        return this.lib.size() > 0;
    }

    protected boolean hasEmbeddedFrameworks() {
        List<FrameworkSet> theFrameworkSets = this.getFrameworkSets();
        int size = theFrameworkSets.size();
        for (int i = 0; i < size; ++i) {
            FrameworkSet fs = theFrameworkSets.get(i);
            if (!fs.getEmbed()) continue;
            return true;
        }
        return false;
    }

    public FrameworkSet createFrameworks() {
        FrameworkSet frameSet = new FrameworkSet();
        this.frameworkSets.add(frameSet);
        return frameSet;
    }

    public List<FrameworkSet> getFrameworkSets() {
        return this.frameworkSets;
    }

    protected boolean hasEmbeddedOtherClasspaths() {
        List<OtherClasspathSet> theClasspathSets = this.getOtherClasspath();
        int size = theClasspathSets.size();
        for (int i = 0; i < size; ++i) {
            OtherClasspathSet cs = theClasspathSets.get(i);
            if (!cs.getEmbed()) continue;
            return true;
        }
        return false;
    }

    public OtherClasspathSet createOtherclasspath() {
        OtherClasspathSet otherClasspathSet = new OtherClasspathSet();
        this.otherClasspathSets.add(otherClasspathSet);
        return otherClasspathSet;
    }

    public List<OtherClasspathSet> getOtherClasspath() {
        return this.otherClasspathSets;
    }

    public WOEnvironment getWOEnvironment() {
        if (this.woEnvironment != null) {
            return this.woEnvironment;
        }
        this.woEnvironment = new WOEnvironment(this.getProject().getProperties());
        if (!this.woEnvironment.variablesConfigured()) {
            this.getProject().fireBuildFinished((Throwable)new WOBuildPropertiesNotFoundException());
        }
        return this.woEnvironment;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setChmod(String string) {
        this.chmod = string;
    }

    public void setJDB(String jdbPath) {
        if (jdbPath == null || jdbPath.equals("${jdb}") || jdbPath.trim().length() <= 0) {
            jdbPath = "jdb";
        }
        this.jdb = jdbPath;
    }

    public String getJDB() {
        return this.jdb;
    }

    public void setJVM(String jvmPath) {
        if (jvmPath == null || jvmPath.equals("${jvm}") || jvmPath.trim().length() <= 0) {
            this.jvm = "java";
        }
        this.jvm = jvmPath;
    }

    public String getJVM() {
        return this.jvm;
    }

    public void setJDBOptions(String jdbOptions) {
        if (jdbOptions == null || jdbOptions.equals("${jdbOptions}") || jdbOptions.trim().length() <= 0) {
            jdbOptions = "";
        }
        this.jdbOptions = jdbOptions;
    }

    public String getJDBOptions() {
        return this.jdbOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        if (jvmOptions == null || jvmOptions.equals("${jvmOptions}") || jvmOptions.trim().length() <= 0) {
            jvmOptions = "";
        }
        this.jvmOptions = jvmOptions;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    @Override
    protected void validateAttributes() throws BuildException {
        this.log(" this.getName().validateAttributes(): " + this.getName() + " webXML: " + this.webXML + " webXML_WOROOT: " + this.webXML_WOROOT, 3);
        if (this.webXML) {
            if (this.webXML_WOROOT == null) {
                this.webXML_WOROOT = this.getWOEnvironment().getWOVariables().systemRoot();
                if (this.webXML_WOROOT == null) {
                    throw new BuildException("'webXML_WOROOT' attribute is missing.");
                }
            }
            if (this.webXML_LOCALROOT == null) {
                this.webXML_LOCALROOT = this.getWOEnvironment().getWOVariables().localRoot();
                if (this.webXML_LOCALROOT == null) {
                    throw new BuildException("'webXML_LOCALROOT' attribute is missing.");
                }
            }
            if (this.webXML_WOAINSTALLROOT == null) {
                this.webXML_WOAINSTALLROOT = this.getWOEnvironment().getWOVariables().appsRoot();
                if (this.webXML_WOAINSTALLROOT == null) {
                    throw new BuildException("'webXML_WOAINSTALLROOT' attribute is missing.");
                }
            }
            if (this.webXML_WOAppMode == null) {
                this.webXML_WOAppMode = "Development";
                if (this.webXML_WOAppMode == null) {
                    throw new BuildException("'webXML_WOAppMode' attribute is missing.");
                }
            }
            if (this.webXML_WOtaglib == null) {
                this.webXML_WOtaglib = "/WEB-INF/tlds/WOtaglib_1_0.tld";
                if (this.webXML_WOtaglib == null) {
                    throw new BuildException("'webXML_WOtaglib' attribute is missing.");
                }
            }
        }
    }

    public String getWebXML_CustomContent() {
        return this.webXML_CustomContent;
    }

    public void setWebXML_CustomContent(String webXML_CustomContent) {
        this.webXML_CustomContent = webXML_CustomContent;
    }

    public String getStartupScriptName() {
        return this.startupScriptName;
    }

    public void setStartupScriptName(String startupScriptName) {
        this.startupScriptName = startupScriptName;
    }

    public String getFrameworksBaseURL() {
        return this.frameworksBaseURL;
    }

    public void setFrameworksBaseURL(String frameworksBaseURL) {
        this.frameworksBaseURL = frameworksBaseURL;
    }
}

