/* ====================================================================
 *
 * The ObjectStyle Group Software License, Version 1.0
 *
 * Copyright (c) 2006 The ObjectStyle Group,
 * and individual authors of the software.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        ObjectStyle Group (http://objectstyle.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "ObjectStyle Group" and "Cayenne"
 *    must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact andrus@objectstyle.org.
 *
 * 5. Products derived from this software may not be called "ObjectStyle"
 *    nor may "ObjectStyle" appear in their names without prior written
 *    permission of the ObjectStyle Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE OBJECTSTYLE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the ObjectStyle Group.  For more
 * information on the ObjectStyle Group, please see
 * <http://objectstyle.org/>.
 *
 */
package org.objectstyle.woproject.maven2.wolifecycle;

import java.io.File;
import java.util.List;

import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;

public abstract class AbstractWOMojo extends AbstractMojo {

	public final static String MAVEN_WEBOBJECTS_GROUP_ID = "com.webobjects";

	/**
	 * @parameter expression="${project.build.directory}"
	 * @required
	 * @readonly
	 */
	private File buildDirectory;

	/**
	 * Classifier to add to the artifact generated. If given, the artifact will
	 * be an attachment instead.
	 * 
	 * @parameter
	 */
	private String classifier;

	/**
	 * The set of dependencies required by the project
	 * 
	 * @parameter default-value="${project.dependencies}"
	 * @required
	 * @readonly
	 */
	private List<Artifact> dependencies;

	/**
	 * The name of the generated package (framework or application).
	 * 
	 * @parameter expression="${project.build.finalName}"
	 * @required
	 */
	private String finalName;

	/**
	 * @parameter expression="${localRepository}"
	 * @required
	 * @readonly
	 */
	private ArtifactRepository localRepository;

	/**
	 * The maven project.
	 * 
	 * @parameter expression="${project}"
	 * @required
	 * @readonly
	 */
	private MavenProject project;

	public AbstractWOMojo() {
		super();
	}

	public File getBuildDirectory() {
		return buildDirectory;
	}

	public String getClassifier() {

		return classifier;
	}

	protected String getClassifierAsString() {
		return getClassifier() == null ? "" : "-" + getClassifier();
	}

	public List<Artifact> getDependencies() {
		return dependencies;
	}

	public String getFinalName() {
		return finalName;
	}

	public ArtifactRepository getLocalRepository() {
		return localRepository;
	}

	public abstract String getProductExtension();

	public MavenProject getProject() {
		return project;
	}

	protected File getProjectFolder() {
		return getProject().getBasedir();
	}

	protected File getWOProjectFolder() {
		File file = new File(getProjectFolder(), "woproject");

		return file.exists() ? file : null;
	}

	protected boolean isWebObjectAppleGroup(final String dependencyGroup) {
		if (dependencyGroup == null) {
			return false;
		}

		String normalizedGroup = FilenameUtils.separatorsToUnix(dependencyGroup);

		boolean returnValue = MAVEN_WEBOBJECTS_GROUP_ID.equals(normalizedGroup);

		getLog().debug("The group " + normalizedGroup + " is " + (returnValue ? "" : "NOT ") + "an Apple group.");

		return returnValue;
	}

	public void setBuildDirectory(final File buildDirectory) {
		this.buildDirectory = buildDirectory;
	}

	public void setClassifier(final String classifier) {
		this.classifier = classifier;
	}

	public void setFinalName(final String finalName) {
		this.finalName = finalName;
	}
}
