/*
 * ====================================================================
 * 
 * The ObjectStyle Group Software License, Version 1.0
 * 
 * Copyright (c) 2005 The ObjectStyle Group and individual authors of the
 * software. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: 1.
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. 2. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution. 3. The end-user documentation
 * included with the redistribution, if any, must include the following
 * acknowlegement: "This product includes software developed by the ObjectStyle
 * Group (http://objectstyle.org/)." Alternately, this acknowlegement may
 * appear in the software itself, if and wherever such third-party
 * acknowlegements normally appear. 4. The names "ObjectStyle Group" and
 * "Cayenne" must not be used to endorse or promote products derived from this
 * software without prior written permission. For written permission, please
 * contact andrus@objectstyle.org. 5. Products derived from this software may
 * not be called "ObjectStyle" nor may "ObjectStyle" appear in their names
 * without prior written permission of the ObjectStyle Group.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * OBJECTSTYLE GROUP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 * 
 * This software consists of voluntary contributions made by many individuals
 * on behalf of the ObjectStyle Group. For more information on the ObjectStyle
 * Group, please see <http://objectstyle.org/> .
 *  
 */
package org.objectstyle.wolips.componenteditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.objectstyle.wolips.baseforuiplugins.AbstractBaseUIActivator;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 * 
 * @author mike
 */
public class ComponenteditorPlugin extends AbstractBaseUIActivator {
	public static final String COMPONENT_WOCONDITIONAL_ICON = "conditional";
	
	public static final String COMPONENT_ICON = "component";
	
	public static final String TO_ONE_ICON = "toOne";
	
	public static final String TO_MANY_ICON = "toMany";
	
	public static final String CONNECTED_ICON = "connected";
	
	public static final String UNCONNECTED_ICON = "unconnected";
	
	public static final String UNCONNECTED_PROBLEM_ICON = "unconnectedProblem";

	public static final String PLUGIN_ID = "org.objectstyle.wolips.componenteditor";
	
	// The shared instance.
	private static ComponenteditorPlugin plugin;

	/**
	 * The constructor.
	 */
	public ComponenteditorPlugin() {
		super();
		plugin = this;
	}
	
	protected void initializeImageRegistry(ImageRegistry _reg) {
		super.initializeImageRegistry(_reg);
		_reg.put(ComponenteditorPlugin.UNCONNECTED_ICON, AbstractUIPlugin.imageDescriptorFromPlugin(ComponenteditorPlugin.PLUGIN_ID, "/icons/unconnected.png"));
		_reg.put(ComponenteditorPlugin.UNCONNECTED_PROBLEM_ICON, AbstractUIPlugin.imageDescriptorFromPlugin(ComponenteditorPlugin.PLUGIN_ID, "/icons/unconnectedProblem.png"));
		_reg.put(ComponenteditorPlugin.CONNECTED_ICON, AbstractUIPlugin.imageDescriptorFromPlugin(ComponenteditorPlugin.PLUGIN_ID, "/icons/connected.png"));
		_reg.put(ComponenteditorPlugin.COMPONENT_ICON, AbstractUIPlugin.imageDescriptorFromPlugin(ComponenteditorPlugin.PLUGIN_ID, "/icons/component.png"));
		_reg.put(ComponenteditorPlugin.COMPONENT_WOCONDITIONAL_ICON, AbstractUIPlugin.imageDescriptorFromPlugin(ComponenteditorPlugin.PLUGIN_ID, "/icons/conditional.png"));
		_reg.put(ComponenteditorPlugin.TO_ONE_ICON, AbstractUIPlugin.imageDescriptorFromPlugin(ComponenteditorPlugin.PLUGIN_ID, "/icons/toOne.png"));
		_reg.put(ComponenteditorPlugin.TO_MANY_ICON, AbstractUIPlugin.imageDescriptorFromPlugin(ComponenteditorPlugin.PLUGIN_ID, "/icons/toMany.png"));
	}


	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static ComponenteditorPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path.
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	public Image getImage(String key) {
		return getImageRegistry().get(key);
	}

}
