/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.util.Set;
import org.objectstyle.woenvironment.frameworks.IFramework;

public abstract class Root<T extends IFramework> {
    public static final String PROJECT_ROOT = "Project";
    public static final String PROJECT_LOCAL_ROOT = "ProjectLocal";
    public static final String EXTERNAL_ROOT = "External";
    public static final String USER_ROOT = "User";
    public static final String NETWORK_ROOT = "Network";
    public static final String LOCAL_ROOT = "Local";
    public static final String SYSTEM_ROOT = "System";
    public static final String CLASSPATH_ROOT = "Classpath";
    private String shortName;
    private String name;
    private long creationDate;

    public Root(String shortName, String name) {
        this.shortName = shortName;
        this.name = name;
        this.creationDate = System.currentTimeMillis();
    }

    public boolean shouldReload() {
        return System.currentTimeMillis() - this.creationDate > 30000L;
    }

    public abstract Set<T> getFrameworks();

    public T getFrameworkWithName(String frameworkName) {
        Set<T> frameworks = this.getFrameworks();
        for (IFramework framework : frameworks) {
            if (!framework.getName().equals(frameworkName)) continue;
            return (T)framework;
        }
        return null;
    }

    public abstract Set<T> getApplications();

    public T getApplicationWithName(String applicationName) {
        Set<T> applications = this.getApplications();
        for (IFramework application : applications) {
            if (!application.getName().equals(applicationName)) continue;
            return (T)application;
        }
        return null;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }
}

