/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.pb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;

public class PBXProject {
    protected ArrayList _resourceFolderRefs = new ArrayList();
    protected ArrayList _resourceFileRefs = new ArrayList();
    protected ArrayList _wsresourceFolderRefs = new ArrayList();
    protected ArrayList _wsresourceFileRefs = new ArrayList();
    protected ArrayList _frameworkRefs = new ArrayList();
    protected ArrayList _sourceRefs = new ArrayList();

    public void addSourceReference(String path) {
        if (!this._sourceRefs.contains(path)) {
            this._sourceRefs.add(path);
        }
    }

    public void removeSourceReference(String path) {
        this._sourceRefs.remove(path);
    }

    public void addResourceFileReference(String path) {
        if (!this._resourceFileRefs.contains(path)) {
            this._resourceFileRefs.add(path);
        }
    }

    public void removeResourceFileReference(String path) {
        this._resourceFileRefs.remove(path);
    }

    public void addResourceFolderReference(String path) {
        if (!this._resourceFolderRefs.contains(path)) {
            this._resourceFolderRefs.add(path);
        }
    }

    public void removeResourceFolderReference(String path) {
        this._resourceFolderRefs.remove(path);
    }

    public void addWSResourceFileReference(String path) {
        if (!this._wsresourceFileRefs.contains(path)) {
            this._wsresourceFileRefs.add(path);
        }
    }

    public void removeWSResourceFileReference(String path) {
        this._wsresourceFileRefs.remove(path);
    }

    public void addWSResourceFolderReference(String path) {
        if (!this._wsresourceFolderRefs.contains(path)) {
            this._wsresourceFolderRefs.add(path);
        }
    }

    public void removeWSResourceFolderReference(String path) {
        this._wsresourceFolderRefs.remove(path);
    }

    public void addFrameworkReference(String path) {
        if (!this._frameworkRefs.contains(path)) {
            this._frameworkRefs.add(path);
        }
    }

    public void removeFrameworkReference(String path) {
        this._frameworkRefs.remove(path);
    }

    public void save(File projectFile) throws PropertyListParserException, IOException {
        ObjectsTable.ID refID;
        Map reference;
        File file;
        String projectPath;
        ObjectsTable objectsTable = new ObjectsTable();
        try {
            projectPath = projectFile.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't get path of project file: " + projectFile);
        }
        int last = projectPath.lastIndexOf(File.separator);
        if (last != -1) {
            projectPath = projectPath.substring(0, last);
        }
        if ((last = projectPath.lastIndexOf(File.separator)) != -1) {
            projectPath = projectPath.substring(0, last);
        }
        ArrayList<ObjectsTable.ID> sourceFileIDs = new ArrayList<ObjectsTable.ID>();
        ArrayList<ObjectsTable.ID> resourceFileIDs = new ArrayList<ObjectsTable.ID>();
        ArrayList<ObjectsTable.ID> wsresourceFileIDs = new ArrayList<ObjectsTable.ID>();
        ArrayList<ObjectsTable.ID> frameworkFileIDs = new ArrayList<ObjectsTable.ID>();
        for (String path : this._sourceRefs) {
            if (path.indexOf(projectPath) == 0) {
                path = path.substring(projectPath.length() + 1);
            }
            file = new File(path);
            reference = this.newFileReference(file.getName(), path);
            refID = objectsTable.insert(reference);
            sourceFileIDs.add(refID);
        }
        for (String path : this._resourceFileRefs) {
            if (path.indexOf(projectPath) == 0) {
                path = path.substring(projectPath.length() + 1);
            }
            file = new File(path);
            if (this._resourceFolderRefs.contains(projectPath + "/" + file.getParent())) continue;
            reference = this.newFileReference(file.getName(), path);
            refID = objectsTable.insert(reference);
            resourceFileIDs.add(refID);
        }
        for (String path : this._resourceFolderRefs) {
            if (path.indexOf(projectPath) == 0) {
                path = path.substring(projectPath.length() + 1);
            }
            file = new File(path);
            reference = this.newFolderReference(file.getName(), path);
            refID = objectsTable.insert(reference);
            resourceFileIDs.add(refID);
        }
        for (String path : this._wsresourceFileRefs) {
            if (path.indexOf(projectPath) == 0) {
                path = path.substring(projectPath.length() + 1);
            }
            file = new File(path);
            if (this._wsresourceFolderRefs.contains(projectPath + "/" + file.getParent())) continue;
            reference = this.newFileReference(file.getName(), path);
            refID = objectsTable.insert(reference);
            wsresourceFileIDs.add(refID);
        }
        for (String path : this._wsresourceFolderRefs) {
            if (path.indexOf(projectPath) == 0) {
                path = path.substring(projectPath.length() + 1);
            }
            file = new File(path);
            reference = this.newFolderReference(file.getName(), path);
            refID = objectsTable.insert(reference);
            wsresourceFileIDs.add(refID);
        }
        for (String path : this._frameworkRefs) {
            Map reference2 = this.newFrameworkReference(new File(path).getName(), path);
            ObjectsTable.ID refID2 = objectsTable.insert(reference2);
            frameworkFileIDs.add(refID2);
        }
        ArrayList<ObjectsTable.ID> childrenIDs = new ArrayList<ObjectsTable.ID>();
        childrenIDs.add(objectsTable.insert(this.newGroup("Sources", sourceFileIDs)));
        childrenIDs.add(objectsTable.insert(this.newGroup("Resources", resourceFileIDs)));
        childrenIDs.add(objectsTable.insert(this.newGroup("Web Server", wsresourceFileIDs)));
        childrenIDs.add(objectsTable.insert(this.newGroup("Frameworks", frameworkFileIDs)));
        ObjectsTable.ID mainGroupID = objectsTable.insert(this.newGroup("Root", childrenIDs));
        ArrayList<ObjectsTable.ID> targetIDs = new ArrayList<ObjectsTable.ID>(2);
        List phases = this.newBuildPhaseList(sourceFileIDs, resourceFileIDs, wsresourceFileIDs, frameworkFileIDs, objectsTable);
        Map appServerTarget = this.newAppServerTarget(phases, objectsTable);
        phases = this.newBuildPhaseList(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, objectsTable);
        Map antTarget = this.newAntTarget(phases, objectsTable);
        phases = this.newBuildPhaseList(Collections.EMPTY_LIST, Collections.EMPTY_LIST, wsresourceFileIDs, Collections.EMPTY_LIST, objectsTable);
        Map webServerTarget = this.newWebServerTarget(phases, objectsTable);
        targetIDs.add(objectsTable.insert(appServerTarget));
        targetIDs.add(objectsTable.insert(antTarget));
        targetIDs.add(objectsTable.insert(webServerTarget));
        ObjectsTable.ID projectID = objectsTable.insert(this.newProject(mainGroupID, targetIDs, objectsTable));
        Map pbxproj = this.newPBXProj(objectsTable, projectID);
        WOLPropertyListSerialization.propertyListToFile("", projectFile, pbxproj);
    }

    protected List newBuildFileList(List fileIDs, ObjectsTable objectsTable) {
        ArrayList<ObjectsTable.ID> result = new ArrayList<ObjectsTable.ID>(fileIDs.size());
        for (ObjectsTable.ID refID : fileIDs) {
            result.add(objectsTable.insert(this.newBuildFile(refID)));
        }
        return result;
    }

    protected List newBuildPhaseList(List sourceFileIDs, List resourceFileIDs, List wsresourceFileIDs, List frameworkFileIDs, ObjectsTable objectsTable) {
        ArrayList<ObjectsTable.ID> buildPhaseIDs = new ArrayList<ObjectsTable.ID>(4);
        if (this.hasBuildPhases()) {
            buildPhaseIDs.add(objectsTable.insert(this.newSourcesBuildPhase(this.newBuildFileList(sourceFileIDs, objectsTable))));
            buildPhaseIDs.add(objectsTable.insert(this.newResourcesBuildPhase(this.newBuildFileList(resourceFileIDs, objectsTable))));
            buildPhaseIDs.add(objectsTable.insert(this.newWSResourcesBuildPhase(this.newBuildFileList(wsresourceFileIDs, objectsTable))));
            buildPhaseIDs.add(objectsTable.insert(this.newFrameworkBuildPhase(this.newBuildFileList(frameworkFileIDs, objectsTable))));
        }
        return buildPhaseIDs;
    }

    protected Map map(Object[] keyValues) {
        TreeMap<Object, Object> result = new TreeMap<Object, Object>();
        for (int i = 0; i < keyValues.length; i += 2) {
            result.put(keyValues[i], keyValues[i + 1]);
        }
        return result;
    }

    protected Map newFileReference(String name, String path) {
        return this.map(new Object[]{"isa", "PBXFileReference", "refType", new File(path).isAbsolute() ? "0" : "2", "name", name, "path", path});
    }

    protected Map newFolderReference(String name, String path) {
        return this.map(new Object[]{"isa", "PBXFolderReference", "refType", new File(path).isAbsolute() ? "0" : "2", "name", name, "path", path});
    }

    protected Map newFrameworkReference(String name, String path) {
        return this.map(new Object[]{"isa", "PBXFrameworkReference", "refType", "0", "name", name, "path", path});
    }

    protected Map newBuildFile(ObjectsTable.ID fileRefID) {
        return this.map(new Object[]{"isa", "PBXBuildFile", "fileRef", fileRefID});
    }

    protected Map newFrameworkBuildPhase(List buildFileIDs) {
        return this.map(new Object[]{"isa", "PBXFrameworksBuildPhase", "files", buildFileIDs});
    }

    protected Map newResourcesBuildPhase(List buildFileIDs) {
        return this.map(new Object[]{"isa", "PBXResourcesBuildPhase", "files", buildFileIDs});
    }

    protected Map newWSResourcesBuildPhase(List buildFileIDs) {
        return this.map(new Object[]{"isa", "PBXResourcesBuildPhase", "files", buildFileIDs});
    }

    protected Map newSourcesBuildPhase(List buildFileIDs) {
        return this.map(new Object[]{"isa", "PBXSourcesBuildPhase", "files", buildFileIDs});
    }

    protected Map newGroup(String name, List childrenIDs) {
        return this.map(new Object[]{"isa", "PBXGroup", "refType", "4", "name", name, "children", childrenIDs});
    }

    protected Map newAppServerTarget(List buildPhaseIDs, ObjectsTable objectsTable) {
        return this.map(new Object[]{"isa", "PBXToolTarget", "buildSettings", new HashMap(), "name", "Application Server", "buildPhases", buildPhaseIDs});
    }

    protected Map newWebServerTarget(List buildPhaseIDs, ObjectsTable objectsTable) {
        return this.map(new Object[]{"isa", "PBXToolTarget", "buildSettings", new HashMap(), "name", "Web Server", "buildPhases", buildPhaseIDs});
    }

    protected Map newAntTarget(List buildPhaseIDs, ObjectsTable objectsTable) {
        Map result = this.map(new Object[]{"isa", "PBXLegacyTarget", "buildArgumentsString", "-emacs $(ACTION)", "buildSettings", new HashMap(), "buildToolPath", "/Developer/Java/Ant/bin/ant", "passBuildSettingsInEnvironment", "1", "name", "Ant", "buildPhases", buildPhaseIDs});
        LinkedList<ObjectsTable.ID> buildConfigurations = new LinkedList<ObjectsTable.ID>();
        buildConfigurations.add(objectsTable.insert(this.newBuildConfiguration(this.map(new Object[]{"COPY_PHASE_STRIP", "NO"}), "Debug")));
        buildConfigurations.add(objectsTable.insert(this.newBuildConfiguration(this.map(new Object[]{"COPY_PHASE_STRIP", "YES"}), "Release")));
        buildConfigurations.add(objectsTable.insert(this.newBuildConfiguration(new HashMap(), "Default")));
        result.put("buildConfigurationList", objectsTable.insert(this.newBuildConfigurationList(buildConfigurations, false, "Default")));
        result.put("productName", "Ant");
        return result;
    }

    protected Map newBuildConfigurationList(List _buildConfigurations, boolean _defaultConfigurationIsVisible, String _defaultConfigurationName) {
        Map buildConfigurationList = this.map(new Object[]{"buildConfigurations", _buildConfigurations, "defaultConfigurationIsVisible", _defaultConfigurationIsVisible ? "1" : "0", "defaultConfigurationName", _defaultConfigurationName, "isa", "XCConfigurationList"});
        return buildConfigurationList;
    }

    protected Map newBuildStyle(Map _buildSettings, String _name) {
        return this.newBuildStyleOrConfiguration(_buildSettings, "PBXBuildStyle", _name);
    }

    protected Map newBuildConfiguration(Map _buildSettings, String _name) {
        return this.newBuildStyleOrConfiguration(_buildSettings, "XCBuildConfiguration", _name);
    }

    protected Map newBuildStyleOrConfiguration(Map _buildSettings, String _isa, String _name) {
        return this.map(new Object[]{"buildSettings", _buildSettings, "isa", _isa, "name", _name});
    }

    protected Map newProject(ObjectsTable.ID groupID, List targetIDs, ObjectsTable objectsTable) {
        return this.map(new Object[]{"isa", "PBXProject", "hasScannedForEncodings", "1", "projectDirPath", ".", "mainGroup", groupID, "targets", targetIDs});
    }

    protected Map newPBXProj(Map objectsTable, ObjectsTable.ID rootObject) {
        return this.map(new Object[]{"archiveVersion", "1", "objectVersion", "38", "rootObject", rootObject, "objects", objectsTable});
    }

    protected boolean hasBuildPhases() {
        return true;
    }

    protected static class ObjectsTable
    extends TreeMap {
        protected int _unique = 1;

        public ObjectsTable() {
            super(new Comparator(){

                public int compare(Object a, Object b) {
                    if (a == b) {
                        return 0;
                    }
                    if (a == null) {
                        return -1;
                    }
                    if (b == null) {
                        return 1;
                    }
                    return a.toString().compareTo(b.toString());
                }
            });
        }

        public ID insert(Object object) {
            ID id = new ID(this._unique++);
            this.put(id, object);
            return id;
        }

        public static class ID
        extends Number {
            int _value;

            protected ID(int value) {
                this._value = value;
            }

            public String toString() {
                String hexValue = Integer.toHexString(this._value);
                StringBuffer result = new StringBuffer(24);
                for (int i = 24 - hexValue.length(); i > 0; --i) {
                    result.append('0');
                }
                result.append(hexValue);
                return result.toString();
            }

            @Override
            public double doubleValue() {
                return 0.0;
            }

            @Override
            public float floatValue() {
                return 0.0f;
            }

            @Override
            public int intValue() {
                return 0;
            }

            @Override
            public long longValue() {
                return 0L;
            }

            @Override
            public short shortValue() {
                return 0;
            }
        }
    }
}

