/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.HashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class OtherClasspathSet
extends FileSet {
    protected File aDirectory;
    protected boolean packagesOnly = false;
    protected boolean embed = false;
    protected boolean eclipse = false;

    public void setEclipse(boolean eclipse) {
        this.eclipse = eclipse;
    }

    public boolean isEclipse() {
        return this.eclipse;
    }

    private File[] findPackages(Project aProject, String packageDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(new String[]{"**/*.jar", "**/*.zip"});
        ds.setBasedir(this.getDir(aProject) + File.separator + packageDir);
        ds.setCaseSensitive(true);
        ds.scan();
        String[] foundPackages = ds.getIncludedFiles();
        int size = foundPackages.length;
        File[] finalFiles = new File[size];
        for (int i = 0; i < size; ++i) {
            finalFiles[i] = new File(this.getDir(aProject), foundPackages[i]);
        }
        return finalFiles;
    }

    public void collectClassPaths(Project aProject, HashSet<File> pathSet) throws BuildException {
        int i;
        DirectoryScanner ds = this.getDirectoryScanner(aProject);
        String[] directories = ds.getIncludedDirectories();
        String[] files = ds.getIncludedFiles();
        for (i = 0; i < directories.length; ++i) {
            if (this.isPackagesOnly()) {
                File[] paths = this.findPackages(aProject, directories[i]);
                if (paths == null || paths.length == 0) {
                    this.log("No Jars in project:" + aProject + ", ignoring.", 3);
                    continue;
                }
                if (this.getEmbed()) {
                    this.log("embed and isPackagesOnly are mutually exclusive");
                    continue;
                }
                int jsize = paths.length;
                for (int k = 0; k < jsize; ++k) {
                    pathSet.add(paths[k]);
                }
                continue;
            }
            File directory = new File(this.getDir(aProject), directories[i]);
            if (!directory.exists()) continue;
            if (this.getEmbed()) {
                pathSet.add(new File("APPROOT", directories[i]));
                continue;
            }
            pathSet.add(directory);
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".zip") && !files[i].endsWith(".jar")) {
                this.log("No Jars in " + files[i] + ", ignoring.", 3);
                continue;
            }
            File packageFile = new File(this.getDir(aProject), files[i]);
            if (!packageFile.exists()) continue;
            pathSet.add(packageFile);
        }
    }

    public boolean isPackagesOnly() {
        return this.packagesOnly;
    }

    public void setDir(File dir) throws BuildException {
        this.aDirectory = dir;
        super.setDir(this.aDirectory);
    }

    public void setRoot(File aRoot) throws BuildException {
        this.aDirectory = aRoot;
        super.setDir(this.aDirectory);
    }

    public void setPackagesOnly(boolean packagesOnly) {
        this.packagesOnly = packagesOnly;
    }

    public void setEmbed(boolean embed) {
        this.embed = embed;
    }

    public boolean getEmbed() {
        return this.embed;
    }
}

