/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.FrameworkFormat;
import org.objectstyle.woproject.ant.WOTask;

public class WOFramework
extends WOTask {
    protected String eoAdaptorClassName;

    @Override
    public void addLib(FileSet set) {
        this.lib.addElement(set);
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.log("Installing " + this.name + " in " + this.destDir);
        this.createDirectories();
        if (this.hasClasses()) {
            this.jarClasses();
        }
        if (this.hasSources()) {
            this.jarSources();
        }
        if (this.hasLib()) {
            this.copyLibs();
        }
        if (this.hasResources()) {
            this.copyResources();
        }
        if (this.hasWs()) {
            this.copyWsresources();
        }
        new FrameworkFormat(this).processTemplates();
    }

    @Override
    protected File taskDir() {
        return this.getProject().resolveFile(this.destDir + File.separator + this.name + ".framework");
    }

    @Override
    protected File resourcesDir() {
        return new File(this.taskDir(), "Resources");
    }

    @Override
    protected File wsresourcesDir() {
        return new File(this.taskDir(), "WebServerResources");
    }

    @Override
    protected File wsresourcesDestDir() {
        File woLocation = new File(this.webServerDir(), "WebObjects");
        File frameworksLocation = new File(woLocation, "Frameworks");
        File frameworkLocation = new File(frameworksLocation, this.name + ".framework");
        return new File(frameworkLocation, "WebServerResources");
    }

    protected void cleanUp() {
        this.classes.clear();
        this.lib.clear();
        this.resources.clear();
        this.wsresources.clear();
        this.sources.clear();
    }

    public String getEOAdaptorClassName() {
        return this.eoAdaptorClassName;
    }

    public void setEOAdaptorClassName(String eoAdaptorClassName) {
        this.eoAdaptorClassName = eoAdaptorClassName;
    }

    @Override
    public String getCustomInfoPListContent() {
        if (this.eoAdaptorClassName == null || this.eoAdaptorClassName.trim().equals("")) {
            return super.getCustomInfoPListContent();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<key>EOAdaptorClassName</key><string>").append(this.eoAdaptorClassName).append("</string>\n");
        sb.append(super.getCustomInfoPListContent());
        return sb.toString();
    }
}

