/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.objectstyle.woproject.ant.WOTask;

public abstract class ProjectFormat {
    protected WOTask task;

    public ProjectFormat(WOTask task) {
        this.task = task;
    }

    public String getName() {
        return this.task.getName();
    }

    public String getVersion() {
        return this.task.getVersion();
    }

    public String getCFBundleVersion() {
        return this.task.getCFBundleVersion();
    }

    public String getCFBundleShortVersion() {
        return this.task.getCFBundleShortVersion();
    }

    public String getCFBundleID() {
        return this.task.getCFBundleID();
    }

    public String getJavaVersion() {
        return this.task.getJavaVersion();
    }

    public String getJarName() {
        return this.task.getJarName() + ".jar";
    }

    public boolean processTemplates() throws BuildException {
        Iterator it = this.fileIterator();
        boolean returnValue = false;
        try {
            ClassLoader cl = ((Object)((Object)this.task)).getClass().getClassLoader();
            if (cl == null) {
                throw new BuildException("Could not load classloader");
            }
            while (it.hasNext()) {
                File target;
                String targetName = (String)it.next();
                String templName = this.templateForTarget(targetName);
                FilterSetCollection filters = this.filtersForTarget(targetName);
                InputStream template = cl.getResourceAsStream(templName);
                if (!this.copyFile(template, target = new File(targetName), filters)) continue;
                returnValue = true;
            }
        }
        catch (IOException ioex) {
            throw new BuildException("Error doing project formatting.", (Throwable)ioex);
        }
        finally {
            it = null;
        }
        return returnValue;
    }

    public abstract Iterator fileIterator();

    public abstract String templateForTarget(String var1) throws BuildException;

    public abstract FilterSetCollection filtersForTarget(String var1) throws BuildException;

    public boolean copyFile(InputStream src, File destFile, FilterSetCollection filters) throws IOException {
        File parent;
        this.log("destFile.getName(): " + destFile.getName() + " this.getName(): " + this.getName(), 3);
        if (destFile.exists() && destFile.isFile() && destFile.getName().equals(this.getName())) {
            src.close();
            return false;
        }
        if (destFile.exists() && destFile.isFile()) {
            destFile.delete();
        }
        if (!(parent = new File(destFile.getParent())).exists()) {
            parent.mkdirs();
        }
        if (filters != null && filters.hasFilters()) {
            BufferedReader in = new BufferedReader(new InputStreamReader(src));
            BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
            this.log("filters: " + filters, 3);
            String newline = null;
            String line = in.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    out.newLine();
                } else {
                    this.log("line: " + line, 3);
                    newline = filters.replaceTokens(line);
                    this.log("newline: " + newline, 3);
                    out.write(newline);
                    out.newLine();
                }
                line = in.readLine();
            }
            out.close();
            in.close();
        } else {
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = src.read(buffer, 0, buffer.length)) != -1);
            src.close();
            out.close();
        }
        return destFile.getName().equals(this.getName());
    }

    private String libString(Iterator extLibs) {
        String endLine = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("<array>");
        if (this.task.hasClasses()) {
            buf.append(endLine).append("\t\t<string>").append(this.getJarName()).append("</string>");
        }
        if (extLibs != null) {
            while (extLibs.hasNext()) {
                String libFile = (String)extLibs.next();
                buf.append(endLine).append("\t\t<string>");
                buf.append(libFile);
                buf.append("</string>");
            }
        }
        buf.append(endLine).append("\t</array>");
        return buf.toString();
    }

    private String principalClassString() {
        String endLine = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        if (this.task.getPrincipalClass() != null && this.task.getPrincipalClass().length() > 0) {
            buf.append("<key>NSPrincipalClass</key>").append(endLine);
            buf.append("\t<string>").append(this.task.getPrincipalClass()).append("</string>").append(endLine);
        }
        return buf.toString();
    }

    private String getCustomInfoPListContent() {
        String string = this.task.getCustomInfoPListContent();
        if (string != null) {
            return string;
        }
        return "";
    }

    public FilterSetCollection infoFilter(Iterator extLibs) {
        FilterSet filter = new FilterSet();
        filter.addFilter("PRINCIPAL_CLASS", this.principalClassString());
        filter.addFilter("NAME", this.getName());
        filter.addFilter("VERSION", this.getVersion());
        filter.addFilter("JAVA_VERSION", this.getJavaVersion());
        filter.addFilter("JAR_NAME", this.getJarName());
        filter.addFilter("JAR_ARRAY", this.libString(extLibs));
        filter.addFilter("CUSTOM_CONTENT", this.getCustomInfoPListContent());
        filter.addFilter("HAS_COMPONENTS", "<" + this.hasComponents() + "/>");
        filter.addFilter("CFBUNDLE_VERSION", this.getCFBundleVersion());
        filter.addFilter("CFBUNDLE_SHORTVERSION", this.getCFBundleShortVersion());
        filter.addFilter("CFBUNDLE_IDENTIFIER", this.getCFBundleID());
        return new FilterSetCollection(filter);
    }

    private boolean hasComponents() {
        return this.task.getHasComponents();
    }

    public void log(String msg) {
        this.task.log(msg);
    }

    public void log(String msg, int msgLevel) {
        this.task.log(msg, msgLevel);
    }

    public void release() {
        this.task = null;
    }
}

