/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtils {
    public static <T> T genericClone(T object) {
        if (object == null) {
            return null;
        }
        if (Object.class == object.getClass()) {
            return object;
        }
        if (String.class == object.getClass()) {
            return object;
        }
        if (object instanceof Throwable) {
            return object;
        }
        if (StringBuffer.class == object.getClass()) {
            return (T)new StringBuffer(object.toString());
        }
        if (StringBuilder.class == object.getClass()) {
            return (T)new StringBuilder(object.toString());
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof Character) {
            return object;
        }
        if (!(object instanceof Cloneable)) {
            throw new RuntimeException("Failed to clone " + object + " (" + object.getClass().getName() + ").");
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            method.setAccessible(true);
            Object clone = method.invoke(object, null);
            return (T)clone;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clone " + object + ".", e);
        }
    }

    public static <T> T deepClone(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        String classname = object.getClass().getName();
        if ('[' == classname.charAt(0)) {
            if (classname.charAt(1) != '[' && classname.charAt(1) != 'L') {
                switch (classname.charAt(1)) {
                    case 'B': {
                        return (T)((byte[])object).clone();
                    }
                    case 'Z': {
                        return (T)((boolean[])object).clone();
                    }
                    case 'C': {
                        return (T)((char[])object).clone();
                    }
                    case 'S': {
                        return (T)((short[])object).clone();
                    }
                    case 'I': {
                        return (T)((int[])object).clone();
                    }
                    case 'J': {
                        return (T)((long[])object).clone();
                    }
                    case 'F': {
                        return (T)((float[])object).clone();
                    }
                    case 'D': {
                        return (T)((double[])object).clone();
                    }
                }
                Logger.getLogger("com.uwyn.rife.tools").severe("Unknown primitive array class: " + classname);
                return null;
            }
            int dimension_count = 1;
            while (classname.charAt(dimension_count) == '[') {
                ++dimension_count;
            }
            Class<?> baseClass = null;
            if (classname.charAt(dimension_count) != 'L') {
                baseClass = ObjectUtils.getBaseClass(object);
            } else {
                try {
                    baseClass = Class.forName(classname.substring(dimension_count + 1, classname.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger("com.uwyn.rife.tools").severe("Internal error: class definition inconsistency: " + classname);
                    return null;
                }
            }
            int[] dimensions = new int[dimension_count];
            dimensions[0] = Array.getLength(object);
            int i = 1;
            while (i < dimension_count) {
                dimensions[i] = 0;
                ++i;
            }
            Object copy = Array.newInstance(baseClass, dimensions);
            int i2 = 0;
            while (i2 < dimensions[0]) {
                Array.set(copy, i2, ObjectUtils.deepClone(Array.get(object, i2)));
                ++i2;
            }
            return (T)copy;
        }
        if (object instanceof Collection && object instanceof Cloneable) {
            Collection collection = (Collection)object;
            Collection copy = (Collection)ObjectUtils.genericClone(object);
            copy.clear();
            for (Object element : collection) {
                copy.add(ObjectUtils.deepClone(element));
            }
            return (T)copy;
        }
        if (object instanceof Map && object instanceof Cloneable) {
            Map map = (Map)object;
            Map copy = (Map)ObjectUtils.genericClone(object);
            copy.clear();
            Iterator collection_it = map.entrySet().iterator();
            Map.Entry entry = null;
            while (collection_it.hasNext()) {
                entry = collection_it.next();
                copy.put(ObjectUtils.deepClone(entry.getKey()), ObjectUtils.deepClone(entry.getValue()));
            }
            return (T)copy;
        }
        T copy = ObjectUtils.genericClone(object);
        if (copy == null) {
            throw new CloneNotSupportedException(object.getClass().getName());
        }
        return copy;
    }

    public static Class getBaseClass(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        String className = object.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return object.getClass();
        }
        switch (className.charAt(dims)) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    return Class.forName(className.substring(dims + 1, className.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

