/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.kvc;

import org.objectstyle.wolips.eomodeler.core.kvc.IKey;
import org.objectstyle.wolips.eomodeler.core.kvc.Key;
import org.objectstyle.wolips.eomodeler.core.kvc.ResolvedKeyPath;

public class KeyPath
implements IKey {
    private String[] myKeyNames;
    private Key[] myKeys;

    public KeyPath(String _keyPath) {
        this(_keyPath.split("\\."));
    }

    public KeyPath(String[] _keyNames) {
        this.myKeyNames = _keyNames;
    }

    public KeyPath(Key[] _keys) {
        this.myKeys = _keys;
        this.myKeyNames = new String[_keys.length];
        int keyNum = 0;
        while (keyNum < _keys.length) {
            this.myKeyNames[keyNum] = _keys[keyNum].getName();
            ++keyNum;
        }
    }

    public String toKeyPath() {
        StringBuffer sb = new StringBuffer();
        int keyNum = 0;
        while (keyNum < this.myKeyNames.length) {
            sb.append(this.myKeyNames[keyNum]);
            sb.append(".");
            ++keyNum;
        }
        if (this.myKeyNames.length > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public ResolvedKeyPath toResolvedKey(Class _declaringClass) {
        return new ResolvedKeyPath(_declaringClass, this.myKeyNames);
    }

    protected Key[] getKeys() {
        if (this.myKeys == null) {
            Key key = null;
            this.myKeys = new Key[this.myKeyNames.length];
            int keyNum = 0;
            while (keyNum < this.myKeys.length) {
                this.myKeys[keyNum] = key = this.createKey(key, this.myKeyNames[keyNum]);
                ++keyNum;
            }
        }
        return this.myKeys;
    }

    protected Key createKey(Key _previousKey, String _keyName) {
        return new Key(_keyName);
    }

    public Class getType(Object _instance) {
        Class type = null;
        Key[] keys = this.getKeys();
        if (keys.length > 0) {
            type = keys[keys.length - 1].getType(_instance);
        }
        return type;
    }

    public void setValue(Object _instance, Object _value) {
        Key[] keys = this.getKeys();
        Object instance = _instance;
        int keyNum = 0;
        while (instance != null && keyNum < keys.length - 1) {
            Key key = keys[keyNum];
            instance = key.getValue(instance);
            ++keyNum;
        }
        if (instance != null) {
            keys[keys.length - 1].setValue(instance, _value);
        }
    }

    public Object getValue(Object _instance) {
        Key[] keys = this.getKeys();
        Object instance = _instance;
        int keyNum = 0;
        while (instance != null && keyNum < keys.length) {
            Key key = keys[keyNum];
            instance = key.getValue(instance);
            ++keyNum;
        }
        return instance;
    }

    public String toString() {
        return "[KeyPath: " + this.toKeyPath() + "]";
    }

    public static Object getValue(Object _instance, String _keyPath) {
        Object value;
        if (_instance == null) {
            value = null;
        } else {
            ResolvedKeyPath keyPath = new ResolvedKeyPath(_instance.getClass(), _keyPath);
            value = keyPath.getValue(_instance);
        }
        return value;
    }
}

