/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOAggregateQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOAndQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOKeyComparisonQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOKeyValueQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EONamedQualifierVariable;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EONotQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOOrQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifierBinding;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifierParser;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifierVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOQualifierFactory {
    private static List<SelectorMap> _selectorMaps = new LinkedList<SelectorMap>();

    static {
        _selectorMaps.add(new SelectorMap("isEqualTo:", "="));
        _selectorMaps.add(new SelectorMap("isEqualTo", "="));
        _selectorMaps.add(new SelectorMap("isNotEqualTo:", "<>"));
        _selectorMaps.add(new SelectorMap("isNotEqualTo", "<>"));
        _selectorMaps.add(new SelectorMap("isLessThan:", "<"));
        _selectorMaps.add(new SelectorMap("isLessThan", "<"));
        _selectorMaps.add(new SelectorMap("isGreaterThan:", ">"));
        _selectorMaps.add(new SelectorMap("isGreaterThan", ">"));
        _selectorMaps.add(new SelectorMap("isLessThanOrEqualTo:", "<="));
        _selectorMaps.add(new SelectorMap("isLessThanOrEqualTo", "<="));
        _selectorMaps.add(new SelectorMap("isGreaterThanOrEqualTo:", ">="));
        _selectorMaps.add(new SelectorMap("isGreaterThanOrEqualTo", ">="));
        _selectorMaps.add(new SelectorMap("doesContain:", "contains"));
        _selectorMaps.add(new SelectorMap("doesContain", "contains"));
        _selectorMaps.add(new SelectorMap("isLike:", "like"));
        _selectorMaps.add(new SelectorMap("isLike", "like"));
        _selectorMaps.add(new SelectorMap("isCaseInsensitiveLike:", "caseInsensitiveLike"));
        _selectorMaps.add(new SelectorMap("isCaseInsensitiveLike", "caseInsensitiveLike"));
        _selectorMaps.add(new SelectorMap("likeIgnoreCase", "caseInsensitiveLike"));
        _selectorMaps.add(new SelectorMap("likeIgnoreCase:", "caseInsensitiveLike"));
    }

    public static EOQualifier fromString(String qualifierString) {
        try {
            EOQualifier qualifier = new EOQualifierParser().parseQualifier(qualifierString);
            return qualifier;
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse qualfier.", e);
        }
    }

    public static String toString(EOQualifier qualifier) {
        String qualifierString = qualifier == null ? null : qualifier.toString();
        return qualifierString;
    }

    protected static String operatorNameForMethodNamed(String methodName) {
        for (SelectorMap selectorMap : _selectorMaps) {
            if (!selectorMap.getMethodName().equalsIgnoreCase(methodName)) continue;
            return selectorMap.getOperatorName();
        }
        return methodName;
    }

    protected static String methodNameForOperatorNamed(String operatorName) {
        for (SelectorMap selectorMap : _selectorMaps) {
            if (!selectorMap.getOperatorName().equalsIgnoreCase(operatorName)) continue;
            return selectorMap.getMethodName();
        }
        return operatorName;
    }

    public static EOQualifier createQualifierFromQualifierMap(EOModelMap qualifierMap) {
        EOQualifier qualifier = null;
        if (qualifierMap != null) {
            String className = qualifierMap.getString("class", true);
            if ("EOAndQualifier".equals(className) || "com.webobjects.eocontrol.EOAndQualifier".equals(className)) {
                qualifier = new EOAndQualifier(EOQualifierFactory.createQualifiersFromQualifierMaps(qualifierMap.getList("qualifiers")));
            } else if ("EOOrQualifier".equals(className) || "com.webobjects.eocontrol.EOOrQualifier".equals(className)) {
                qualifier = new EOOrQualifier(EOQualifierFactory.createQualifiersFromQualifierMaps(qualifierMap.getList("qualifiers")));
            } else if ("EONotQualifier".equals(className) || "com.webobjects.eocontrol.EONotQualifier".equals(className)) {
                qualifier = new EONotQualifier(EOQualifierFactory.createQualifierFromQualifierMap(new EOModelMap(qualifierMap.getMap("qualifier"))));
            } else if ("EOKeyValueQualifier".equals(className) || "com.webobjects.eocontrol.EOKeyValueQualifier".equals(className)) {
                String key = qualifierMap.getString("key", true);
                Object value = EOQualifierFactory.createValue(qualifierMap.get("value"));
                String selectorName = EOQualifierFactory.operatorNameForMethodNamed(qualifierMap.getString("selectorName", true));
                qualifier = EOQualifierFactory.createKeyValueExpression(key, selectorName, value);
            } else if ("EOKeyComparisonQualifier".equals(className) || "com.webobjects.eocontrol.EOKeyComparisonQualifier".equals(className)) {
                String leftKey = qualifierMap.getString("leftKey", true);
                String rightKey = qualifierMap.getString("rightKey", true);
                String selectorName = EOQualifierFactory.operatorNameForMethodNamed(qualifierMap.getString("selectorName", true));
                qualifier = EOQualifierFactory.createKeyComparisonExpression(leftKey, selectorName, rightKey);
            } else {
                throw new IllegalArgumentException("Unknown qualifier className '" + className + "'.");
            }
        }
        return qualifier;
    }

    private static EOQualifier createKeyValueExpression(String key, String selectorName, Object value) {
        EOKeyValueQualifier qualifier = new EOKeyValueQualifier(key, selectorName, value);
        return qualifier;
    }

    private static EOQualifier createKeyComparisonExpression(String leftKey, String selectorName, String rightKey) {
        EOKeyComparisonQualifier qualifier = new EOKeyComparisonQualifier(leftKey, selectorName, rightKey);
        return qualifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object createValue(Object _rawValue) {
        if (!(_rawValue instanceof Map)) return _rawValue;
        EOModelMap valueMap = new EOModelMap((Map)_rawValue);
        String valueClass = valueMap.getString("class", true);
        if ("EONull".equals(valueClass)) return null;
        if ("com.webobjects.eocontrol.EONull".equals(valueClass)) {
            return null;
        }
        if ("EOQualifierVariable".equals(valueClass) || "com.webobjects.eocontrol.EOQualifierVariable".equals(valueClass)) {
            String variableKey = valueMap.getString("_key", true);
            if (!variableKey.startsWith("$")) return new EONamedQualifierVariable(variableKey);
            variableKey = variableKey.substring(1);
            return new EONamedQualifierVariable(variableKey);
        }
        if (!"NSNumber".equals(valueClass)) throw new IllegalArgumentException("Unknown EOKeyValueQualifier value class " + valueClass);
        Object value = valueMap.get("value");
        if (!(value instanceof String)) return value;
        String valueStr = (String)value;
        if (valueStr.indexOf(46) != -1) return Float.valueOf(Float.parseFloat(valueStr));
        value = Integer.parseInt(valueStr);
        if (String.valueOf(value).equals(valueStr)) return value;
        return Long.parseLong(valueStr);
    }

    private static Collection<EOQualifier> createQualifiersFromQualifierMaps(Collection<Map<Object, Object>> _qualifiers) {
        LinkedList<EOQualifier> qualifiers = new LinkedList<EOQualifier>();
        if (_qualifiers != null) {
            for (Map<Object, Object> qualifierMap : _qualifiers) {
                EOQualifier exp = EOQualifierFactory.createQualifierFromQualifierMap(new EOModelMap(qualifierMap));
                qualifiers.add(exp);
            }
        }
        return qualifiers;
    }

    private static Object createQualifierValue(Object value) {
        Object qualifierValue;
        if (value == null) {
            EOModelMap map = new EOModelMap();
            map.setString("class", "EONull", false);
            qualifierValue = map;
        } else if (value instanceof EONamedQualifierVariable) {
            EOModelMap map = new EOModelMap();
            String name = ((EONamedQualifierVariable)value).getName();
            map.setString("_key", name, true);
            map.setString("class", "EOQualifierVariable", false);
            qualifierValue = map;
        } else if (value instanceof EOQualifierVariable) {
            EOModelMap map = new EOModelMap();
            String name = ((EOQualifierVariable)value).getName();
            map.setString("_key", name, true);
            map.setString("class", "EOQualifierVariable", false);
            qualifierValue = map;
        } else if (value instanceof Number) {
            EOModelMap map = new EOModelMap();
            map.setString("class", "NSNumber", false);
            map.put("value", value);
            qualifierValue = map;
        } else if (value instanceof Boolean) {
            EOModelMap map = new EOModelMap();
            map.setString("class", "NSNumber", false);
            map.put("value", value);
            qualifierValue = map;
        } else if (value instanceof String) {
            qualifierValue = value;
        } else {
            throw new IllegalArgumentException("Unknown qualifier value type: " + value + " (type = " + value.getClass().getName() + ")");
        }
        return qualifierValue;
    }

    private static EOModelMap createQualifierMapFromKeyComparisonQualifier(EOKeyComparisonQualifier qualifier) {
        String leftKey = qualifier.getLeftKey();
        String rightKey = qualifier.getRightKey();
        EOModelMap map = new EOModelMap();
        map.setString("class", "EOKeyComparisonQualifier", false);
        map.setString("leftKey", leftKey, false);
        map.setString("rightKey", rightKey, false);
        EOQualifier.Comparison comparison = qualifier.getComparison();
        String selectorName = comparison == null ? null : EOQualifierFactory.methodNameForOperatorNamed(comparison.getName());
        map.setString("selectorName", selectorName, false);
        return map;
    }

    private static EOModelMap createQualifierMapFromKeyValueQualifier(EOKeyValueQualifier qualifier) {
        String key = qualifier.getKey();
        Object value = qualifier.getValue();
        EOModelMap map = new EOModelMap();
        map.setString("class", "EOKeyValueQualifier", false);
        Object processedValue = EOQualifierFactory.createQualifierValue(value);
        map.setString("key", key, false);
        EOQualifier.Comparison comparison = qualifier.getComparison();
        String selectorName = comparison == null ? null : EOQualifierFactory.methodNameForOperatorNamed(comparison.getName());
        map.setString("selectorName", selectorName, false);
        map.put("value", processedValue);
        return map;
    }

    private static List<EOModelMap> createQualifierMapsFromAggregateQualifier(EOAggregateQualifier aggregateQualifier) {
        LinkedList<EOModelMap> qualifierMaps = new LinkedList<EOModelMap>();
        for (EOQualifier qualifier : aggregateQualifier.getQualifiers()) {
            qualifierMaps.add(EOQualifierFactory.createQualifierMapFromQualifier(qualifier));
        }
        return qualifierMaps;
    }

    public static EOModelMap createQualifierMapFromQualifier(EOQualifier qualifier) {
        EOModelMap map;
        if (qualifier instanceof EOKeyValueQualifier) {
            map = EOQualifierFactory.createQualifierMapFromKeyValueQualifier((EOKeyValueQualifier)qualifier);
        } else if (qualifier instanceof EOKeyComparisonQualifier) {
            map = EOQualifierFactory.createQualifierMapFromKeyComparisonQualifier((EOKeyComparisonQualifier)qualifier);
        } else if (qualifier instanceof EOAndQualifier) {
            map = new EOModelMap();
            map.setString("class", "EOAndQualifier", false);
            map.setList("qualifiers", EOQualifierFactory.createQualifierMapsFromAggregateQualifier((EOAndQualifier)qualifier), true);
        } else if (qualifier instanceof EOOrQualifier) {
            map = new EOModelMap();
            map.setString("class", "EOOrQualifier", false);
            map.setList("qualifiers", EOQualifierFactory.createQualifierMapsFromAggregateQualifier((EOOrQualifier)qualifier), true);
        } else if (qualifier instanceof EONotQualifier) {
            map = new EOModelMap();
            map.setString("class", "EONotQualifier", false);
            map.setMap("qualifier", EOQualifierFactory.createQualifierMapFromQualifier(((EONotQualifier)qualifier).getQualifier()), true);
        } else {
            throw new IllegalArgumentException("Unknown qualifier " + qualifier + ".");
        }
        return map;
    }

    public static Set<String> getQualifierKeysFromQualifierString(String qualifierString) {
        EOQualifier qualifier = EOQualifierFactory.fromString(qualifierString);
        return EOQualifierFactory.getQualifierKeysFromQualifier(qualifier);
    }

    public static Set<String> getQualifierKeysFromQualifier(EOQualifier expression) {
        HashSet<String> keys = new HashSet<String>();
        try {
            EOQualifierFactory.fillInQualifierKeysFromQualifier(expression, keys);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return keys;
    }

    public static void fillInQualifierKeysFromQualifier(EOQualifier qualifier, Set<String> keys) {
        if (qualifier instanceof EOKeyValueQualifier) {
            String key = ((EOKeyValueQualifier)qualifier).getKey();
            keys.add(key);
        } else if (qualifier instanceof EOKeyComparisonQualifier) {
            String leftKey = ((EOKeyComparisonQualifier)qualifier).getLeftKey();
            keys.add(leftKey);
            String rightKey = ((EOKeyComparisonQualifier)qualifier).getRightKey();
            keys.add(rightKey);
        } else if (qualifier instanceof EOAggregateQualifier) {
            for (EOQualifier childQualifier : ((EOAggregateQualifier)qualifier).getQualifiers()) {
                EOQualifierFactory.fillInQualifierKeysFromQualifier(childQualifier, keys);
            }
        } else if (qualifier instanceof EONotQualifier) {
            EOQualifierFactory.fillInQualifierKeysFromQualifier(((EONotQualifier)qualifier).getQualifier(), keys);
        } else {
            throw new IllegalArgumentException("Unknown expression " + qualifier + ".");
        }
    }

    public static List<EOQualifierBinding> getQualifierBindingsFromQualifierString(EOEntity entity, String qualifierString) {
        EOQualifier qualifier = EOQualifierFactory.fromString(qualifierString);
        return EOQualifierFactory.getQualifierBindingsFromQualifier(entity, qualifier);
    }

    public static List<EOQualifierBinding> getQualifierBindingsFromQualifier(EOEntity entity, EOQualifier qualifier) {
        LinkedList<EOQualifierBinding> bindings = new LinkedList<EOQualifierBinding>();
        try {
            if (qualifier != null) {
                EOQualifierFactory.fillInQualifierBindingsFromQualifier(entity, qualifier, bindings);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return bindings;
    }

    public static void fillInQualifierBindingsFromQualifier(EOEntity entity, EOQualifier qualifier, List<EOQualifierBinding> bindings) {
        if (qualifier instanceof EOKeyValueQualifier) {
            String key = ((EOKeyValueQualifier)qualifier).getKey();
            Object value = ((EOKeyValueQualifier)qualifier).getValue();
            if (value instanceof EONamedQualifierVariable) {
                String bindingName = ((EONamedQualifierVariable)value).getName();
                EOQualifierBinding binding = new EOQualifierBinding(entity, bindingName, key);
                bindings.add(binding);
            }
        } else if (!(qualifier instanceof EOKeyComparisonQualifier)) {
            if (qualifier instanceof EOAggregateQualifier) {
                for (EOQualifier aggregatedQualifier : ((EOAggregateQualifier)qualifier).getQualifiers()) {
                    EOQualifierFactory.fillInQualifierBindingsFromQualifier(entity, aggregatedQualifier, bindings);
                }
            } else if (qualifier instanceof EONotQualifier) {
                EOQualifierFactory.fillInQualifierBindingsFromQualifier(entity, ((EONotQualifier)qualifier).getQualifier(), bindings);
            } else {
                throw new IllegalArgumentException("Unknown qualifier '" + qualifier + "'.");
            }
        }
    }

    private static class SelectorMap {
        private String _methodName;
        private String _operatorName;

        public SelectorMap(String methodName, String operatorName) {
            this._methodName = methodName;
            this._operatorName = operatorName;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public String getOperatorName() {
            return this._operatorName;
        }
    }
}

