/*
 * Decompiled with CFR 0.152.
 */
package er.wojrebel;

import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOKeyValueCoding;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSValidation;
import com.webobjects.foundation._NSUtilities;
import er.wojrebel.D2WAccessor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;

public class WOJRebelEOModelReloadHandler {
    private static final String EO_ENTITY_CACHE_RESET = "EOEntityCacheReset";
    private static final Class<?>[] NotificationClassArray = new Class[]{NSNotification.class};
    private static boolean initialized = false;
    private static final WOJRebelEOModelReloadHandler instance = new WOJRebelEOModelReloadHandler();
    private static final Logger log = LoggerFactory.getInstance();
    private final Map<EOModel, Long> modelCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<EOObjectStoreCoordinator, EOModelGroup> oscCache = new WeakHashMap<EOObjectStoreCoordinator, EOModelGroup>();
    private Field _ERXEntityCache;
    private Method _ERXEntityClassDescriptionCacheReset;
    private Object _ERXEntityClassDescriptionFactory;

    public static WOJRebelEOModelReloadHandler getInstance() {
        return instance;
    }

    public synchronized void updateLoadedModels(NSNotification n) {
        boolean reloaded = false;
        ArrayList<EOModel> modelList = new ArrayList<EOModel>(this.modelCache.keySet());
        for (EOModel model : modelList) {
            reloaded |= this.shouldUpdateModel(model);
        }
        if (reloaded) {
            this.flushCaches();
            for (EOModel model : modelList) {
                this.updateModel(model);
            }
        }
    }

    private boolean updateModel(EOModel model) {
        if (this.shouldUpdateModel(model)) {
            this.reloadModel(model);
            return true;
        }
        return false;
    }

    private boolean shouldUpdateModel(EOModel model) {
        return this.modelCache.containsKey(model) && this.lastModified(model) > this.modelCache.get(model);
    }

    private long lastModified(EOModel model) {
        URL url = model.pathURL();
        File modeld = new File(url.getPath());
        long lastmod = modeld.lastModified();
        for (File file : modeld.listFiles()) {
            if (file.lastModified() <= lastmod) continue;
            lastmod = file.lastModified();
        }
        return lastmod;
    }

    private void reloadModel(EOModel model) {
        log.echo("JRebel: reloading EOModel " + model.name() + " (" + model.hashCode() + ")");
        EOModel newModel = new EOModel(model.pathURL());
        EOModelGroup modelGroup = model.modelGroup();
        modelGroup.removeModel(model);
        modelGroup.addModel(newModel);
        for (Map.Entry<EOObjectStoreCoordinator, EOModelGroup> entry : this.oscCache.entrySet()) {
            if (modelGroup != entry.getValue()) continue;
            EOObjectStoreCoordinator osc = entry.getKey();
            for (Object obj : osc.cooperatingObjectStores()) {
                EOCooperatingObjectStore store = (EOCooperatingObjectStore)obj;
                osc.removeCooperatingObjectStore(store);
            }
            osc.invalidateAllObjects();
        }
    }

    public void modelAdded(NSNotification n) {
        if (this.modelCache.containsKey(n.object())) {
            return;
        }
        EOModel model = (EOModel)n.object();
        if (model.pathURL() != null) {
            this.modelCache.put(model, this.lastModified(model));
        }
    }

    public void modelRemoved(NSNotification n) {
        this.modelCache.remove(n.object());
    }

    public void storeCoordinatorAdded(NSNotification n) {
        EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)n.object();
        this.oscCache.put(osc, EOModelGroup.modelGroupForObjectStoreCoordinator((EOObjectStoreCoordinator)osc));
    }

    public void storeCoordinatorRemoved(NSNotification n) {
        this.oscCache.remove(n.object());
    }

    public void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("modelAdded", (Class[])NotificationClassArray), "EOModelAddedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("modelRemoved", (Class[])NotificationClassArray), "EOModelInvalidatedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("storeCoordinatorAdded", (Class[])NotificationClassArray), "EOCooperatingObjectStoreWasAddedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("storeCoordinatorRemoved", (Class[])NotificationClassArray), "EOCooperatingObjectStoreWasRemovedNotification", null);
        Class ERXClass = _NSUtilities.classWithName((String)"er.extensions.foundation.ERXUtilities");
        if (ERXClass != null) {
            try {
                this._ERXEntityCache = ERXClass.getDeclaredField("_entityNameEntityCache");
                this._ERXEntityCache.setAccessible(true);
                ERXClass = _NSUtilities.classWithName((String)"er.extensions.eof.ERXEntityClassDescription");
                Method factory = ERXClass.getDeclaredMethod("factory", new Class[0]);
                this._ERXEntityClassDescriptionFactory = factory.invoke(null, new Object[0]);
                ERXClass = _NSUtilities.classWithName((String)"er.extensions.eof.ERXEntityClassDescription$Factory");
                this._ERXEntityClassDescriptionCacheReset = ERXClass.getDeclaredMethod("reset", new Class[0]);
                NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("resetWonderEntityCache", (Class[])NotificationClassArray), EO_ENTITY_CACHE_RESET, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void resetWonderEntityCache(NSNotification notification) {
        try {
            this._ERXEntityCache.set(null, null);
            this._ERXEntityClassDescriptionCacheReset.invoke(this._ERXEntityClassDescriptionFactory, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void flushCaches() {
        log.echo("JRebel: flushing EOModel caches");
        EOKeyValueCoding.DefaultImplementation._flushCaches();
        EOClassDescription.invalidateClassDescriptionCache();
        D2WAccessor.flushCaches();
        NSValidation.DefaultImplementation._flushCaches();
        NSNotificationCenter.defaultCenter().postNotification(EO_ENTITY_CACHE_RESET, null);
    }
}

