/* ====================================================================
 * 
 * The ObjectStyle Group Software License, Version 1.0 
 *
 * Copyright (c) 2004 -2005 The ObjectStyle Group 
 * and individual authors of the software.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        ObjectStyle Group (http://objectstyle.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "ObjectStyle Group" and "Cayenne" 
 *    must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact andrus@objectstyle.org.
 *
 * 5. Products derived from this software may not be called "ObjectStyle"
 *    nor may "ObjectStyle" appear in their names without prior written
 *    permission of the ObjectStyle Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE OBJECTSTYLE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the ObjectStyle Group.  For more
 * information on the ObjectStyle Group, please see
 * <http://objectstyle.org/>.
 *
 */

package org.objectstyle.wolips.editors.patterset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.objectstyle.wolips.core.resources.pattern.PatternsetReader;
import org.objectstyle.wolips.core.resources.pattern.PatternsetWriter;
import org.objectstyle.wolips.editors.EditorsPlugin;
import org.objectstyle.wolips.ui.actions.TouchAllFilesOperation;

/**
 * @author ulrich
 * 
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PatternsetEditor extends FormEditor {
	private ArrayList patternList;

	private boolean isDirty = false;

	/*
	 * private PatternsetListener pattersetListener;
	 * 
	 * private class PatternsetListener implements IResourceChangeListener {
	 * 
	 * public void resourceChanged(IResourceChangeEvent event) { try {
	 * event.getDelta().accept(new IResourceDeltaVisitor() { private boolean
	 * done = false;
	 * 
	 * public boolean visit(IResourceDelta delta) throws CoreException { if
	 * (this.done) { return false; } if (delta.getResource() ==
	 * PatternsetEditor.this .getInputFile()) {
	 * PatternsetEditor.this.loadPatternList(); this.done = true; } return true; }
	 * }); } catch (CoreException e) {
	 * UIPlugin.getDefault().getPluginLogger().log(e); } }
	 *  }
	 */
	/**
	 * 
	 */
	public PatternsetEditor() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.FormEditor#close(boolean)
	 */
	public void close(boolean save) {
		super.close(save);
		/*
		 * if (this.pattersetListener == null) { this.pattersetListener = new
		 * PatternsetListener();
		 * ResourcesPlugin.getWorkspace().removeResourceChangeListener(
		 * this.pattersetListener); }
		 */
	}

	IFile getInputFile() {
		IEditorInput editorInput = getEditorInput();
		return ((IFileEditorInput) editorInput).getFile();
	}

	void loadPatternList() {
		PatternsetReader patternsetReader = new PatternsetReader(this.getInputFile());
		String[] pattern = patternsetReader.getPattern();
		this.patternList = new ArrayList();
		for (int i = 0; i < pattern.length; i++) {
			this.patternList.add(pattern[i]);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.FormEditor#addPages()
	 */
	protected void addPages() {
		/*
		 * if (this.pattersetListener == null) { this.pattersetListener = new
		 * PatternsetListener();
		 * ResourcesPlugin.getWorkspace().addResourceChangeListener(
		 * this.pattersetListener); }
		 */
		this.loadPatternList();
		try {
			addPage(new PatternsetPage(this, this.patternList));
		} catch (PartInitException e) {
			EditorsPlugin.getDefault().log(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		IEditorInput editorInput = getEditorInput();
		IFile inputFile = ((IFileEditorInput) editorInput).getFile();
		String[] pattern = (String[]) this.patternList.toArray(new String[this.patternList.size()]);
		PatternsetWriter.create(inputFile, pattern);
		this.setDirty(false);
		TouchAllFilesOperation touchAllFilesOperation = new TouchAllFilesOperation(inputFile.getProject());
		try {
			touchAllFilesOperation.run(new NullProgressMonitor());
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#doSaveAs()
	 */
	public void doSaveAs() {
		return;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * @return Returns the isDirty.
	 */
	public boolean isDirty() {
		return this.isDirty;
	}

	/**
	 * @param isDirty
	 *            The isDirty to set.
	 */
	public void setDirty(boolean isDirty) {
		this.isDirty = isDirty;
		this.firePropertyChange(IEditorPart.PROP_DIRTY);
	}
}