/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtilities {
    public static boolean deleteRecursively(File file) {
        File[] childFiles;
        if (file.isDirectory() && (childFiles = file.listFiles()) != null) {
            for (File childFile : childFiles) {
                FileUtilities.deleteRecursively(childFile);
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileToFile(File srcFile, File dstFile, boolean deleteOriginals, boolean forceDelete) throws FileNotFoundException, IOException {
        if (srcFile.exists() && srcFile.isFile()) {
            boolean copied = false;
            if (deleteOriginals && (!forceDelete || srcFile.canWrite())) {
                copied = srcFile.renameTo(dstFile);
            }
            if (!copied) {
                Throwable thrownException;
                block38: {
                    thrownException = null;
                    File parent = dstFile.getParentFile();
                    if (!parent.exists() && !parent.mkdirs()) {
                        throw new IOException("Failed to create the directory " + parent + ".");
                    }
                    FileInputStream in = new FileInputStream(srcFile);
                    try {
                        FileChannel srcChannel;
                        block37: {
                            srcChannel = in.getChannel();
                            try (FileOutputStream out = new FileOutputStream(dstFile);){
                                FileChannel dstChannel = out.getChannel();
                                try {
                                    dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                                }
                                catch (Throwable t) {
                                    try {
                                        thrownException = t;
                                        break block37;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        dstChannel.close();
                                    }
                                }
                                dstChannel.close();
                            }
                            catch (Throwable t) {
                                try {
                                    if (thrownException == null) {
                                        thrownException = t;
                                    }
                                    break block38;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    srcChannel.close();
                                }
                            }
                        }
                        srcChannel.close();
                    }
                    catch (Throwable t) {
                        if (thrownException == null) {
                            thrownException = t;
                        }
                    }
                    finally {
                        block39: {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                if (thrownException != null) break block39;
                                thrownException = e;
                            }
                        }
                    }
                }
                if (deleteOriginals && (srcFile.canWrite() || forceDelete) && !srcFile.delete()) {
                    throw new IOException("Failed to delete " + srcFile + ".");
                }
                if (thrownException != null) {
                    if (thrownException instanceof IOException) {
                        throw (IOException)thrownException;
                    }
                    if (thrownException instanceof Error) {
                        throw (Error)thrownException;
                    }
                    throw (RuntimeException)thrownException;
                }
            }
        }
    }
}

