/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class StringUtils {
    public static String toShortPrettyClassName(String name) {
        if (name == null) {
            return null;
        }
        int dotIndex = name.lastIndexOf(46);
        String shortName = dotIndex == -1 ? name : name.substring(dotIndex + 1);
        if (shortName.startsWith("EO")) {
            shortName = shortName.substring(2);
        }
        StringBuffer nameBuffer = new StringBuffer(shortName);
        for (int i = 0; i < nameBuffer.length(); ++i) {
            char ch = nameBuffer.charAt(i);
            if (!Character.isUpperCase(ch) || i == 0) continue;
            nameBuffer.insert(i, ' ');
            ++i;
        }
        return nameBuffer.toString();
    }

    public static int firstLetterIndex(String _name) {
        int letterIndex = -1;
        if (_name != null) {
            int length = _name.length();
            boolean found = false;
            for (int index = 0; !found && index < length; ++index) {
                char ch = _name.charAt(index);
                if (Character.isLetter(ch)) {
                    letterIndex = index;
                    found = true;
                    continue;
                }
                if (ch == '_') continue;
                found = true;
            }
        }
        return letterIndex;
    }

    public static boolean isUppercaseFirstLetter(String _name) {
        int firstLetterIndex = StringUtils.firstLetterIndex(_name);
        return firstLetterIndex != -1 && Character.isUpperCase(_name.charAt(firstLetterIndex));
    }

    public static boolean isLowercaseFirstLetter(String _name) {
        int firstLetterIndex = StringUtils.firstLetterIndex(_name);
        return firstLetterIndex != -1 && Character.isLowerCase(_name.charAt(firstLetterIndex));
    }

    public static String toLowercaseFirstLetter(String value) {
        int length;
        String capital = null;
        if (value != null && (length = value.length()) > 0) {
            StringBuffer buffer = new StringBuffer(value);
            for (int i = 0; i < length; ++i) {
                char ch = value.charAt(i);
                if (i != 0 && i != length - 1 && (i >= length - 1 || !Character.isUpperCase(value.charAt(i + 1)))) break;
                buffer.setCharAt(i, Character.toLowerCase(ch));
            }
            capital = buffer.toString();
        }
        return capital != null ? capital : value;
    }

    public static String toUppercaseFirstLetter(String _name) {
        String name;
        int firstLetterIndex = StringUtils.firstLetterIndex(_name);
        if (firstLetterIndex == -1) {
            name = _name;
        } else {
            StringBuffer sb = new StringBuffer();
            if (firstLetterIndex > 0) {
                sb.append(_name.substring(0, firstLetterIndex));
            }
            sb.append(Character.toUpperCase(_name.charAt(firstLetterIndex)));
            sb.append(_name.substring(firstLetterIndex + 1));
            name = sb.toString();
        }
        return name;
    }

    public static boolean isSelectorNameEqual(String _expectedName, String _possibleName) {
        return _expectedName.equals(_possibleName) || (_expectedName + ":").equals(_possibleName);
    }

    public static String camelCaseToUnderscore(String camelString) {
        return StringUtils.camelCaseToUnderscore(camelString, true);
    }

    public static String camelCaseToUnderscore(String camelString, boolean lowercase) {
        StringBuffer underscore = new StringBuffer();
        boolean lastCharacterWasWordBreak = false;
        boolean lastCharacterWasCapital = false;
        int length = camelString.length();
        for (int i = 0; i < length; ++i) {
            char ch = camelString.charAt(i);
            if (Character.isUpperCase(ch)) {
                boolean nextCharacterIsCapital;
                boolean isLastCharacter = i == length - 1;
                boolean bl = nextCharacterIsCapital = !isLastCharacter && Character.isUpperCase(camelString.charAt(i + 1));
                if (i > 0 && (!lastCharacterWasWordBreak && !lastCharacterWasCapital || !nextCharacterIsCapital && !isLastCharacter)) {
                    underscore.append("_");
                    lastCharacterWasWordBreak = true;
                } else {
                    lastCharacterWasWordBreak = false;
                }
                lastCharacterWasCapital = true;
            } else if (ch == '_') {
                lastCharacterWasWordBreak = true;
                lastCharacterWasCapital = false;
            } else {
                lastCharacterWasWordBreak = false;
                lastCharacterWasCapital = false;
            }
            if (lowercase) {
                underscore.append(Character.toLowerCase(ch));
                continue;
            }
            underscore.append(ch);
        }
        return underscore.toString();
    }

    public static String toPlural(String _str) {
        String plural;
        if (_str != null && _str.length() > 0) {
            char ch = _str.charAt(_str.length() - 1);
            StringBuffer pluralBuffer = new StringBuffer(_str);
            if (ch == 's' || ch == 'x') {
                pluralBuffer.append("es");
            } else if (ch == 'y') {
                pluralBuffer.setLength(pluralBuffer.length() - 1);
                pluralBuffer.append("ies");
            } else {
                pluralBuffer.append("s");
            }
            plural = pluralBuffer.toString();
        } else {
            plural = _str;
        }
        return plural;
    }

    public static boolean isKeyPath(String str) {
        return str != null && str.matches("^[^.][a-zA-Z0-9_.]+$");
    }

    public static String getErrorMessage(Throwable _t) {
        return StringUtils.getErrorMessage(null, _t);
    }

    public static String getErrorMessage(String initialMessage, Throwable _t) {
        StringBuffer messageBuffer = new StringBuffer();
        if (initialMessage != null) {
            messageBuffer.append(initialMessage);
            if (_t != null) {
                messageBuffer.append(" ");
            }
        }
        Throwable t = _t;
        while (t != null) {
            Throwable cause;
            String message = t.getMessage();
            if (message == null && !(t instanceof InvocationTargetException)) {
                String name = t.getClass().getName();
                int lastDotIndex = name.lastIndexOf(46);
                message = name = name.substring(lastDotIndex + 1);
            }
            if (message != null) {
                message = message.trim();
                messageBuffer.append(message);
                if (!message.endsWith(".")) {
                    messageBuffer.append(".  ");
                } else if (!message.endsWith("  ")) {
                    messageBuffer.append("  ");
                }
            }
            if (t == (cause = t.getCause())) {
                t = null;
                continue;
            }
            t = cause;
        }
        return messageBuffer.toString();
    }

    public static String findUnusedName(String newName, Object obj, String getMethodName) {
        try {
            String safeNewName = newName;
            if (safeNewName == null) {
                safeNewName = "MISSING";
            }
            Method getMethod = obj.getClass().getMethod(getMethodName, String.class);
            boolean unusedNameFound = getMethod.invoke(obj, safeNewName) == null;
            Object unusedName = safeNewName;
            if (!unusedNameFound) {
                int cutoffLength;
                for (cutoffLength = safeNewName.length(); cutoffLength > 0 && Character.isDigit(safeNewName.charAt(cutoffLength - 1)); --cutoffLength) {
                }
                String newWithoutTrailingNumber = safeNewName.substring(0, cutoffLength);
                unusedNameFound = getMethod.invoke(obj, newWithoutTrailingNumber) == null;
                unusedName = newWithoutTrailingNumber;
                int dupeNameNum = 1;
                while (!unusedNameFound) {
                    unusedName = newWithoutTrailingNumber + dupeNameNum;
                    Object existingObject = getMethod.invoke(obj, unusedName);
                    unusedNameFound = existingObject == null;
                    ++dupeNameNum;
                }
            }
            return unusedName;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to find unused name for '" + newName + "' with method '" + getMethodName + "'.", t);
        }
    }
}

