/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.types.project;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.objectstyle.wolips.baseforplugins.util.WOLipsNatureUtils;
import org.objectstyle.wolips.core.resources.internal.build.Nature;
import org.objectstyle.wolips.core.resources.internal.types.AbstractResourceAdapterFactory;
import org.objectstyle.wolips.core.resources.internal.types.project.ProjectPatternsets;
import org.objectstyle.wolips.core.resources.types.IResourceType;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public class ProjectAdapterFactory
extends AbstractResourceAdapterFactory {
    private static Map<Object, ProjectPatternsets> _projectPatternSets = new WeakHashMap<Object, ProjectPatternsets>();
    private Class[] adapterList = new Class[]{ProjectAdapter.class};

    public Class[] getAdapterList() {
        return this.adapterList;
    }

    @Override
    public boolean isSupported(Object adaptableObject, Class adapterType) {
        if (!(adaptableObject instanceof IProject)) {
            return false;
        }
        if (adapterType == ProjectAdapter.class) {
            return true;
        }
        return adapterType == IProjectPatternsets.class;
    }

    @Override
    public IResourceType createAdapter(Object adaptableObject, Class adapterType) {
        IProject project = (IProject)adaptableObject;
        Nature nature = (Nature)WOLipsNatureUtils.getNature((IProject)project);
        if (nature == null) {
            return null;
        }
        if (adapterType == ProjectAdapter.class) {
            return new ProjectAdapter(project, nature.isFramework());
        }
        if (adapterType == IProjectPatternsets.class) {
            ProjectPatternsets projectPatternSets = _projectPatternSets.get(adaptableObject);
            if (projectPatternSets == null) {
                projectPatternSets = new ProjectPatternsets(project);
                _projectPatternSets.put(adaptableObject, projectPatternSets);
            }
            return projectPatternSets;
        }
        return null;
    }
}

