/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.plist;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;

public class PropertyListPath {
    private ParserDataStructureFactory _factory;
    private PropertyListPath _parent;
    private int _index;
    private Object _object;

    public PropertyListPath(Object object, ParserDataStructureFactory factory) {
        this(null, 0, object, factory);
    }

    public PropertyListPath(PropertyListPath parent, int index, Object object, ParserDataStructureFactory factory) {
        this._parent = parent;
        this._index = index;
        this._object = object;
        this._factory = factory;
    }

    public int getIndex() {
        return this._index;
    }

    public int hashCode() {
        return this.getKeyPath().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PropertyListPath && this.getKeyPath().equals(((PropertyListPath)obj).getKeyPath());
    }

    public int getIndexOf(PropertyListPath path) {
        return this.getChildren().indexOf(path);
    }

    public PropertyListPath getChildAtIndex(int index) {
        return this.getChildren().get(index);
    }

    public PropertyListPath getChildForKey(Object key) {
        for (PropertyListPath child : this.getChildren()) {
            if (key != child.getKey() && !key.equals(child.getKey())) continue;
            return child;
        }
        return null;
    }

    public List<PropertyListPath> getChildren() {
        return this.getChildren(this, this._object);
    }

    protected List<PropertyListPath> getChildren(PropertyListPath path, Object pathObject) {
        List<Object> childrenList;
        if (pathObject instanceof Map) {
            Map lastPathMap = (Map)pathObject;
            childrenList = new LinkedList();
            int index = 0;
            LinkedList entries = new LinkedList(lastPathMap.entrySet());
            for (Map.Entry entry : entries) {
                PropertyListPath childPath = path.createChild(index++, entry);
                childrenList.add(childPath);
            }
        } else if (pathObject instanceof Map.Entry) {
            Map.Entry lastPathMapEntry = (Map.Entry)pathObject;
            childrenList = this.getChildren(path, lastPathMapEntry.getValue());
        } else if (pathObject instanceof List) {
            List lastPathList = (List)pathObject;
            childrenList = new LinkedList();
            int index = 0;
            for (Object child : lastPathList) {
                childrenList.add(path.createChild(index++, child));
            }
        } else if (pathObject instanceof Set) {
            Set lastPathSet = (Set)pathObject;
            childrenList = new LinkedList();
            int index = 0;
            for (Object child : lastPathSet) {
                childrenList.add(path.createChild(index++, child));
            }
        } else {
            childrenList = new LinkedList();
        }
        return childrenList;
    }

    public PropertyListPath getParent() {
        return this._parent;
    }

    public Object getRawObject() {
        return this._object;
    }

    public PropertyListPath createChild(int index, Object child) {
        return new PropertyListPath(this, index, child, this._factory);
    }

    public boolean isCollectionValue() {
        Object object = this._object;
        if (object instanceof Map.Entry) {
            object = ((Map.Entry)object).getValue();
        }
        boolean collectionValue = object instanceof Map ? true : object instanceof Collection;
        return collectionValue;
    }

    public int getChildCount() {
        Object value = this.getValue();
        int childCount = value instanceof Map ? ((Map)value).size() : (value instanceof Collection ? ((Collection)value).size() : -1);
        return childCount;
    }

    public String getKeyPath() {
        StringBuffer sb = new StringBuffer();
        this.getKeyPath(sb);
        return sb.toString();
    }

    protected void getKeyPath(StringBuffer sb) {
        if (this._parent != null) {
            this._parent.getKeyPath(sb);
            sb.append(".");
        }
        sb.append(this.getKey());
    }

    public boolean setKey(Object key) {
        boolean valueChanged = false;
        Object pathObject = this.getRawObject();
        PropertyListPath parentPath = this.getParent();
        if (parentPath != null && pathObject instanceof Map.Entry) {
            Object parentObject = parentPath.getRawObject();
            Map parentMap = parentObject instanceof Map ? (Map)parentObject : (Map)((Map.Entry)parentObject).getValue();
            String oldKey = this.getKey();
            if (!parentMap.containsKey(key)) {
                if (parentMap instanceof LinkedHashMap) {
                    LinkedList entries = new LinkedList(parentMap.entrySet());
                    parentMap.clear();
                    for (Map.Entry entry : entries) {
                        if (ComparisonUtils.equals(entry.getKey(), (Object)oldKey)) {
                            parentMap.put(key, entry.getValue());
                            continue;
                        }
                        parentMap.put(entry.getKey(), entry.getValue());
                    }
                } else {
                    Object value = parentMap.remove(oldKey);
                    parentMap.put(key, value);
                }
                valueChanged = true;
            }
        }
        return valueChanged;
    }

    public boolean isRealKey() {
        Object pathObject = this.getRawObject();
        PropertyListPath parentPath = this.getParent();
        boolean isRealKey = parentPath == null ? false : pathObject instanceof Map.Entry;
        return isRealKey;
    }

    public String getKey() {
        Object parentPathObject;
        Object pathObject = this.getRawObject();
        PropertyListPath parentPath = this.getParent();
        Object key = parentPath == null ? "Root" : (pathObject instanceof Map.Entry ? String.valueOf(((Map.Entry)pathObject).getKey()) : ((parentPathObject = parentPath.getValue()) instanceof List ? "Item " + (this.getIndex() + 1) : "Unknown"));
        return key;
    }

    public boolean setValue(Object value) {
        boolean parentChanged = false;
        PropertyListPath parentPath = this.getParent();
        if (parentPath == null) {
            this._object = value;
        } else {
            Object parentObject = parentPath.getValue();
            if (parentObject instanceof Map) {
                Map parentMap = (Map)parentObject;
                String key = this.getKey();
                parentMap.put(key, value);
            } else if (parentObject instanceof List) {
                int index = this.getIndex();
                List parentList = (List)parentObject;
                parentList.set(index, value);
                parentChanged = true;
            } else if (parentObject instanceof Set) {
                Set parentSet = (Set)parentObject;
                parentSet.remove(this.getValue());
                parentSet.add(value);
                parentChanged = true;
            } else {
                System.out.println("PropertyListPath.getValue: ignoring " + this.getKeyPath() + "=" + value);
            }
        }
        return parentChanged;
    }

    public Object getValue() {
        Object value = this._object;
        if (value instanceof Map.Entry) {
            value = ((Map.Entry)value).getValue();
        }
        return value;
    }

    public Type getType() {
        Object value = this.getValue();
        for (Type type : Type.values()) {
            if (!type.matches(value)) continue;
            return type;
        }
        return null;
    }

    public boolean setType(Type newType) {
        Object newValue = this.convertValueToType(newType);
        boolean parentChanged = this.setValue(newValue);
        return parentChanged;
    }

    public Object convertValueToType(Type newType) {
        Object newValue = PropertyListPath.convertValueFromTypeToType(this.getKeyPath(), this.getValue(), this.getType(), newType, this._factory);
        return newValue;
    }

    public ParserDataStructureFactory getFactory() {
        return this._factory;
    }

    public static Object convertValueFromTypeToType(String keyPath, Object oldValue, Type oldType, Type newType, ParserDataStructureFactory factory) {
        Comparable<Calendar> newValue;
        block79: {
            try {
                if (oldType == Type.Array) {
                    Object oldListValue = null;
                    List oldList = (List)oldValue;
                    if (oldList != null && oldList.size() == 1) {
                        oldListValue = oldList.get(0);
                    }
                    if (newType == Type.Array) {
                        newValue = oldValue;
                        break block79;
                    }
                    if (newType == Type.Boolean) {
                        newValue = Boolean.TRUE;
                        if (oldListValue instanceof Boolean) {
                            newValue = oldListValue;
                        }
                        break block79;
                    }
                    if (newType == Type.Data) {
                        newValue = oldListValue instanceof byte[] ? (Comparable<Calendar>)((byte[])oldListValue) : (Comparable<Calendar>)WOLPropertyListSerialization.stringFromPropertyList((Object)oldValue).getBytes();
                        break block79;
                    }
                    if (newType == Type.Date) {
                        newValue = oldListValue instanceof Date ? (Date)oldListValue : (oldListValue instanceof Calendar ? (Calendar)oldListValue : new Date());
                        break block79;
                    }
                    if (newType == Type.Dictionary) {
                        Map newMap = factory.createMap(keyPath);
                        int keyNum = 1;
                        for (Object obj : (Collection)oldValue) {
                            newMap.put("New Key " + keyNum++, obj);
                        }
                        newValue = newMap;
                        break block79;
                    }
                    if (newType == Type.Number) {
                        newValue = oldListValue instanceof Number ? (Number)oldListValue : (Number)(oldValue != null ? Integer.valueOf(((Collection)oldValue).size()) : Integer.valueOf(0));
                        break block79;
                    }
                    if (newType == Type.String) {
                        newValue = oldListValue instanceof String ? (String)oldListValue : WOLPropertyListSerialization.stringFromPropertyList((Object)oldValue);
                        break block79;
                    }
                    throw new IllegalArgumentException("Unknown type " + newType);
                }
                if (oldType == Type.Boolean) {
                    if (newType == Type.Array) {
                        Collection list = factory.createCollection(keyPath);
                        list.add(oldValue);
                        newValue = list;
                        break block79;
                    }
                    if (newType == Type.Boolean) {
                        newValue = oldValue;
                        break block79;
                    }
                    if (newType == Type.Data) {
                        newValue = (Comparable<Calendar>)new byte[]{1};
                        break block79;
                    }
                    if (newType == Type.Date) {
                        newValue = new Date();
                        break block79;
                    }
                    if (newType == Type.Dictionary) {
                        Map newMap = factory.createMap(keyPath);
                        newMap.put("New Key 1", oldValue);
                        newValue = newMap;
                        break block79;
                    }
                    if (newType == Type.Number) {
                        newValue = ((Collection)oldValue).size();
                        break block79;
                    }
                    if (newType == Type.String) {
                        newValue = WOLPropertyListSerialization.stringFromPropertyList((Object)oldValue);
                        break block79;
                    }
                    throw new IllegalArgumentException("Unknown type " + newType);
                }
                if (oldType == Type.Data) {
                    byte[] oldBytes = (byte[])oldValue;
                    if (newType == Type.Array) {
                        Collection list = factory.createCollection(keyPath);
                        list.add(oldValue);
                        newValue = list;
                        break block79;
                    }
                    if (newType == Type.Boolean) {
                        newValue = oldBytes != null && oldBytes.length == 1 ? Boolean.valueOf(oldBytes[0] > 0) : Boolean.TRUE;
                        break block79;
                    }
                    if (newType == Type.Data) {
                        newValue = oldValue;
                        break block79;
                    }
                    if (newType == Type.Date) {
                        newValue = new Date();
                        break block79;
                    }
                    if (newType == Type.Dictionary) {
                        Map newMap = factory.createMap(keyPath);
                        newMap.put("New Key 1", oldValue);
                        newValue = newMap;
                        break block79;
                    }
                    if (newType == Type.Number) {
                        if (oldBytes != null) {
                            String str = new String(oldBytes);
                            try {
                                newValue = new BigDecimal(str);
                            }
                            catch (NumberFormatException e) {
                                newValue = oldBytes.length;
                            }
                        } else {
                            newValue = 0;
                        }
                        break block79;
                    }
                    if (newType == Type.String) {
                        newValue = oldBytes != null ? new String(oldBytes) : "";
                        break block79;
                    }
                    throw new IllegalArgumentException("Unknown type " + newType);
                }
                if (oldType == Type.Date) {
                    if (newType == Type.Array) {
                        Collection list = factory.createCollection(keyPath);
                        list.add(oldValue);
                        newValue = list;
                        break block79;
                    }
                    if (newType == Type.Boolean) {
                        newValue = Boolean.TRUE;
                        break block79;
                    }
                    if (newType == Type.Data) {
                        newValue = (Comparable<Calendar>)new byte[0];
                        break block79;
                    }
                    if (newType == Type.Date) {
                        newValue = oldValue;
                        break block79;
                    }
                    if (newType == Type.Dictionary) {
                        Map newMap = factory.createMap(keyPath);
                        newMap.put("New Key 1", oldValue);
                        newValue = newMap;
                        break block79;
                    }
                    if (newType == Type.Number) {
                        newValue = System.currentTimeMillis();
                        break block79;
                    }
                    if (newType == Type.String) {
                        DateFormat dateFormat = DateFormat.getDateTimeInstance();
                        newValue = oldValue instanceof Date ? dateFormat.format(oldValue) : (oldValue instanceof Calendar ? dateFormat.format(((Calendar)oldValue).getTime()) : "");
                        break block79;
                    }
                    throw new IllegalArgumentException("Unknown type " + newType);
                }
                if (oldType == Type.Dictionary) {
                    Map.Entry entry;
                    Map oldMap = (Map)oldValue;
                    Object oldMapValue = null;
                    if (oldMap != null && oldMap.size() == 1 && "New Key 1".equals((entry = oldMap.entrySet().iterator().next()).getKey())) {
                        oldMapValue = entry.getValue();
                    }
                    if (newType == Type.Array) {
                        Collection list = factory.createCollection(keyPath);
                        for (Map.Entry entry2 : ((Map)oldValue).entrySet()) {
                            list.add(entry2.getValue());
                        }
                        newValue = list;
                        break block79;
                    }
                    if (newType == Type.Boolean) {
                        newValue = oldMapValue instanceof Boolean ? (Boolean)oldMapValue : Boolean.TRUE;
                        break block79;
                    }
                    if (newType == Type.Data) {
                        newValue = oldMapValue instanceof byte[] ? (Comparable<Calendar>)((byte[])oldMapValue) : (Comparable<Calendar>)WOLPropertyListSerialization.stringFromPropertyList((Object)oldValue).getBytes();
                        break block79;
                    }
                    if (newType == Type.Date) {
                        newValue = oldMapValue instanceof Date ? (Date)oldMapValue : (oldMapValue instanceof Calendar ? (Calendar)oldMapValue : new Date());
                        break block79;
                    }
                    if (newType == Type.Dictionary) {
                        newValue = oldValue;
                        break block79;
                    }
                    if (newType == Type.Number) {
                        newValue = oldMapValue instanceof Number ? (Number)oldMapValue : (Number)(oldMap != null ? Integer.valueOf(oldMap.size()) : Integer.valueOf(0));
                        break block79;
                    }
                    if (newType == Type.String) {
                        newValue = oldMapValue instanceof String ? (String)oldMapValue : WOLPropertyListSerialization.stringFromPropertyList((Object)oldValue);
                        break block79;
                    }
                    throw new IllegalArgumentException("Unknown type " + newType);
                }
                if (oldType == Type.Number) {
                    Number oldNumber = (Number)oldValue;
                    if (newType == Type.Array) {
                        Collection list = factory.createCollection(keyPath);
                        list.add(oldValue);
                        newValue = list;
                        break block79;
                    }
                    if (newType == Type.Boolean) {
                        newValue = oldNumber != null && oldNumber.intValue() > 0;
                        break block79;
                    }
                    if (newType == Type.Data) {
                        newValue = (Comparable<Calendar>)String.valueOf(oldValue).getBytes();
                        break block79;
                    }
                    if (newType == Type.Date) {
                        newValue = new Date(System.currentTimeMillis());
                        break block79;
                    }
                    if (newType == Type.Dictionary) {
                        Map newMap = factory.createMap(keyPath);
                        newMap.put("New Key 1", oldValue);
                        newValue = newMap;
                        break block79;
                    }
                    if (newType == Type.Number) {
                        newValue = oldValue;
                        break block79;
                    }
                    if (newType == Type.String) {
                        newValue = String.valueOf(oldNumber);
                        break block79;
                    }
                    throw new IllegalArgumentException("Unknown type " + newType);
                }
                if (oldType == Type.String) {
                    String oldString = (String)oldValue;
                    if (newType == Type.Array) {
                        Collection list = factory.createCollection(keyPath);
                        list.add(oldValue);
                        newValue = list;
                        break block79;
                    }
                    if (newType == Type.Boolean) {
                        if (oldString == null) {
                            newValue = Boolean.FALSE;
                        } else {
                            try {
                                Boolean newObject = "y".equalsIgnoreCase(oldString) || "yes".equalsIgnoreCase(oldString) || "true".equalsIgnoreCase(oldString);
                                newValue = newObject instanceof Boolean ? newObject : Boolean.TRUE;
                            }
                            catch (Exception e) {
                                newValue = Boolean.FALSE;
                            }
                        }
                        break block79;
                    }
                    if (newType == Type.Data) {
                        newValue = (Comparable<Calendar>)WOLPropertyListSerialization.stringFromPropertyList((Object)oldValue).getBytes();
                        break block79;
                    }
                    if (newType == Type.Date) {
                        DateFormat dateFormat = DateFormat.getDateTimeInstance();
                        if (oldValue == null) {
                            newValue = new Date();
                        } else {
                            try {
                                newValue = dateFormat.parseObject((String)oldValue);
                            }
                            catch (ParseException e) {
                                newValue = new Date();
                            }
                        }
                        break block79;
                    }
                    if (newType == Type.Dictionary) {
                        Map newMap = factory.createMap(keyPath);
                        newMap.put("New Key 1", oldValue);
                        newValue = newMap;
                        break block79;
                    }
                    if (newType == Type.Number) {
                        if (oldValue == null) {
                            newValue = 0;
                        } else {
                            try {
                                newValue = new BigDecimal(oldString);
                            }
                            catch (NumberFormatException e) {
                                newValue = 0;
                            }
                        }
                        break block79;
                    }
                    if (newType == Type.String) {
                        newValue = oldValue;
                        break block79;
                    }
                    throw new IllegalArgumentException("Unknown type " + newType);
                }
                throw new IllegalArgumentException("Unknown old type " + oldType);
            }
            catch (PropertyListParserException e) {
                throw new IllegalArgumentException("Failed to process plist.", e);
            }
        }
        return newValue;
    }

    public PropertyListPath addRow() {
        PropertyListPath newPath;
        Object value = this.getValue();
        if (value instanceof Map) {
            String key;
            Map map = (Map)value;
            int i = 1;
            while (map.containsKey(key = "New Key " + i++)) {
            }
            map.put(key, "New Value");
            newPath = this.getChildForKey(key);
        } else if (value instanceof List) {
            List list = (List)value;
            list.add("New Value");
            newPath = this.getChildAtIndex(list.size() - 1);
        } else if (value instanceof Set) {
            String key;
            Set set = (Set)value;
            int i = 1;
            while (set.contains(key = "New Value " + i++)) {
            }
            newPath = null;
            for (PropertyListPath child : this.getChildren()) {
                if (!key.equals(child.getValue())) continue;
                newPath = child;
                break;
            }
        } else {
            newPath = null;
        }
        return newPath;
    }

    public boolean delete() {
        boolean deleted = false;
        PropertyListPath parentPath = this.getParent();
        if (parentPath != null) {
            Object parentValue = parentPath.getValue();
            if (parentValue instanceof List) {
                ((List)parentValue).remove(this.getIndex());
                deleted = true;
            } else if (parentValue instanceof Set) {
                ((Set)parentValue).remove(this.getValue());
                deleted = true;
            } else if (parentValue instanceof Map) {
                ((Map)parentValue).remove(this.getKey());
                deleted = true;
            }
        }
        return deleted;
    }

    public boolean moveUp() {
        boolean moved = false;
        PropertyListPath parentPath = this.getParent();
        if (parentPath != null) {
            Object parentValue = parentPath.getValue();
            if (parentValue instanceof List) {
                int index = this.getIndex();
                if (index > 0) {
                    Object obj = ((List)parentValue).remove(index);
                    ((List)parentValue).add(index - 1, obj);
                    moved = true;
                }
            } else if (parentValue instanceof Set || parentValue instanceof Map) {
                // empty if block
            }
        }
        return moved;
    }

    public boolean moveDown() {
        boolean moved = false;
        PropertyListPath parentPath = this.getParent();
        if (parentPath != null) {
            Object parentValue = parentPath.getValue();
            if (parentValue instanceof List) {
                int index = this.getIndex();
                if (index < parentPath.getChildCount() - 1) {
                    Object obj = ((List)parentValue).remove(index);
                    ((List)parentValue).add(index + 1, obj);
                    moved = true;
                }
            } else if (parentValue instanceof Set || parentValue instanceof Map) {
                // empty if block
            }
        }
        return moved;
    }

    public static enum Type {
        String("String", String.class, null),
        Number("Number", Number.class),
        Date("Date", Date.class, Calendar.class),
        Boolean("Boolean", Boolean.class),
        Array("Array", List.class, Set.class),
        Dictionary("Dictionary", Map.class),
        Data("Data", Object.class);

        private String _name;
        private Class[] _types;

        private Type(String name, Class ... types) {
            this._name = name;
            this._types = types;
        }

        public String getName() {
            return this._name;
        }

        public Class[] getTypes() {
            return this._types;
        }

        public boolean matches(Object obj) {
            Class<?> objType = obj == null ? null : obj.getClass();
            for (Class type : this._types) {
                if (!(type == null ? objType == null : objType != null && type.isAssignableFrom(objType))) continue;
                return true;
            }
            return false;
        }
    }
}

