/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ErrorDialog
extends IconAndMessageDialog {
    public static boolean AUTOMATED_MODE = false;
    private static final int LIST_ITEM_COUNT = 7;
    private static final String NESTING_INDENT = "  ";
    private Button detailsButton;
    private String title;
    private Text errorDetails;
    private boolean listCreated = false;
    private int displayMask = 65535;
    private IStatus status;
    private Clipboard clipboard;
    private boolean shouldIncludeTopLevelErrorInDetails = false;

    public ErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = message;
        this.status = status;
        this.displayMask = displayMask;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        if (this.status != null) {
            if (this.status.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.status.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected Text createErrorDetails(Composite parent) {
        this.errorDetails = new Text(parent, 2824);
        this.populateErrorDetails(this.errorDetails);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        data.horizontalSpan = 2;
        this.errorDetails.setLayoutData((Object)data);
        this.errorDetails.setFont(parent.getFont());
        Menu copyMenu = new Menu((Control)this.errorDetails);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorDialog.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        this.errorDetails.setMenu(copyMenu);
        this.listCreated = true;
        return this.errorDetails;
    }

    public int open() {
        if (!AUTOMATED_MODE && ErrorDialog.shouldDisplay(this.status, this.displayMask)) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    public static int openError(Shell parent, String dialogTitle, String message, IStatus status) {
        return ErrorDialog.openError(parent, dialogTitle, message, status, 7);
    }

    public static int openError(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        ErrorDialog dialog = new ErrorDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }

    private void populateErrorDetails(Text listToPopulate) {
        Throwable t;
        if (this.status != null && (t = this.status.getException()) != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            StringBuffer sb = sw.getBuffer();
            listToPopulate.setText(sb.toString());
        }
    }

    protected static boolean shouldDisplay(IStatus status, int mask) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].matches(mask)) continue;
            return true;
        }
        return false;
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.listCreated) {
            this.errorDetails.dispose();
            this.listCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.errorDetails = this.createErrorDetails((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    private void populateCopyBuffer(IStatus buildingStatus, StringBuffer buffer, int nesting) {
        if (!buildingStatus.matches(this.displayMask)) {
            return;
        }
        for (int i = 0; i < nesting; ++i) {
            buffer.append(NESTING_INDENT);
        }
        buffer.append(buildingStatus.getMessage());
        buffer.append("\n");
        Throwable t = buildingStatus.getException();
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            this.populateCopyBuffer(ce.getStatus(), buffer, nesting + 1);
        }
        IStatus[] children = buildingStatus.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.populateCopyBuffer(children[i], buffer, nesting + 1);
        }
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuffer statusBuffer = new StringBuffer();
        this.populateCopyBuffer(this.status, statusBuffer, 0);
        this.clipboard = new Clipboard(this.errorDetails.getDisplay());
        this.clipboard.setContents(new Object[]{statusBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.listCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.status.isMultiStatus() || this.status.getException() != null;
    }

    protected final void setStatus(IStatus status) {
        if (this.status != status) {
            this.status = status;
        }
        this.shouldIncludeTopLevelErrorInDetails = true;
        if (this.listCreated) {
            this.repopulateList();
        }
    }

    private void repopulateList() {
        if (this.errorDetails != null && !this.errorDetails.isDisposed()) {
            this.populateErrorDetails(this.errorDetails);
        }
    }
}

