/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.utils;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.PropertySheet;
import org.objectstyle.wolips.baseforuiplugins.Activator;

public class WorkbenchUtilities {
    public static boolean shouldSaveSelection(IWorkbenchWindow window) {
        return window != null && !(window.getPartService().getActivePart() instanceof PropertySheet);
    }

    public static final ISelection getSelection(IWorkbenchWindow window) {
        ISelection selection;
        if (window.getPartService().getActivePart() instanceof PropertySheet) {
            selection = window.getSelectionService().getSelection("org.eclipse.ui.views.ContentOutline");
            if (selection == null) {
                selection = window.getSelectionService().getSelection();
            }
        } else {
            selection = window.getSelectionService().getSelection();
        }
        return selection;
    }

    public static final void errorDialog(Shell shell, String title, String message, IStatus s) {
        Activator.getDefault().log(s);
        String errorMessage = message;
        if (s != null && errorMessage.equals(s.getMessage())) {
            errorMessage = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)errorMessage, (IStatus)s);
    }

    public static final void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        String errorMessage = message;
        Activator.getDefault().log(t);
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && errorMessage.equals(status.getMessage())) {
                errorMessage = null;
            }
        } else {
            status = new Status(4, Activator.getDefault().getBundleID(), 4, "Error within Debug UI: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)errorMessage, (IStatus)status);
    }

    public static final void findFilesInResourceByName(List<IResource> anArrayList, IResource aResource, String aFileName) {
        if (aResource != null && (aResource instanceof IContainer || aResource instanceof IProject) && aResource.isAccessible()) {
            IResource resource = ((IContainer)aResource).findMember(aFileName);
            if (resource != null && resource instanceof IFile && !resource.isDerived()) {
                anArrayList.add(resource);
            }
            IResource[] members = WorkbenchUtilities.members(aResource);
            WorkbenchUtilities.findFilesInResourceByName(anArrayList, members, aFileName);
        }
    }

    private static final void findFilesInResourceByName(List<IResource> anArrayList, IResource[] aResource, String aFileName) {
        for (int i = 0; i < aResource.length; ++i) {
            IResource memberResource = aResource[i];
            if (memberResource == null || memberResource.isDerived() || !(memberResource instanceof IContainer) || memberResource.toString().endsWith(".framework") || memberResource.toString().endsWith(".woa") || memberResource.toString().equalsIgnoreCase("build") && memberResource.getParent().equals(memberResource.getProject()) || memberResource.toString().equalsIgnoreCase("dist") && memberResource.getParent().equals(memberResource.getProject()) || memberResource.toString().equalsIgnoreCase("target") && memberResource.getParent().equals(memberResource.getProject())) continue;
            WorkbenchUtilities.findFilesInResourceByName(anArrayList, memberResource, aFileName);
        }
    }

    public static final IEditorPart getActiveEditor() {
        IWorkbenchPage page = WorkbenchUtilities.getActivePage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static final IEditorInput getActiveEditorInput() {
        IEditorPart part = WorkbenchUtilities.getActiveEditor();
        if (part != null) {
            return part.getEditorInput();
        }
        return null;
    }

    public static final IWorkbenchPage getActivePage() {
        return WorkbenchUtilities.getActiveWorkbenchWindow().getActivePage();
    }

    public static final Shell getActiveWorkbenchShell() {
        IWorkbenchWindow win = WorkbenchUtilities.getActiveWorkbenchWindow();
        Shell shell = null;
        if (null != win) {
            shell = win.getShell();
        }
        return shell;
    }

    public static final IWorkbenchWindow getActiveWorkbenchWindow() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static final IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private static final IResource[] members(IResource aResource) {
        IResource[] members = null;
        try {
            members = ((IContainer)aResource).members();
        }
        catch (Exception anException) {
            Activator.getDefault().log(anException);
        }
        return members;
    }

    public static final void open(List<IResource> anArrayList) {
        for (int i = 0; i < anArrayList.size(); ++i) {
            IResource resource = anArrayList.get(i);
            if (resource == null || resource.getType() != 1) continue;
            WorkbenchUtilities.open((IFile)resource);
        }
    }

    public static final void open(IFile file) {
        WorkbenchUtilities.open(file, null);
    }

    public static final IEditorPart open(IFile file, String editorID) {
        IWorkbenchPage workbenchPage;
        IWorkbenchWindow[] workbenchWindows;
        IEditorPart editorPart = null;
        IWorkbenchWindow workbenchWindow = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null && (workbenchWindows = Activator.getDefault().getWorkbench().getWorkbenchWindows()) != null && workbenchWindows.length > 0) {
            workbenchWindow = workbenchWindows[0];
        }
        if (workbenchWindow != null && (workbenchPage = workbenchWindow.getActivePage()) != null) {
            try {
                String id = null;
                if (editorID == null) {
                    IEditorDescriptor editorDescriptor = IDE.getDefaultEditor((IFile)file);
                    if (editorDescriptor == null) {
                        editorDescriptor = IDE.getEditorDescriptor((IFile)file);
                    }
                    if (editorDescriptor != null) {
                        id = editorDescriptor.getId();
                    }
                } else {
                    id = editorID;
                }
                editorPart = workbenchPage.openEditor((IEditorInput)new FileEditorInput(file), id);
            }
            catch (Exception anException) {
                Activator.getDefault().log(anException);
            }
        }
        return editorPart;
    }

    public static final IEditorReference findEditor(IFile file, String editorID) {
        IEditorReference editorReference = null;
        block2: for (IWorkbenchWindow workbenchWindow : PlatformUI.getWorkbench().getWorkbenchWindows()) {
            for (IWorkbenchPage workbenchPage : workbenchWindow.getPages()) {
                try {
                    String id = null;
                    if (editorID == null) {
                        IEditorDescriptor editorDescriptor = IDE.getDefaultEditor((IFile)file);
                        if (editorDescriptor == null) {
                            editorDescriptor = IDE.getEditorDescriptor((IFile)file);
                        }
                        if (editorDescriptor != null) {
                            id = editorDescriptor.getId();
                        }
                    } else {
                        id = editorID;
                    }
                    IEditorReference[] editorReferences = workbenchPage.findEditors((IEditorInput)new FileEditorInput(file), id, 3);
                    if (editorReferences == null || editorReferences.length <= 0) continue;
                    editorReference = editorReferences[0];
                    continue block2;
                }
                catch (Exception anException) {
                    Activator.getDefault().log(anException);
                }
            }
        }
        return editorReference;
    }

    public static final IStructuredSelection getActiveWorkbenchWindowSelection() {
        ISelection selection;
        IWorkbenchWindow window = WorkbenchUtilities.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

