/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eogenerator.ui.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.eogenerator.core.model.EOGeneratorModel;
import org.objectstyle.wolips.eogenerator.core.model.EOModelReference;

public class EOGeneratorFormPage
extends FormPage {
    private EOGeneratorModel _model;
    private TableViewer _modelsTableViewer;
    private TableViewer _refModelsTableViewer;
    private TableViewer _definesTableViewer;
    private boolean _modelGroupEditor;
    private DirtyModelListener _dirtyModelListener;
    private DataBindingContext _bindingContext;

    public EOGeneratorFormPage(FormEditor editor, EOGeneratorModel model, boolean modelGroupEditor) {
        super(editor, "EOGeneratorForm", modelGroupEditor ? "EOModelGroup Form" : "EOGenerator Form");
        this._model = model;
        this._dirtyModelListener = new DirtyModelListener();
        this._model.addPropertyChangeListener("dirty", (PropertyChangeListener)this._dirtyModelListener);
        this._modelGroupEditor = modelGroupEditor;
    }

    public void dispose() {
        this._bindingContext.dispose();
        this._model.removePropertyChangeListener("dirty", (PropertyChangeListener)this._dirtyModelListener);
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected String getString(String name) {
        return name;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this._bindingContext = new DataBindingContext();
        ScrolledForm form = managedForm.getForm();
        form.setText("EOGenerator");
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = form.getBody();
        GridLayout bodyLayout = new GridLayout();
        bodyLayout.numColumns = 1;
        bodyLayout.makeColumnsEqualWidth = true;
        bodyLayout.marginWidth = 10;
        bodyLayout.verticalSpacing = 20;
        bodyLayout.horizontalSpacing = 10;
        body.setLayout((Layout)bodyLayout);
        ModelsTableContentProvider modelsModel = new ModelsTableContentProvider();
        String modelsDescription = this._modelGroupEditor ? "For editing a model group, there should only be one entry in the model list.  If there are multiple models, they will all be loaded into the group, but the first entry will be the model that is opened by entity modeler." : "These models will have Java files generated for all of their entities.";
        this._modelsTableViewer = this.createModelsSection("Models", modelsDescription, toolkit, body, modelsModel, modelsModel, new ModelAddModelListener(), new ModelRemoveModelListener());
        RefModelsTableContentProvider refModelsModel = new RefModelsTableContentProvider();
        String refModelDescription = this._modelGroupEditor ? "Add all addition models that should be a model of this model group into the list below." : "These models are used to resolve type references from models listed in the first section.  No Java files will be generated for these models.";
        this._refModelsTableViewer = this.createModelsSection("Referenced Models", refModelDescription, toolkit, body, refModelsModel, refModelsModel, new RefModelAddModelListener(), new RefModelRemoveModelListener());
        if (!this._modelGroupEditor) {
            this.createNamingSection(toolkit, body);
            this.createPathsSection(toolkit, body);
            this.createDefinesSection(toolkit, body);
        }
        this.updateViewsFromModel();
        form.pack();
        form.reflow(true);
    }

    private TableViewer createModelsSection(String title, String description, FormToolkit toolkit, Composite parent, IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, SelectionListener addListener, SelectionListener removeListener) {
        Composite modelsSection = this.createSection(toolkit, parent, title, description, 1, 2);
        if (contentProvider instanceof RefModelsTableContentProvider) {
            Button loadModelGroupButton = toolkit.createButton(modelsSection, "", 32);
            loadModelGroupButton.setText("Load Model Group");
            GridData loadModelGroupButtonGridData = new GridData(4);
            loadModelGroupButtonGridData.horizontalSpan = 2;
            loadModelGroupButtonGridData.verticalIndent = 5;
            loadModelGroupButton.setLayoutData((Object)loadModelGroupButtonGridData);
            this._bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)loadModelGroupButton), BeanProperties.value((String)"loadModelGroup").observe((Object)this._model), null, null);
        }
        Table modelsTable = toolkit.createTable(modelsSection, 68098);
        GridData modelsTableGridData = new GridData(1810);
        modelsTableGridData.heightHint = 75;
        modelsTable.setLayoutData((Object)modelsTableGridData);
        TableViewer modelsTableViewer = new TableViewer(modelsTable);
        modelsTableViewer.setContentProvider((IContentProvider)contentProvider);
        modelsTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        Composite modelsButtonsComposite = toolkit.createComposite(modelsSection);
        modelsButtonsComposite.setLayoutData((Object)new GridData(2));
        GridLayout modelsButtonsLayout = new GridLayout();
        modelsButtonsLayout.marginTop = 0;
        modelsButtonsLayout.marginBottom = 0;
        modelsButtonsLayout.verticalSpacing = 0;
        modelsButtonsLayout.horizontalSpacing = 0;
        modelsButtonsLayout.numColumns = 1;
        modelsButtonsComposite.setLayout((Layout)modelsButtonsLayout);
        Button modelsAddButton = toolkit.createButton(modelsButtonsComposite, "Add...", 8);
        GridData modelsAddButtonGridData = new GridData(770);
        modelsAddButton.setLayoutData((Object)modelsAddButtonGridData);
        modelsAddButton.addSelectionListener(addListener);
        Button modelsRemoveButton = toolkit.createButton(modelsButtonsComposite, "Remove", 8);
        GridData modelsRemoveButtonGridData = new GridData(770);
        modelsRemoveButton.setLayoutData((Object)modelsRemoveButtonGridData);
        modelsRemoveButton.addSelectionListener(removeListener);
        return modelsTableViewer;
    }

    protected EOGeneratorModel getModel() {
        return this._model;
    }

    protected void createNamingSection(FormToolkit toolkit, Composite parent) {
        Composite namingSection = this.createSection(toolkit, parent, "File Names", "These settings control the names of the produced files.", 1, 2);
        GridLayout namingSectionLayout = (GridLayout)namingSection.getLayout();
        namingSectionLayout.horizontalSpacing = 10;
        Label filenameTemplateLabel = toolkit.createLabel(namingSection, "Filename Template:");
        filenameTemplateLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text filenameTemplate = toolkit.createText(namingSection, null);
        filenameTemplate.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)filenameTemplate), BeanProperties.value((String)"filenameTemplate").observe((Object)this._model), null, null);
        Label prefixLabel = toolkit.createLabel(namingSection, "Prefix:");
        prefixLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text prefixEntry = toolkit.createText(namingSection, null);
        prefixEntry.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)prefixEntry), BeanProperties.value((String)"prefix").observe((Object)this._model), null, null);
        Label extensionLabel = toolkit.createLabel(namingSection, "Extension:");
        extensionLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text extensionEntry = toolkit.createText(namingSection, null);
        extensionEntry.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)extensionEntry), BeanProperties.value((String)"extension").observe((Object)this._model), null, null);
    }

    protected void createPathsSection(FormToolkit toolkit, Composite parent) {
        FileEditorInput editorInput = (FileEditorInput)this.getEditorInput();
        IFile eogenFile = editorInput.getFile();
        final IProject project = eogenFile.getProject();
        Composite pathsSection = this.createSection(toolkit, parent, "Destination Paths", "These paths specify where generated files will be written and are project-relative.", 1, 3);
        GridLayout pathsSectionLayout = (GridLayout)pathsSection.getLayout();
        pathsSectionLayout.horizontalSpacing = 10;
        Label superclassPackageLabel = toolkit.createLabel(pathsSection, "Superclass Package (e.g. \"base\"):");
        superclassPackageLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text superclassPackage = toolkit.createText(pathsSection, null);
        superclassPackage.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)superclassPackage), BeanProperties.value((String)"superclassPackage").observe((Object)this._model), null, null);
        toolkit.createLabel(pathsSection, "");
        Label destinationLabel = toolkit.createLabel(pathsSection, "Destination:");
        destinationLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text destination = toolkit.createText(pathsSection, null);
        destination.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)destination), BeanProperties.value((String)"destination").observe((Object)this._model), null, null);
        Button destinationBrowse = toolkit.createButton(pathsSection, "Browse...", 8);
        destinationBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(EOGeneratorFormPage.this.getEditorSite().getShell(), (IContainer)project, false, "Select the folder to write autogenerated files into.");
                containerDialog.open();
                Object[] selectedContainers = containerDialog.getResult();
                if (selectedContainers != null && selectedContainers.length > 0) {
                    IPath selectedPath = (IPath)selectedContainers[0];
                    IFolder selectedFolder = project.getParent().getFolder(selectedPath);
                    IPath projectRelativePath = selectedFolder.getProjectRelativePath();
                    EOGeneratorFormPage.this.getModel().setDestination(projectRelativePath.toPortableString());
                }
                destination.forceFocus();
            }
        });
        Label subclassDestinationLabel = toolkit.createLabel(pathsSection, "Subclass Destination:");
        subclassDestinationLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text subclassDestination = toolkit.createText(pathsSection, null);
        subclassDestination.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)subclassDestination), BeanProperties.value((String)"subclassDestination").observe((Object)this._model), null, null);
        Button subclassDestinationBrowse = toolkit.createButton(pathsSection, "Browse...", 8);
        subclassDestinationBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(EOGeneratorFormPage.this.getEditorSite().getShell(), (IContainer)project, false, "Select the folder to generate customizable files into.");
                containerDialog.open();
                Object[] selectedContainers = containerDialog.getResult();
                if (selectedContainers != null && selectedContainers.length > 0) {
                    IPath selectedPath = (IPath)selectedContainers[0];
                    IFolder selectedFolder = project.getParent().getFolder(selectedPath);
                    IPath projectRelativePath = selectedFolder.getProjectRelativePath();
                    EOGeneratorFormPage.this.getModel().setSubclassDestination(projectRelativePath.toPortableString());
                }
                subclassDestination.forceFocus();
            }
        });
        Composite templatesSection = this.createSection(toolkit, parent, "Templates", "These paths specify the templates that will be used to generate files.  If left blank, the defaults from the EOGenerator preference page will be used.", 1, 3);
        GridLayout templatesSectionLayout = (GridLayout)templatesSection.getLayout();
        templatesSectionLayout.horizontalSpacing = 10;
        Label templatesFolderLabel = toolkit.createLabel(templatesSection, "Templates Folder:");
        templatesFolderLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text templatesFolder = toolkit.createText(templatesSection, null);
        templatesFolder.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)templatesFolder), BeanProperties.value((String)"templateDir").observe((Object)this._model), null, null);
        Button templatesFolderBrowse = toolkit.createButton(templatesSection, "Browse...", 8);
        templatesFolderBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(EOGeneratorFormPage.this.getEditorSite().getShell());
                directoryDialog.setMessage("Select the folder that contains your EOGenerator templates.");
                directoryDialog.setFilterPath(EOGeneratorFormPage.this.getModel().getTemplateDir());
                String selectedDirectory = directoryDialog.open();
                if (selectedDirectory != null) {
                    EOGeneratorFormPage.this.getModel().setTemplateDir(selectedDirectory);
                }
                templatesFolder.forceFocus();
            }
        });
        Label templateLabel = toolkit.createLabel(templatesSection, "Template:");
        templateLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text template = toolkit.createText(templatesSection, null);
        template.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)template), BeanProperties.value((String)"javaTemplate").observe((Object)this._model), null, null);
        Button templateBrowse = toolkit.createButton(templatesSection, "Browse...", 8);
        templateBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                String selectedTemplate = EOGeneratorFormPage.this.selectTemplate("Select the superclass template.");
                if (selectedTemplate != null) {
                    EOGeneratorFormPage.this.getModel().setJavaTemplate(selectedTemplate);
                }
                template.forceFocus();
            }
        });
        Label subclassTemplateLabel = toolkit.createLabel(templatesSection, "Subclass Template:");
        subclassTemplateLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text subclassTemplate = toolkit.createText(templatesSection, null);
        subclassTemplate.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)subclassTemplate), BeanProperties.value((String)"subclassJavaTemplate").observe((Object)this._model), null, null);
        Button subclassTemplateBrowse = toolkit.createButton(templatesSection, "Browse...", 8);
        subclassTemplateBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                String selectedTemplate = EOGeneratorFormPage.this.selectTemplate("Select the subclass template.");
                if (selectedTemplate != null) {
                    EOGeneratorFormPage.this.getModel().setSubclassJavaTemplate(selectedTemplate);
                }
                subclassTemplate.forceFocus();
            }
        });
        String furtherTemplatesDescription = "It's possible to generate Java-Files from up to three additional Templates in the 'Templates-Folder'.\nThe name of each Java-File will be based on the generated class-name according to the Template.\nThe generated Java-Files for 'Desination2', 'Destination3' and 'Destination4' will always be overwritten. (Same behaviour as with 'Desination')";
        Composite furtherTemplatesSection = this.createSection(toolkit, parent, "Generate additional Java-Files", furtherTemplatesDescription, 1, 3);
        GridLayout furtherTemplatesLayout = (GridLayout)furtherTemplatesSection.getLayout();
        furtherTemplatesLayout.horizontalSpacing = 10;
        Label destination2Label = toolkit.createLabel(furtherTemplatesSection, "Destination2:");
        destination2Label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text destination2 = toolkit.createText(furtherTemplatesSection, null);
        destination2.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)destination2), BeanProperties.value((String)"destination2").observe((Object)this._model), null, null);
        Button destination2Browse = toolkit.createButton(furtherTemplatesSection, "Browse...", 8);
        destination2Browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(EOGeneratorFormPage.this.getEditorSite().getShell(), (IContainer)project, false, "Select the folder2 to write autogenerated files into.");
                containerDialog.open();
                Object[] selectedContainers = containerDialog.getResult();
                if (selectedContainers != null && selectedContainers.length > 0) {
                    IPath selectedPath = (IPath)selectedContainers[0];
                    IFolder selectedFolder = project.getParent().getFolder(selectedPath);
                    IPath projectRelativePath = selectedFolder.getProjectRelativePath();
                    EOGeneratorFormPage.this.getModel().setDestination2(projectRelativePath.toPortableString());
                }
                destination2.forceFocus();
            }
        });
        Label template2Label = toolkit.createLabel(furtherTemplatesSection, "Template2:");
        template2Label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text template2 = toolkit.createText(furtherTemplatesSection, null);
        template2.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)template2), BeanProperties.value((String)"javaTemplate2").observe((Object)this._model), null, null);
        Button templateBrowse2 = toolkit.createButton(furtherTemplatesSection, "Browse...", 8);
        templateBrowse2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                String selectedTemplate = EOGeneratorFormPage.this.selectTemplate("Select the template2.");
                if (selectedTemplate != null) {
                    EOGeneratorFormPage.this.getModel().setJavaTemplate2(selectedTemplate);
                }
                template2.forceFocus();
            }
        });
        Label destination3Label = toolkit.createLabel(furtherTemplatesSection, "Destination3:");
        destination3Label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text destination3 = toolkit.createText(furtherTemplatesSection, null);
        destination3.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)destination3), BeanProperties.value((String)"destination3").observe((Object)this._model), null, null);
        Button destination3Browse = toolkit.createButton(furtherTemplatesSection, "Browse...", 8);
        destination3Browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(EOGeneratorFormPage.this.getEditorSite().getShell(), (IContainer)project, false, "Select the folder3 to write autogenerated files into.");
                containerDialog.open();
                Object[] selectedContainers = containerDialog.getResult();
                if (selectedContainers != null && selectedContainers.length > 0) {
                    IPath selectedPath = (IPath)selectedContainers[0];
                    IFolder selectedFolder = project.getParent().getFolder(selectedPath);
                    IPath projectRelativePath = selectedFolder.getProjectRelativePath();
                    EOGeneratorFormPage.this.getModel().setDestination3(projectRelativePath.toPortableString());
                }
                destination3.forceFocus();
            }
        });
        Label template3Label = toolkit.createLabel(furtherTemplatesSection, "Template3:");
        template3Label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text template3 = toolkit.createText(furtherTemplatesSection, null);
        template3.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)template3), BeanProperties.value((String)"javaTemplate3").observe((Object)this._model), null, null);
        Button templateBrowse3 = toolkit.createButton(furtherTemplatesSection, "Browse...", 8);
        templateBrowse3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                String selectedTemplate = EOGeneratorFormPage.this.selectTemplate("Select the template3.");
                if (selectedTemplate != null) {
                    EOGeneratorFormPage.this.getModel().setJavaTemplate3(selectedTemplate);
                }
                template3.forceFocus();
            }
        });
        Label destination4Label = toolkit.createLabel(furtherTemplatesSection, "Destination4:");
        destination4Label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text destination4 = toolkit.createText(furtherTemplatesSection, null);
        destination4.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)destination4), BeanProperties.value((String)"destination4").observe((Object)this._model), null, null);
        Button destination4Browse = toolkit.createButton(furtherTemplatesSection, "Browse...", 8);
        destination4Browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(EOGeneratorFormPage.this.getEditorSite().getShell(), (IContainer)project, false, "Select the folder4 to write autogenerated files into.");
                containerDialog.open();
                Object[] selectedContainers = containerDialog.getResult();
                if (selectedContainers != null && selectedContainers.length > 0) {
                    IPath selectedPath = (IPath)selectedContainers[0];
                    IFolder selectedFolder = project.getParent().getFolder(selectedPath);
                    IPath projectRelativePath = selectedFolder.getProjectRelativePath();
                    EOGeneratorFormPage.this.getModel().setDestination4(projectRelativePath.toPortableString());
                }
                destination4.forceFocus();
            }
        });
        Label template4Label = toolkit.createLabel(furtherTemplatesSection, "Template4:");
        template4Label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        final Text template4 = toolkit.createText(furtherTemplatesSection, null);
        template4.setLayoutData((Object)new GridData(768));
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)template4), BeanProperties.value((String)"javaTemplate4").observe((Object)this._model), null, null);
        Button templateBrowse4 = toolkit.createButton(furtherTemplatesSection, "Browse...", 8);
        templateBrowse4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                String selectedTemplate = EOGeneratorFormPage.this.selectTemplate("Select the template4.");
                if (selectedTemplate != null) {
                    EOGeneratorFormPage.this.getModel().setJavaTemplate4(selectedTemplate);
                }
                template4.forceFocus();
            }
        });
        Composite outputOptionsSection = this.createSection(toolkit, parent, "Options", "These flags control various output options for generated source.", 1, 3);
        GridLayout outputOptionsLayout = (GridLayout)outputOptionsSection.getLayout();
        outputOptionsLayout.horizontalSpacing = 10;
        outputOptionsLayout.verticalSpacing = 5;
        Button packageDirsButton = toolkit.createButton(outputOptionsSection, "", 32);
        packageDirsButton.setText("Create Packages");
        GridData packageDirsButtonGridData = new GridData(4);
        packageDirsButtonGridData.horizontalSpan = 3;
        packageDirsButton.setLayoutData((Object)packageDirsButtonGridData);
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)packageDirsButton), BeanProperties.value((String)"packageDirs").observe((Object)this._model), null, null);
        Button javaButton = toolkit.createButton(outputOptionsSection, "", 32);
        GridData javaButtonGridData = new GridData(4);
        javaButtonGridData.horizontalSpan = 3;
        javaButton.setLayoutData((Object)javaButtonGridData);
        javaButton.setText("Java");
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)javaButton), BeanProperties.value((String)"java").observe((Object)this._model), null, null);
        Button javaClientButton = toolkit.createButton(outputOptionsSection, "", 32);
        javaClientButton.setText("Java Client");
        GridData javaClientButtonGridData = new GridData(4);
        javaClientButtonGridData.horizontalSpan = 3;
        javaClientButton.setLayoutData((Object)javaClientButtonGridData);
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)javaClientButton), BeanProperties.value((String)"javaClient").observe((Object)this._model), null, null);
        Button javaClientCommonButton = toolkit.createButton(outputOptionsSection, "", 32);
        javaClientCommonButton.setText("Java Client Common");
        GridData javaClientCommonButtonGridData = new GridData(4);
        javaClientCommonButtonGridData.horizontalSpan = 3;
        javaClientCommonButton.setLayoutData((Object)javaClientCommonButtonGridData);
        this._bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)javaClientCommonButton), BeanProperties.value((String)"javaClientCommon").observe((Object)this._model), null, null);
    }

    protected String selectTemplate(String text) {
        String selectedTemplate = null;
        FileDialog templateDialog = new FileDialog(this.getEditorSite().getShell());
        templateDialog.setFileName(this._model.getTemplateDir());
        templateDialog.setText(text);
        templateDialog.setFilterExtensions(new String[]{"*.eotemplate"});
        String templateDir = this._model.getTemplateDir();
        if (templateDir != null) {
            templateDialog.setFilterPath(templateDir);
        }
        if ((selectedTemplate = templateDialog.open()) != null && templateDir != null && selectedTemplate.startsWith(templateDir)) {
            int templateDirLength = templateDir.length();
            if (!templateDir.endsWith(File.separator)) {
                templateDirLength += File.separator.length();
            }
            selectedTemplate = selectedTemplate.substring(templateDirLength);
        }
        return selectedTemplate;
    }

    protected void createDefinesSection(FormToolkit toolkit, Composite parent) {
        Composite definesSection = this.createSection(toolkit, parent, "Defines", "These variables will turn into EOGenerator -define-Xxx parameters that will be accessible in your templates (i.e. EOGenericRecord, etc)", 1, 2);
        Table definesTable = toolkit.createTable(definesSection, 68098);
        definesTable.setLinesVisible(true);
        definesTable.setHeaderVisible(true);
        TableColumn defineNameTableColumn = new TableColumn(definesTable, 0);
        defineNameTableColumn.setWidth(175);
        defineNameTableColumn.setText("Name");
        TableColumn defineValueTableColumn = new TableColumn(definesTable, 0);
        defineValueTableColumn.setWidth(400);
        defineValueTableColumn.setText("Value");
        this._definesTableViewer = new TableViewer(definesTable);
        DefinesTableContentProvider definesModel = new DefinesTableContentProvider();
        this._definesTableViewer.setContentProvider((IContentProvider)definesModel);
        this._definesTableViewer.setLabelProvider((IBaseLabelProvider)definesModel);
        this._definesTableViewer.addDoubleClickListener((IDoubleClickListener)new DefinesDoubleClickListener());
        GridData definesTableGridData = new GridData(1810);
        definesTableGridData.heightHint = 125;
        definesTable.setLayoutData((Object)definesTableGridData);
        Composite definesButtonsComposite = toolkit.createComposite(definesSection);
        definesButtonsComposite.setLayoutData((Object)new GridData(2));
        GridLayout definesButtonsLayout = new GridLayout();
        definesButtonsLayout.marginTop = 0;
        definesButtonsLayout.marginBottom = 0;
        definesButtonsLayout.verticalSpacing = 0;
        definesButtonsLayout.horizontalSpacing = 0;
        definesButtonsLayout.numColumns = 1;
        definesButtonsComposite.setLayout((Layout)definesButtonsLayout);
        Button definesAddButton = toolkit.createButton(definesButtonsComposite, "Add...", 8);
        GridData definesAddButtonGridData = new GridData(770);
        definesAddButton.setLayoutData((Object)definesAddButtonGridData);
        definesAddButton.addSelectionListener((SelectionListener)new DefineAddModelListener());
        Button definesRemoveButton = toolkit.createButton(definesButtonsComposite, "Remove", 8);
        GridData definesRemoveButtonGridData = new GridData(770);
        definesRemoveButton.setLayoutData((Object)definesRemoveButtonGridData);
        definesRemoveButton.addSelectionListener((SelectionListener)new DefinesRemoveModelListener());
    }

    protected void updateViewsFromModel() {
        this._modelsTableViewer.setInput((Object)this._model);
        this._refModelsTableViewer.setInput((Object)this._model);
        if (!this._modelGroupEditor) {
            this._definesTableViewer.setInput((Object)this._model);
        }
    }

    protected Composite createSection(FormToolkit toolkit, Composite parent, String title, String description, int spanColumns, int sectionColumns) {
        int style = description == null ? 320 : 448;
        Section section = toolkit.createSection(parent, style);
        GridLayout sectionLayout = new GridLayout();
        section.setLayout((Layout)sectionLayout);
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
        GridData sectionGridData = new GridData(770);
        sectionGridData.horizontalSpan = spanColumns;
        section.setLayoutData((Object)sectionGridData);
        Composite sectionClient = toolkit.createComposite((Composite)section, 0);
        GridData sectionClientGridData = new GridData(770);
        sectionClient.setLayoutData((Object)sectionClientGridData);
        GridLayout sectionClientLayout = new GridLayout();
        sectionClientLayout.marginHeight = 0;
        sectionClientLayout.marginWidth = 0;
        sectionClientLayout.verticalSpacing = 0;
        sectionClientLayout.horizontalSpacing = 0;
        sectionClientLayout.numColumns = sectionColumns;
        sectionClient.setLayout((Layout)sectionClientLayout);
        section.setClient((Control)sectionClient);
        return sectionClient;
    }

    protected void addDefine(String name, String value) {
        String dialogValue;
        InputDialog valueDialog;
        int valueRetval;
        String dialogName;
        InputDialog nameDialog = new InputDialog(this.getEditorSite().getShell(), "Enter Name", "Enter the name of this variable.", name, null);
        int nameRetval = nameDialog.open();
        if (nameRetval == 0 && (dialogName = nameDialog.getValue()) != null && dialogName.trim().length() > 0 && (valueRetval = (valueDialog = new InputDialog(this.getEditorSite().getShell(), "Enter Value", "Enter the value of this variable.", value, null)).open()) == 0 && (dialogValue = valueDialog.getValue()) != null && dialogValue.trim().length() > 0) {
            EOGeneratorModel.Define define = new EOGeneratorModel.Define(dialogName, dialogValue);
            List defines = this._model.getDefines();
            LinkedList<EOGeneratorModel.Define> newDefines = new LinkedList<EOGeneratorModel.Define>(defines);
            if (name != null && name.trim().length() > 0) {
                EOGeneratorModel.Define oldDefine = new EOGeneratorModel.Define(name, value);
                newDefines.remove(oldDefine);
            }
            newDefines.remove(define);
            newDefines.add(define);
            this._model.setDefines(newDefines);
            this._definesTableViewer.refresh();
        }
    }

    public TableViewer getModelsTableViewer() {
        return this._modelsTableViewer;
    }

    public TableViewer getRefModelsTableViewer() {
        return this._refModelsTableViewer;
    }

    public TableViewer getDefinesTableViewer() {
        return this._definesTableViewer;
    }

    protected class RefModelsTableContentProvider
    extends AbstractModelsTableContentProvider {
        protected RefModelsTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] models = EOGeneratorFormPage.this.getModel().getRefModels().toArray();
            return models;
        }
    }

    protected class ModelsTableContentProvider
    extends AbstractModelsTableContentProvider {
        protected ModelsTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] models = EOGeneratorFormPage.this.getModel().getModels().toArray();
            return models;
        }
    }

    protected abstract class AbstractModelsTableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        protected AbstractModelsTableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EOModelReference model = (EOModelReference)element;
            String name = model.getPath(EOGeneratorFormPage.this.getModel().getProjectPath());
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class DefinesTableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        protected DefinesTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] models = EOGeneratorFormPage.this.getModel().getDefines().toArray();
            return models;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EOGeneratorModel.Define define = (EOGeneratorModel.Define)element;
            String text = columnIndex == 0 ? define.getName() : (columnIndex == 1 ? define.getValue() : "");
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class DefinesDoubleClickListener
    implements IDoubleClickListener {
        protected DefinesDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            EOGeneratorModel.Define define;
            IStructuredSelection selection = (IStructuredSelection)EOGeneratorFormPage.this.getDefinesTableViewer().getSelection();
            if (!selection.isEmpty() && (define = (EOGeneratorModel.Define)selection.getFirstElement()) != null) {
                EOGeneratorFormPage.this.addDefine(define.getName(), define.getValue());
            }
        }
    }

    protected class DefineAddModelListener
    implements SelectionListener {
        protected DefineAddModelListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            EOGeneratorFormPage.this.addDefine("", "");
        }
    }

    protected class DefinesRemoveModelListener
    implements SelectionListener {
        protected DefinesRemoveModelListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection selection = (IStructuredSelection)EOGeneratorFormPage.this.getDefinesTableViewer().getSelection();
            if (!selection.isEmpty()) {
                List defines = EOGeneratorFormPage.this.getModel().getDefines();
                LinkedList newDefines = new LinkedList(defines);
                Object[] selections = selection.toArray();
                for (int i = 0; i < selections.length; ++i) {
                    newDefines.remove(selections[i]);
                }
                EOGeneratorFormPage.this.getModel().setDefines(newDefines);
                EOGeneratorFormPage.this.getDefinesTableViewer().refresh();
            }
        }
    }

    protected class RefModelAddModelListener
    implements SelectionListener {
        protected RefModelAddModelListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            DirectoryDialog directoryDialog = new DirectoryDialog(EOGeneratorFormPage.this.getEditorSite().getShell());
            directoryDialog.setMessage("Select the Reference EOModel to add.");
            String selectedDirectory = directoryDialog.open();
            if (selectedDirectory != null) {
                EOModelReference eoModel = new EOModelReference((IPath)new Path(selectedDirectory));
                this.addModel(eoModel);
            }
        }

        protected void addModel(EOModelReference eoModel) {
            List refModels = EOGeneratorFormPage.this.getModel().getRefModels();
            if (!refModels.contains(eoModel)) {
                LinkedList<EOModelReference> newRefModels = new LinkedList<EOModelReference>(refModels);
                newRefModels.add(eoModel);
                EOGeneratorFormPage.this.getModel().setRefModels(newRefModels);
                EOGeneratorFormPage.this.getRefModelsTableViewer().refresh();
            }
        }
    }

    protected class RefModelRemoveModelListener
    implements SelectionListener {
        protected RefModelRemoveModelListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection selection = (IStructuredSelection)EOGeneratorFormPage.this.getRefModelsTableViewer().getSelection();
            if (!selection.isEmpty()) {
                List refModels = EOGeneratorFormPage.this.getModel().getRefModels();
                LinkedList newRefModels = new LinkedList(refModels);
                Object[] selections = selection.toArray();
                for (int i = 0; i < selections.length; ++i) {
                    newRefModels.remove(selections[i]);
                }
                EOGeneratorFormPage.this.getModel().setRefModels(newRefModels);
                EOGeneratorFormPage.this.getRefModelsTableViewer().refresh();
            }
        }
    }

    protected class ModelAddModelListener
    implements SelectionListener {
        protected ModelAddModelListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            FileEditorInput editorInput = (FileEditorInput)EOGeneratorFormPage.this.getEditorInput();
            IFile eogenFile = editorInput.getFile();
            IProject project = eogenFile.getProject();
            ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(EOGeneratorFormPage.this.getEditorSite().getShell(), (IContainer)project, false, "Select the EOModel to add.");
            containerDialog.open();
            Object[] selectedContainers = containerDialog.getResult();
            if (selectedContainers != null && selectedContainers.length > 0) {
                IPath selectedPath = (IPath)selectedContainers[0];
                IFolder selectedFolder = project.getParent().getFolder(selectedPath);
                IPath modelPath = selectedFolder.getLocation();
                EOModelReference eoModel = new EOModelReference(modelPath);
                this.addModel(eoModel);
            }
        }

        protected void addModel(EOModelReference eoModel) {
            List models = EOGeneratorFormPage.this.getModel().getModels();
            if (!models.contains(eoModel)) {
                LinkedList<EOModelReference> newModels = new LinkedList<EOModelReference>(models);
                newModels.add(eoModel);
                EOGeneratorFormPage.this.getModel().setModels(newModels);
                EOGeneratorFormPage.this.getModelsTableViewer().refresh();
            }
        }
    }

    protected class ModelRemoveModelListener
    implements SelectionListener {
        protected ModelRemoveModelListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection selection = (IStructuredSelection)EOGeneratorFormPage.this.getModelsTableViewer().getSelection();
            if (!selection.isEmpty()) {
                List models = EOGeneratorFormPage.this.getModel().getModels();
                LinkedList newModels = new LinkedList(models);
                Object[] selections = selection.toArray();
                for (int i = 0; i < selections.length; ++i) {
                    newModels.remove(selections[i]);
                }
                EOGeneratorFormPage.this.getModel().setModels(newModels);
                EOGeneratorFormPage.this.getModelsTableViewer().refresh();
            }
        }
    }

    protected class DirtyModelListener
    implements PropertyChangeListener {
        protected DirtyModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("dirty".equals(event.getPropertyName())) {
                EOGeneratorFormPage.this.getEditor().editorDirtyStateChanged();
            }
        }
    }
}

